/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import java.util.Iterator;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

class FilterCellIterator
extends CellIterator {
    final Iterator<Cell> baseIter;
    final Shape shapeFilter;

    FilterCellIterator(Iterator<Cell> baseIter, Shape shapeFilter) {
        this.baseIter = baseIter;
        this.shapeFilter = shapeFilter;
    }

    @Override
    public boolean hasNext() {
        this.thisCell = null;
        if (this.nextCell != null) {
            return true;
        }
        while (this.baseIter.hasNext()) {
            this.nextCell = this.baseIter.next();
            if (this.shapeFilter == null) {
                return true;
            }
            SpatialRelation rel = this.nextCell.getShape().relate(this.shapeFilter);
            if (!rel.intersects()) continue;
            this.nextCell.setShapeRel(rel);
            if (rel == SpatialRelation.WITHIN) {
                this.nextCell.setLeaf();
            }
            return true;
        }
        return false;
    }
}

