/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.BaseShape;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.BufferedLine;

public class BufferedLineString
extends BaseShape<SpatialContext> {
    private final ShapeCollection<BufferedLine> segments;
    private final double buf;

    public BufferedLineString(List<Point> points, double buf, SpatialContext ctx) {
        this(points, buf, false, ctx);
    }

    public BufferedLineString(List<Point> points, double buf, boolean expandBufForLongitudeSkew, SpatialContext ctx) {
        super(ctx);
        this.buf = buf;
        if (points.isEmpty()) {
            this.segments = ctx.makeCollection(Collections.emptyList());
        } else {
            ArrayList<BufferedLine> segments = new ArrayList<BufferedLine>(points.size() - 1);
            Point prevPoint = null;
            for (Point point : points) {
                if (prevPoint != null) {
                    double segBuf = buf;
                    if (expandBufForLongitudeSkew) {
                        segBuf = BufferedLine.expandBufForLongitudeSkew(prevPoint, point, buf);
                    }
                    segments.add(new BufferedLine(prevPoint, point, segBuf, ctx));
                }
                prevPoint = point;
            }
            if (segments.isEmpty()) {
                segments.add(new BufferedLine(prevPoint, prevPoint, buf, ctx));
            }
            this.segments = ctx.makeCollection(segments);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    @Override
    public Shape getBuffered(double distance, SpatialContext ctx) {
        return ctx.makeBufferedLineString(this.getPoints(), this.buf + distance);
    }

    public ShapeCollection<BufferedLine> getSegments() {
        return this.segments;
    }

    public double getBuf() {
        return this.buf;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        return this.segments.getArea(ctx);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        return this.segments.relate(other);
    }

    @Override
    public boolean hasArea() {
        return this.segments.hasArea();
    }

    @Override
    public Point getCenter() {
        return this.segments.getCenter();
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.segments.getBoundingBox();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(100);
        str.append("BufferedLineString(buf=").append(this.buf).append(" pts=");
        boolean first = true;
        for (Point point : this.getPoints()) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(point.getX()).append(' ').append(point.getY());
        }
        str.append(')');
        return str.toString();
    }

    public List<Point> getPoints() {
        if (this.segments.isEmpty()) {
            return Collections.emptyList();
        }
        final List<BufferedLine> lines = this.segments.getShapes();
        return new AbstractList<Point>(){

            @Override
            public Point get(int index) {
                if (index == 0) {
                    return ((BufferedLine)lines.get(0)).getA();
                }
                return ((BufferedLine)lines.get(index - 1)).getB();
            }

            @Override
            public int size() {
                return lines.size() + 1;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedLineString that = (BufferedLineString)o;
        if (Double.compare(that.buf, this.buf) != 0) {
            return false;
        }
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int result = this.segments.hashCode();
        long temp = this.buf != 0.0 ? Double.doubleToLongBits(this.buf) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

