/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.stream.reservation.write;

import java.io.DataOutput;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import org.apache.solr.analytics.stream.reservation.write.ReductionDataWriter;

public abstract class ReductionCheckedDataWriter<C>
extends ReductionDataWriter<C> {
    private final BooleanSupplier existsSupplier;

    public ReductionCheckedDataWriter(DataOutput output, C extractor, BooleanSupplier existsSupplier) {
        super(output, extractor);
        this.existsSupplier = existsSupplier;
    }

    @Override
    public void write() throws IOException {
        boolean exists = this.existsSupplier.getAsBoolean();
        this.output.writeBoolean(exists);
        if (exists) {
            this.checkedWrite();
        }
    }

    protected abstract void checkedWrite() throws IOException;
}

