/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mif;

import org.apache.tika.metadata.Metadata;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class MIFContentHandler
extends DefaultHandler {
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private final ContentHandler handler;
    private final Metadata metadata;
    private boolean inContent = false;
    private boolean inPage = false;
    private int bodyPageCount = 0;
    private int masterPageCount = 0;
    private int referencePageCount = 0;

    MIFContentHandler(ContentHandler handler, Metadata metadata) {
        this.handler = handler;
        this.metadata = metadata;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("PageType".equals(localName)) {
            this.inPage = true;
        }
        if ("Para".equals(localName)) {
            this.handler.startElement("http://www.w3.org/1999/xhtml", "p", "p", EMPTY_ATTRIBUTES);
        }
        if ("String".equals(localName)) {
            this.inContent = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inContent) {
            this.handler.characters(ch, start, length);
        }
        if (this.inPage) {
            switch (String.valueOf(ch)) {
                case "BodyPage": {
                    ++this.bodyPageCount;
                    break;
                }
                case "LeftMasterPage": 
                case "RightMasterPage": 
                case "OtherMasterPage": {
                    ++this.masterPageCount;
                    break;
                }
                case "ReferencePage": {
                    ++this.referencePageCount;
                    break;
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("String".equals(localName)) {
            this.inContent = false;
        }
        if ("Para".equals(localName)) {
            this.handler.endElement("http://www.w3.org/1999/xhtml", "p", "p");
        }
        if ("PageType".equals(localName)) {
            this.inPage = false;
        }
    }

    @Override
    public void endDocument() {
        this.metadata.set("PageCount", String.valueOf(this.bodyPageCount));
        this.metadata.set("MasterPageCount", String.valueOf(this.masterPageCount));
        this.metadata.set("ReferencePageCount", String.valueOf(this.referencePageCount));
        this.metadata.set("TotalPageCount", String.valueOf(this.bodyPageCount + this.referencePageCount + this.masterPageCount));
    }
}

