/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.onenote.ExtendedGUID;
import org.apache.tika.parser.microsoft.onenote.FileNodePtr;
import org.apache.tika.parser.microsoft.onenote.OneNoteDirectFileResource;
import org.apache.tika.parser.microsoft.onenote.OneNoteDocument;
import org.apache.tika.parser.microsoft.onenote.OneNoteLegacyDumpStrings;
import org.apache.tika.parser.microsoft.onenote.OneNotePtr;
import org.apache.tika.parser.microsoft.onenote.OneNoteTreeWalker;
import org.apache.tika.parser.microsoft.onenote.OneNoteTreeWalkerOptions;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OneNoteParser
extends AbstractParser {
    private static final Map<MediaType, List<String>> typesMap = new HashMap<MediaType, List<String>>();
    private static final long serialVersionUID = -5504243905998074168L;
    private static final Set<MediaType> SUPPORTED_TYPES;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        try (TemporaryResources temporaryResources = new TemporaryResources();
             TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)stream, (TemporaryResources)temporaryResources);
             OneNoteDirectFileResource oneNoteDirectFileResource = new OneNoteDirectFileResource(tikaInputStream.getFile());){
            temporaryResources.addResource((Closeable)oneNoteDirectFileResource);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            OneNoteDocument oneNoteDocument = this.createOneNoteDocumentFromDirectFileResource(oneNoteDirectFileResource);
            if (!oneNoteDocument.header.isLegacy()) {
                metadata.set("buildNumberCreated", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberCreated));
                metadata.set("buildNumberLastWroteToFile", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberLastWroteToFile));
                metadata.set("buildNumberNewestWritten", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberNewestWritten));
                metadata.set("buildNumberOldestWritten", "0x" + Long.toHexString(oneNoteDocument.header.buildNumberOldestWritten));
                metadata.set("cbExpectedFileLength", "0x" + Long.toHexString(oneNoteDocument.header.cbExpectedFileLength));
                metadata.set("cbFreeSpaceInFreeChunkList", "0x" + Long.toHexString(oneNoteDocument.header.cbFreeSpaceInFreeChunkList));
                metadata.set("cbLegacyExpectedFileLength", "0x" + Long.toHexString(oneNoteDocument.header.cbLegacyExpectedFileLength));
                metadata.set("cbLegacyFreeSpaceInFreeChunkList", "0x" + Long.toHexString(oneNoteDocument.header.cbLegacyFreeSpaceInFreeChunkList));
                metadata.set("crcName", "0x" + Long.toHexString(oneNoteDocument.header.crcName));
                metadata.set("cTransactionsInLog", "0x" + Long.toHexString(oneNoteDocument.header.cTransactionsInLog));
                metadata.set("ffvLastCodeThatWroteToThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvLastCodeThatWroteToThisFile));
                metadata.set("ffvNewestCodeThatHasWrittenToThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvNewestCodeThatHasWrittenToThisFile));
                metadata.set("ffvOldestCodeThatMayReadThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvOldestCodeThatMayReadThisFile));
                metadata.set("ffvOldestCodeThatHasWrittenToThisFile", "0x" + Long.toHexString(oneNoteDocument.header.ffvOldestCodeThatHasWrittenToThisFile));
                metadata.set("grfDebugLogFlags", "0x" + Long.toHexString(oneNoteDocument.header.grfDebugLogFlags));
                metadata.set("nFileVersionGeneration", "0x" + Long.toHexString(oneNoteDocument.header.nFileVersionGeneration));
                metadata.set("rgbPlaceholder", "0x" + Long.toHexString(oneNoteDocument.header.rgbPlaceholder));
                Pair roleAndContext = Pair.of((Object)1L, (Object)ExtendedGUID.nil());
                OneNoteTreeWalker oneNoteTreeWalker = new OneNoteTreeWalker(new OneNoteTreeWalkerOptions(), oneNoteDocument, oneNoteDirectFileResource, xhtml, metadata, context, (Pair<Long, ExtendedGUID>)roleAndContext);
                oneNoteTreeWalker.walkTree();
                if (!oneNoteTreeWalker.getAuthors().isEmpty()) {
                    metadata.set(Property.externalTextBag((String)"authors"), oneNoteTreeWalker.getAuthors().toArray(new String[0]));
                }
                if (!oneNoteTreeWalker.getMostRecentAuthors().isEmpty()) {
                    metadata.set(Property.externalTextBag((String)"mostRecentAuthors"), oneNoteTreeWalker.getMostRecentAuthors().toArray(new String[0]));
                }
                if (!oneNoteTreeWalker.getOriginalAuthors().isEmpty()) {
                    metadata.set(Property.externalTextBag((String)"originalAuthors"), oneNoteTreeWalker.getOriginalAuthors().toArray(new String[0]));
                }
                if (!Instant.MAX.equals(oneNoteTreeWalker.getCreationTimestamp())) {
                    metadata.set("creationTimestamp", String.valueOf(oneNoteTreeWalker.getCreationTimestamp()));
                }
                if (!Instant.MIN.equals(oneNoteTreeWalker.getLastModifiedTimestamp())) {
                    metadata.set("lastModifiedTimestamp", String.valueOf(oneNoteTreeWalker.getLastModifiedTimestamp().toEpochMilli()));
                }
                if (oneNoteTreeWalker.getLastModified() > Long.MIN_VALUE) {
                    metadata.set("lastModified", String.valueOf(oneNoteTreeWalker.getLastModified()));
                }
            } else {
                OneNoteLegacyDumpStrings dumpStrings = new OneNoteLegacyDumpStrings(oneNoteDirectFileResource, xhtml);
                dumpStrings.dump();
            }
            xhtml.endDocument();
        }
    }

    public OneNoteDocument createOneNoteDocumentFromDirectFileResource(OneNoteDirectFileResource oneNoteDirectFileResource) throws IOException, TikaException {
        OneNoteDocument oneNoteDocument = new OneNoteDocument();
        OneNotePtr oneNotePtr = new OneNotePtr(oneNoteDocument, oneNoteDirectFileResource);
        oneNoteDocument.header = oneNotePtr.deserializeHeader();
        if (!oneNoteDocument.header.isLegacy()) {
            oneNotePtr.reposition(oneNoteDocument.header.fcrFileNodeListRoot);
            FileNodePtr curPath = new FileNodePtr();
            oneNotePtr.deserializeFileNodeList(oneNoteDocument.root, curPath);
        }
        return oneNoteDocument;
    }

    static {
        typesMap.put(MediaType.application((String)"onenote; format=one"), Arrays.asList("ONE "));
        SUPPORTED_TYPES = Collections.unmodifiableSet(typesMap.keySet());
    }
}

