/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import com.google.common.util.concurrent.AtomicDouble;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.ActionThrottle;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.cloud.api.collections.SplitShardCmd;
import org.apache.solr.cloud.autoscaling.sim.LiveNodesSet;
import org.apache.solr.cloud.autoscaling.sim.SimCloudManager;
import org.apache.solr.cloud.autoscaling.sim.SimDistribStateManager;
import org.apache.solr.cloud.autoscaling.sim.SimNodeStateProvider;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimClusterStateProvider
implements ClusterStateProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final long DEFAULT_DOC_SIZE_BYTES = 2048L;
    private static final String BUFFERED_UPDATES = "__buffered_updates__";
    private final LiveNodesSet liveNodes;
    private final SimDistribStateManager stateManager;
    private final SimCloudManager cloudManager;
    private final Map<String, List<ReplicaInfo>> nodeReplicaMap = new ConcurrentHashMap<String, List<ReplicaInfo>>();
    private final Map<String, Map<String, List<ReplicaInfo>>> colShardReplicaMap = new ConcurrentHashMap<String, Map<String, List<ReplicaInfo>>>();
    private final Map<String, Object> clusterProperties = new ConcurrentHashMap<String, Object>();
    private final Map<String, Map<String, Object>> collProperties = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Map<String, Object>>> sliceProperties = new ConcurrentHashMap<String, Map<String, Map<String, Object>>>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Map<String, ActionThrottle>> leaderThrottles = new ConcurrentHashMap<String, Map<String, ActionThrottle>>();
    private final Map<String, Long> defaultOpDelays = new ConcurrentHashMap<String, Long>();
    private final Map<String, Map<String, Long>> opDelays = new ConcurrentHashMap<String, Map<String, Long>>();
    private volatile int clusterStateVersion = 0;
    private volatile String overseerLeader = null;
    private volatile Map<String, Object> lastSavedProperties = null;
    private final AtomicReference<Map<String, DocCollection>> collectionsStatesRef = new AtomicReference();
    private final Random bulkUpdateRandom = new Random(0L);
    private transient boolean closed;
    private static final Set<String> NO_COPY_PROPS = new HashSet<String>(Arrays.asList("core_node_name", "node_name", "base_url", "core"));

    public SimClusterStateProvider(LiveNodesSet liveNodes, SimCloudManager cloudManager) throws Exception {
        this.liveNodes = liveNodes;
        for (String nodeId : liveNodes.get()) {
            this.createEphemeralLiveNode(nodeId);
        }
        this.cloudManager = cloudManager;
        this.stateManager = cloudManager.getSimDistribStateManager();
        this.defaultOpDelays.put(CollectionParams.CollectionAction.MOVEREPLICA.name(), 5000L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.DELETEREPLICA.name(), 5000L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.ADDREPLICA.name(), 500L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.SPLITSHARD.name(), 5000L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.CREATESHARD.name(), 5000L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.DELETESHARD.name(), 5000L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.CREATE.name(), 500L);
        this.defaultOpDelays.put(CollectionParams.CollectionAction.DELETE.name(), 5000L);
    }

    public void copyFrom(ClusterStateProvider other) throws Exception {
        ClusterState state = other.getClusterState();
        this.simSetClusterState(state);
        this.clusterProperties.clear();
        this.clusterProperties.putAll(other.getClusterProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSetClusterState(ClusterState initialState) throws Exception {
        this.lock.lockInterruptibly();
        try {
            this.collProperties.clear();
            this.colShardReplicaMap.clear();
            this.sliceProperties.clear();
            this.nodeReplicaMap.clear();
            this.liveNodes.clear();
            for (String nodeId : this.stateManager.listData("/live_nodes")) {
                if (this.stateManager.hasData("/live_nodes/" + nodeId)) {
                    this.stateManager.removeData("/live_nodes/" + nodeId, -1);
                }
                if (this.stateManager.hasData("/autoscaling/nodeAdded/" + nodeId)) {
                    this.stateManager.removeData("/autoscaling/nodeAdded/" + nodeId, -1);
                }
                if (!this.stateManager.hasData("/autoscaling/nodeLost/" + nodeId)) continue;
                this.stateManager.removeData("/autoscaling/nodeLost/" + nodeId, -1);
            }
            this.liveNodes.addAll(initialState.getLiveNodes());
            for (String nodeId : this.liveNodes.get()) {
                this.createEphemeralLiveNode(nodeId);
            }
            initialState.forEachCollection(dc -> {
                this.collProperties.computeIfAbsent(dc.getName(), name -> new ConcurrentHashMap()).putAll(dc.getProperties());
                this.opDelays.computeIfAbsent(dc.getName(), o -> new HashMap()).putAll(this.defaultOpDelays);
                dc.getSlices().forEach(s -> {
                    this.sliceProperties.computeIfAbsent(dc.getName(), name -> new ConcurrentHashMap()).computeIfAbsent(s.getName(), o -> new HashMap()).putAll(s.getProperties());
                    Replica leader = s.getLeader();
                    s.getReplicas().forEach(r -> {
                        HashMap<String, String> props = new HashMap<String, String>(r.getProperties());
                        if (leader != null && r.getName().equals(leader.getName())) {
                            props.put("leader", "true");
                        }
                        ReplicaInfo ri = new ReplicaInfo(r.getName(), r.getCoreName(), dc.getName(), s.getName(), r.getType(), r.getNodeName(), props);
                        if (leader != null && r.getName().equals(leader.getName())) {
                            ri.getVariables().put("leader", "true");
                        }
                        if (this.liveNodes.get().contains(r.getNodeName())) {
                            this.nodeReplicaMap.computeIfAbsent(r.getNodeName(), o -> Collections.synchronizedList(new ArrayList())).add(ri);
                            this.colShardReplicaMap.computeIfAbsent(ri.getCollection(), name -> new ConcurrentHashMap()).computeIfAbsent(ri.getShard(), shard -> new ArrayList()).add(ri);
                        } else {
                            log.warn("- dropping replica because its node {} is not live: {}", (Object)r.getNodeName(), r);
                        }
                    });
                });
            });
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simResetLeaderThrottles() {
        this.leaderThrottles.clear();
    }

    private ActionThrottle getThrottle(String collection, String shard) {
        return this.leaderThrottles.computeIfAbsent(collection, coll -> new ConcurrentHashMap()).computeIfAbsent(shard, s -> new ActionThrottle("leader", 5000L, this.cloudManager.getTimeSource()));
    }

    public String simGetRandomNode() {
        return this.simGetRandomNode(this.cloudManager.getRandom());
    }

    public String simGetRandomNode(Random random) {
        if (this.liveNodes.isEmpty()) {
            return null;
        }
        ArrayList<String> nodes = new ArrayList<String>(this.liveNodes.get());
        return (String)nodes.get(random.nextInt(nodes.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicaInfo getReplicaInfo(Replica r) {
        List list;
        List list2 = list = this.nodeReplicaMap.computeIfAbsent(r.getNodeName(), o -> Collections.synchronizedList(new ArrayList()));
        synchronized (list2) {
            for (ReplicaInfo ri : list) {
                if (!r.getCoreName().equals(ri.getCore()) || !r.getName().equals(ri.getName())) continue;
                return ri;
            }
        }
        return null;
    }

    public void simAddNode(String nodeId) throws Exception {
        this.ensureNotClosed();
        if (this.liveNodes.contains(nodeId)) {
            throw new Exception("Node " + nodeId + " already exists");
        }
        this.createEphemeralLiveNode(nodeId);
        this.nodeReplicaMap.computeIfAbsent(nodeId, o -> Collections.synchronizedList(new ArrayList()));
        this.liveNodes.add(nodeId);
        this.updateOverseerLeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean simRemoveNode(String nodeId) throws Exception {
        this.ensureNotClosed();
        this.lock.lockInterruptibly();
        try {
            HashSet<String> collections = new HashSet<String>();
            boolean res = this.liveNodes.remove(nodeId);
            this.setReplicaStates(nodeId, Replica.State.DOWN, collections);
            if (!collections.isEmpty()) {
                this.collectionsStatesRef.set(null);
            }
            this.stateManager.getRoot().removeEphemeralChildren(nodeId);
            AutoScalingConfig cfg = this.stateManager.getAutoScalingConfig(null);
            if (cfg.hasTriggerForEvents(new TriggerEventType[]{TriggerEventType.NODELOST})) {
                String path = "/autoscaling/nodeLost/" + nodeId;
                byte[] json = Utils.toJSON(Collections.singletonMap("timestamp", this.cloudManager.getTimeSource().getEpochTimeNs()));
                this.stateManager.makePath(path, json, CreateMode.PERSISTENT, false);
                log.debug(" -- created marker: {}", (Object)path);
            }
            this.updateOverseerLeader();
            if (!collections.isEmpty()) {
                this.simRunLeaderElection(collections, true);
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simRemoveDeadNodes() throws Exception {
        this.lock.lockInterruptibly();
        try {
            HashSet<String> myNodes = new HashSet<String>(this.nodeReplicaMap.keySet());
            myNodes.removeAll(this.liveNodes.get());
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    private synchronized void updateOverseerLeader() throws Exception {
        if (this.overseerLeader != null && this.liveNodes.contains(this.overseerLeader)) {
            return;
        }
        String path = "/overseer_elect/leader";
        if (this.liveNodes.isEmpty()) {
            this.overseerLeader = null;
            try {
                this.cloudManager.getDistribStateManager().removeData(path, -1);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return;
        }
        this.overseerLeader = this.liveNodes.iterator().next();
        log.debug("--- new Overseer leader: {}", (Object)this.overseerLeader);
        HashMap<String, String> id = new HashMap<String, String>();
        id.put("id", this.cloudManager.getTimeSource().getTimeNs() + "-" + this.overseerLeader + "-n_0000000000");
        try {
            this.cloudManager.getDistribStateManager().makePath(path, Utils.toJSON(id), CreateMode.EPHEMERAL, false);
        }
        catch (Exception e) {
            log.warn("Exception saving overseer leader id", (Throwable)e);
        }
    }

    public synchronized String simGetOverseerLeader() {
        return this.overseerLeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReplicaStates(String nodeId, Replica.State state, Set<String> changedCollections) {
        List replicas;
        List list = replicas = this.nodeReplicaMap.computeIfAbsent(nodeId, o -> Collections.synchronizedList(new ArrayList()));
        synchronized (list) {
            replicas.forEach(r -> {
                r.getVariables().put("state", state.toString());
                if (state != Replica.State.ACTIVE) {
                    r.getVariables().remove("leader");
                }
                changedCollections.add(r.getCollection());
            });
        }
    }

    private void createEphemeralLiveNode(String nodeId) throws Exception {
        SimDistribStateManager mgr = this.stateManager.withEphemeralId(nodeId);
        mgr.makePath("/live_nodes/" + nodeId, null, CreateMode.EPHEMERAL, true);
        AutoScalingConfig cfg = this.stateManager.getAutoScalingConfig(null);
        if (cfg.hasTriggerForEvents(new TriggerEventType[]{TriggerEventType.NODEADDED})) {
            byte[] json = Utils.toJSON(Collections.singletonMap("timestamp", this.cloudManager.getTimeSource().getEpochTimeNs()));
            String path = "/autoscaling/nodeAdded/" + nodeId;
            log.debug("-- creating marker: {}", (Object)path);
            mgr.makePath(path, json, CreateMode.EPHEMERAL, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean simRestoreNode(String nodeId) throws Exception {
        this.liveNodes.add(nodeId);
        this.createEphemeralLiveNode(nodeId);
        HashSet<String> collections = new HashSet<String>();
        this.lock.lockInterruptibly();
        try {
            this.setReplicaStates(nodeId, Replica.State.RECOVERING, collections);
        }
        finally {
            this.lock.unlock();
        }
        this.cloudManager.getTimeSource().sleep(1000L);
        this.lock.lockInterruptibly();
        try {
            this.setReplicaStates(nodeId, Replica.State.ACTIVE, collections);
            if (!collections.isEmpty()) {
                this.collectionsStatesRef.set(null);
                this.simRunLeaderElection(collections, true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simAddReplica(ZkNodeProps message, NamedList results) throws Exception {
        if (message.getStr("async") != null) {
            results.add("requestid", (Object)message.getStr("async"));
        }
        ClusterState clusterState = this.getClusterState();
        DocCollection coll = clusterState.getCollection(message.getStr("collection"));
        AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper = new AtomicReference<PolicyHelper.SessionWrapper>();
        Replica.Type replicaType = Replica.Type.valueOf((String)message.getStr("type", Replica.Type.NRT.name()).toUpperCase(Locale.ROOT));
        EnumMap<Replica.Type, Integer> replicaTypesVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
        replicaTypesVsCount.put(Replica.Type.NRT, message.getInt("nrtReplicas", Integer.valueOf(replicaType == Replica.Type.NRT ? 1 : 0)));
        replicaTypesVsCount.put(Replica.Type.TLOG, message.getInt("tlogReplicas", Integer.valueOf(replicaType == Replica.Type.TLOG ? 1 : 0)));
        replicaTypesVsCount.put(Replica.Type.PULL, message.getInt("pullReplicas", Integer.valueOf(replicaType == Replica.Type.PULL ? 1 : 0)));
        int totalReplicas = 0;
        for (Map.Entry entry : replicaTypesVsCount.entrySet()) {
            totalReplicas += ((Integer)entry.getValue()).intValue();
        }
        if (totalReplicas > 1) {
            if (message.getStr("name") != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create " + totalReplicas + " replicas if 'name' parameter is specified");
            }
            if (message.getStr("coreNodeName") != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create " + totalReplicas + " replicas if 'coreNodeName' parameter is specified");
            }
        }
        List<ReplicaPosition> replicaPositions = AddReplicaCmd.buildReplicaPositions(this.cloudManager, clusterState, coll.getName(), message, replicaTypesVsCount, sessionWrapper);
        for (ReplicaPosition replicaPosition : replicaPositions) {
            AddReplicaCmd.CreateReplica createReplica = AddReplicaCmd.assignReplicaDetails(this.cloudManager, clusterState, message, replicaPosition);
            if (message.getStr("coreNodeName") == null) {
                createReplica.coreNodeName = Assign.assignCoreNodeName(this.stateManager, coll);
            }
            ReplicaInfo ri = new ReplicaInfo(createReplica.coreNodeName, createReplica.coreName, createReplica.collectionName, createReplica.sliceName, createReplica.replicaType, createReplica.node, message.getProperties());
            this.simAddReplica(ri.getNode(), ri, true);
        }
        if (sessionWrapper.get() != null) {
            sessionWrapper.get().release();
        }
        results.add("success", (Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simAddReplica(String nodeId, ReplicaInfo replicaInfo, boolean runLeaderElection) throws Exception {
        this.ensureNotClosed();
        this.lock.lockInterruptibly();
        try {
            for (Map.Entry<String, List<ReplicaInfo>> e : this.nodeReplicaMap.entrySet()) {
                List<ReplicaInfo> replicas;
                List<ReplicaInfo> list = replicas = e.getValue();
                synchronized (list) {
                    for (ReplicaInfo ri : replicas) {
                        if (ri.getCore().equals(replicaInfo.getCore())) {
                            throw new Exception("Duplicate SolrCore name for existing=" + ri + " on node " + e.getKey() + " and new=" + replicaInfo);
                        }
                        if (!ri.getName().equals(replicaInfo.getName()) || !ri.getCollection().equals(replicaInfo.getCollection())) continue;
                        throw new Exception("Duplicate coreNode name for existing=" + ri + " on node " + e.getKey() + " and new=" + replicaInfo);
                    }
                }
            }
            if (!this.liveNodes.contains(nodeId)) {
                throw new Exception("Target node " + nodeId + " is not live: " + this.liveNodes);
            }
            if (replicaInfo.getCore() == null) {
                throw new Exception("Missing core: " + replicaInfo);
            }
            replicaInfo.getVariables().remove("shard");
            if (replicaInfo.getName() == null) {
                throw new Exception("Missing name: " + replicaInfo);
            }
            if (replicaInfo.getNode() == null) {
                throw new Exception("Missing node: " + replicaInfo);
            }
            if (!replicaInfo.getNode().equals(nodeId)) {
                throw new Exception("Wrong node (not " + nodeId + "): " + replicaInfo);
            }
            this.opDelay(replicaInfo.getCollection(), CollectionParams.CollectionAction.ADDREPLICA.name());
            replicaInfo.getVariables().put("state", Replica.State.ACTIVE.toString());
            if (replicaInfo.getVariable(Variable.Type.CORE_IDX.metricsAttribute) == null) {
                replicaInfo.getVariables().put(Variable.Type.CORE_IDX.metricsAttribute, new AtomicLong(SimCloudManager.DEFAULT_IDX_SIZE_BYTES));
                replicaInfo.getVariables().put("INDEX.sizeInGB", new AtomicDouble(((Double)Variable.Type.CORE_IDX.convertVal((Object)SimCloudManager.DEFAULT_IDX_SIZE_BYTES)).doubleValue()));
            }
            this.nodeReplicaMap.computeIfAbsent(nodeId, o -> Collections.synchronizedList(new ArrayList())).add(replicaInfo);
            this.colShardReplicaMap.computeIfAbsent(replicaInfo.getCollection(), c -> new ConcurrentHashMap()).computeIfAbsent(replicaInfo.getShard(), s -> new ArrayList()).add(replicaInfo);
            Map values = this.cloudManager.getSimNodeStateProvider().simGetAllNodeValues().computeIfAbsent(nodeId, id -> new ConcurrentHashMap<String, Object>(SimCloudManager.createNodeValues(id)));
            Number cores = (Number)values.get("cores");
            if (cores == null) {
                cores = 0;
            }
            this.cloudManager.getSimNodeStateProvider().simSetNodeValue(nodeId, "cores", cores.intValue() + 1);
            Number disk = (Number)values.get("freedisk");
            if (disk == null) {
                throw new Exception("Missing 'freedisk' in node metrics for node " + nodeId);
            }
            long replicaSize = ((Number)replicaInfo.getVariable(Variable.Type.CORE_IDX.metricsAttribute)).longValue();
            Number replicaSizeGB = (Number)Variable.Type.CORE_IDX.convertVal((Object)replicaSize);
            this.cloudManager.getSimNodeStateProvider().simSetNodeValue(nodeId, "freedisk", disk.doubleValue() - replicaSizeGB.doubleValue());
            String registry = SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, replicaInfo.getCollection(), replicaInfo.getShard(), Utils.parseMetricsReplicaName((String)replicaInfo.getCollection(), (String)replicaInfo.getCore()));
            this.cloudManager.getMetricManager().registry(registry).counter("UPDATE./update.requests");
            this.cloudManager.getMetricManager().registry(registry).counter("QUERY./select.requests");
            this.cloudManager.getMetricManager().registerGauge(null, registry, () -> replicaSize, "", true, Variable.Type.CORE_IDX.metricsAttribute, new String[0]);
            this.collectionsStatesRef.set(null);
            log.trace("-- simAddReplica {}", (Object)replicaInfo);
            if (runLeaderElection) {
                this.simRunLeaderElection(replicaInfo.getCollection(), replicaInfo.getShard(), true);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void simRemoveReplica(String nodeId, String collection, String coreNodeName) throws Exception {
        this.ensureNotClosed();
        this.lock.lockInterruptibly();
        try {
            List replicas;
            List list = replicas = this.nodeReplicaMap.computeIfAbsent(nodeId, o -> Collections.synchronizedList(new ArrayList()));
            synchronized (list) {
                int i = 0;
                while (i < replicas.size()) {
                    if (collection.equals(((ReplicaInfo)replicas.get(i)).getCollection()) && coreNodeName.equals(((ReplicaInfo)replicas.get(i)).getName())) {
                        ReplicaInfo ri = (ReplicaInfo)replicas.remove(i);
                        this.colShardReplicaMap.computeIfAbsent(ri.getCollection(), c -> new ConcurrentHashMap()).computeIfAbsent(ri.getShard(), s -> new ArrayList()).remove(ri);
                        this.collectionsStatesRef.set(null);
                        this.opDelay(ri.getCollection(), CollectionParams.CollectionAction.DELETEREPLICA.name());
                        if (this.liveNodes.contains(nodeId)) {
                            Number cores = (Number)this.cloudManager.getSimNodeStateProvider().simGetNodeValue(nodeId, "cores");
                            if (cores == null) throw new Exception("Unexpected value of 'cores' (" + cores + ") on node: " + nodeId);
                            if (cores.intValue() == 0) {
                                throw new Exception("Unexpected value of 'cores' (" + cores + ") on node: " + nodeId);
                            }
                            this.cloudManager.getSimNodeStateProvider().simSetNodeValue(nodeId, "cores", cores.intValue() - 1);
                            Number disk = (Number)this.cloudManager.getSimNodeStateProvider().simGetNodeValue(nodeId, "freedisk");
                            if (disk == null) throw new Exception("Unexpected value of 'freedisk' (" + disk + ") on node: " + nodeId);
                            if (disk.doubleValue() == 0.0) {
                                throw new Exception("Unexpected value of 'freedisk' (" + disk + ") on node: " + nodeId);
                            }
                            if (ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute) == null) {
                                throw new RuntimeException("Missing replica size: " + ri);
                            }
                            long replicaSize = ((Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute)).longValue();
                            Number replicaSizeGB = (Number)Variable.Type.CORE_IDX.convertVal((Object)replicaSize);
                            this.cloudManager.getSimNodeStateProvider().simSetNodeValue(nodeId, "freedisk", disk.doubleValue() + replicaSizeGB.doubleValue());
                        }
                        log.trace("-- simRemoveReplica {}", (Object)ri);
                        this.simRunLeaderElection(ri.getCollection(), ri.getShard(), true);
                        return;
                    }
                    ++i;
                }
                throw new Exception("Replica " + coreNodeName + " not found on node " + nodeId);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private ClusterState saveClusterState(ClusterState state) throws IOException {
        this.ensureNotClosed();
        byte[] data = Utils.toJSON((Object)state);
        try {
            int version;
            VersionedData oldData = this.stateManager.getData("/clusterstate.json");
            int n = version = oldData != null ? oldData.getVersion() : 0;
            assert (this.clusterStateVersion == version) : "local clusterStateVersion out of sync";
            this.stateManager.setData("/clusterstate.json", data, version);
            log.debug("** saved cluster state version {}", (Object)version);
            ++this.clusterStateVersion;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return state;
    }

    private void opDelay(String collection, String op) throws InterruptedException {
        Map<String, Long> delays = this.opDelays.get(collection);
        if (delays == null || delays.isEmpty() || !delays.containsKey(op)) {
            return;
        }
        this.cloudManager.getTimeSource().sleep(delays.get(op).longValue());
    }

    public void simSetOpDelays(String collection, Map<String, Long> delays) {
        Map currentDelays = this.opDelays.getOrDefault(collection, Collections.emptyMap());
        HashMap newDelays = new HashMap(currentDelays);
        delays.forEach((k, v) -> {
            if (v == null) {
                newDelays.remove(k);
            } else {
                newDelays.put(k, v);
            }
        });
        this.opDelays.put(collection, newDelays);
    }

    private void simRunLeaderElection(Collection<String> collections, boolean saveClusterState) throws Exception {
        this.ensureNotClosed();
        if (saveClusterState) {
            this.lock.lockInterruptibly();
            try {
                this.collectionsStatesRef.set(null);
            }
            finally {
                this.lock.unlock();
            }
        }
        ClusterState state = this.getClusterState();
        state.forEachCollection(dc -> {
            if (!collections.contains(dc.getName())) {
                return;
            }
            dc.getSlices().forEach(s -> {
                if (log.isTraceEnabled()) {
                    log.trace("-- submit leader election for {} / {}", (Object)dc.getName(), (Object)s.getName());
                }
                this.cloudManager.submit(() -> {
                    this.simRunLeaderElection(dc.getName(), s.getName(), saveClusterState);
                    return true;
                });
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void simRunLeaderElection(String collection, String slice, boolean saveState) throws Exception {
        ArrayList active;
        ActionThrottle lt;
        Slice s;
        AtomicBoolean stateChanged;
        block39: {
            block38: {
                block37: {
                    block36: {
                        log.trace("Attempting leader election ({} / {})", (Object)collection, (Object)slice);
                        stateChanged = new AtomicBoolean(Boolean.FALSE);
                        this.lock.lockInterruptibly();
                        ClusterState state = this.getClusterState();
                        DocCollection col = state.getCollectionOrNull(collection);
                        if (null == col) {
                            log.trace("-- collection does not exist (anymore), skipping leader election ({} / {})", (Object)collection, (Object)slice);
                            if (stateChanged.get() || saveState) {
                                this.collectionsStatesRef.set(null);
                            }
                            this.lock.unlock();
                            return;
                        }
                        s = col.getSlice(slice);
                        if (null == s) {
                            log.trace("-- slice does not exist, skipping leader election ({} / {})", (Object)collection, (Object)slice);
                            if (stateChanged.get() || saveState) {
                                this.collectionsStatesRef.set(null);
                            }
                            this.lock.unlock();
                            return;
                        }
                        if (s.getState() != Slice.State.INACTIVE) break block36;
                        if (log.isTraceEnabled()) {
                            log.trace("-- slice state is {}, skipping leader election ({} / {})", new Object[]{s.getState(), collection, slice});
                        }
                        if (stateChanged.get() || saveState) {
                            this.collectionsStatesRef.set(null);
                        }
                        this.lock.unlock();
                        return;
                    }
                    if (!s.getReplicas().isEmpty()) break block37;
                    log.trace("-- no replicas, skipping leader election ({} / {})", (Object)collection, (Object)slice);
                    if (stateChanged.get() || saveState) {
                        this.collectionsStatesRef.set(null);
                    }
                    this.lock.unlock();
                    return;
                }
                Replica leader = s.getLeader();
                if (null == leader || !this.liveNodes.contains(leader.getNodeName())) break block38;
                log.trace("-- already has livenode leader, skipping leader election {} / {}", (Object)collection, (Object)slice);
                if (stateChanged.get() || saveState) {
                    this.collectionsStatesRef.set(null);
                }
                this.lock.unlock();
                return;
            }
            if (s.getState() != Slice.State.ACTIVE && log.isTraceEnabled()) {
                log.trace("-- slice state is {}, but I will run leader election anyway ({} / {})", new Object[]{s.getState(), collection, slice});
            }
            log.debug("Running leader election ({} / {})", (Object)collection, (Object)slice);
            ActionThrottle actionThrottle = lt = this.getThrottle(collection, s.getName());
            // MONITORENTER : actionThrottle
            active = new ArrayList();
            AtomicBoolean alreadyHasLeader = new AtomicBoolean(false);
            s.getReplicas().forEach(r -> {
                ReplicaInfo ri = this.getReplicaInfo((Replica)r);
                if (ri == null) {
                    throw new IllegalStateException("-- could not find ReplicaInfo for replica " + r);
                }
                ReplicaInfo replicaInfo = ri;
                synchronized (replicaInfo) {
                    if (r.isActive(this.liveNodes.get())) {
                        if (ri.getVariables().get("leader") != null) {
                            if (log.isTraceEnabled()) {
                                log.trace("-- found existing leader {} / {}: {}, {}", new Object[]{collection, s.getName(), ri, r});
                            }
                            alreadyHasLeader.set(true);
                            return;
                        }
                        active.add(ri);
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("-- replica not active on live nodes: {}, {}", this.liveNodes.get(), r);
                        }
                        if (!this.liveNodes.contains(r.getNodeName())) {
                            ri.getVariables().put("state", Replica.State.DOWN.toString());
                            ri.getVariables().remove("leader");
                            stateChanged.set(true);
                        }
                    }
                }
            });
            if (alreadyHasLeader.get()) {
                if (log.isTraceEnabled()) {
                    log.trace("-- already has leader {} / {}: {}", new Object[]{collection, s.getName(), s});
                }
                // MONITOREXIT : actionThrottle
                if (stateChanged.get() || saveState) {
                    this.collectionsStatesRef.set(null);
                }
                this.lock.unlock();
                return;
            }
            if (!active.isEmpty()) break block39;
            if (log.isWarnEnabled()) {
                log.warn("Can't find any active replicas for {} / {}: {}", new Object[]{collection, s.getName(), s});
            }
            if (log.isDebugEnabled()) {
                log.debug("-- liveNodes: {}", this.liveNodes.get());
            }
            // MONITOREXIT : actionThrottle
            if (stateChanged.get() || saveState) {
                this.collectionsStatesRef.set(null);
            }
            this.lock.unlock();
            return;
        }
        ReplicaInfo ri = null;
        for (ReplicaInfo a : active) {
            if (a.getType().equals((Object)Replica.Type.PULL)) continue;
            ri = a;
            break;
        }
        if (ri == null) {
            log.warn("-- can't find any suitable replica type for {} / {}: {}", new Object[]{collection, s.getName(), s});
            // MONITOREXIT : actionThrottle
            if (stateChanged.get() || saveState) {
                this.collectionsStatesRef.set(null);
            }
            this.lock.unlock();
            return;
        }
        try {
            lt.minimumWaitBetweenActions();
            lt.markAttemptingAction();
            Iterator iterator = ri;
            // MONITORENTER : iterator
            ri.getVariables().put("leader", "true");
            // MONITOREXIT : iterator
            if (log.isDebugEnabled()) {
                log.debug("-- elected new leader for {} / {} (currentVersion={}): {}", new Object[]{collection, s.getName(), this.clusterStateVersion, ri});
            }
            stateChanged.set(true);
            // MONITOREXIT : actionThrottle
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (stateChanged.get() || saveState) {
                this.collectionsStatesRef.set(null);
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simCreateCollection(ZkNodeProps props, NamedList results) throws Exception {
        boolean finished;
        int numTlogReplicas;
        this.ensureNotClosed();
        if (props.getStr("async") != null) {
            results.add("requestid", (Object)props.getStr("async"));
        }
        boolean waitForFinalState = props.getBool("waitForFinalState", false);
        String collectionName = props.getStr("name");
        log.debug("-- simCreateCollection {}, currentVersion={}", (Object)collectionName, (Object)this.clusterStateVersion);
        String router = props.getStr("router.name", "compositeId");
        List<String> shardNames = CreateCollectionCmd.populateShardNames(props, router);
        int maxShardsPerNode = props.getInt("maxShardsPerNode", Integer.valueOf(1));
        if (maxShardsPerNode == -1) {
            maxShardsPerNode = Integer.MAX_VALUE;
        }
        CreateCollectionCmd.checkReplicaTypes(props);
        this.lock.lockInterruptibly();
        try {
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
        ClusterState clusterState = this.getClusterState();
        String withCollection = props.getStr("withCollection");
        String wcShard = null;
        if (withCollection != null) {
            if (!clusterState.hasCollection(withCollection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'withCollection' does not exist: " + withCollection);
            }
            DocCollection collection = clusterState.getCollection(withCollection);
            if (collection.getActiveSlices().size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The `withCollection` must have only one shard, found: " + collection.getActiveSlices().size());
            }
            wcShard = ((Slice)collection.getActiveSlices().iterator().next()).getName();
        }
        String withCollectionShard = wcShard;
        ZkWriteCommand cmd = ZkWriteCommand.noop();
        this.lock.lockInterruptibly();
        try {
            cmd = new ClusterStateMutator(this.cloudManager).createCollection(clusterState, props);
            if (cmd.noop) {
                log.warn("Collection {} already exists. exit", (Object)collectionName);
                log.debug("-- collection: {}, clusterState: {}", (Object)collectionName, (Object)clusterState);
                results.add("success", (Object)"no-op");
                return;
            }
            DocCollection coll = cmd.collection;
            this.collProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).putAll(coll.getProperties());
            this.colShardReplicaMap.computeIfAbsent(collectionName, c -> new ConcurrentHashMap());
            coll.getSlices().forEach(s -> {
                Map sliceProps = this.sliceProperties.computeIfAbsent(coll.getName(), c -> new ConcurrentHashMap()).computeIfAbsent(s.getName(), slice -> new ConcurrentHashMap());
                s.getProperties().forEach((k, v) -> {
                    if (k != null && v != null) {
                        sliceProps.put(k, v);
                    }
                });
                this.colShardReplicaMap.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).computeIfAbsent(s.getName(), sh -> new ArrayList());
            });
            if (withCollection != null) {
                ZkNodeProps message = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.MODIFYCOLLECTION.toString(), "collection", withCollection, "COLOCATED_WITH", collectionName});
                cmd = new CollectionMutator(this.cloudManager).modifyCollection(clusterState, message);
            }
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
        this.opDelays.computeIfAbsent(collectionName, c -> new HashMap()).putAll(this.defaultOpDelays);
        this.opDelay(collectionName, CollectionParams.CollectionAction.CREATE.name());
        AtomicReference<PolicyHelper.SessionWrapper> sessionWrapper = new AtomicReference<PolicyHelper.SessionWrapper>();
        List<ReplicaPosition> replicaPositions = CreateCollectionCmd.buildReplicaPositions(this.cloudManager, this.getClusterState(), cmd.collection, props, shardNames, sessionWrapper);
        if (sessionWrapper.get() != null) {
            sessionWrapper.get().release();
        }
        int numNrtReplicas = props.getInt("nrtReplicas", props.getInt("replicationFactor", Integer.valueOf((numTlogReplicas = props.getInt("tlogReplicas", Integer.valueOf(0)).intValue()) > 0 ? 0 : 1)));
        int numPullReplicas = props.getInt("pullReplicas", Integer.valueOf(0));
        int totalReplicas = shardNames.size() * (numNrtReplicas + numPullReplicas + numTlogReplicas);
        if (totalReplicas != replicaPositions.size()) {
            throw new RuntimeException("unexpected number of replica positions: expected " + totalReplicas + " but got " + replicaPositions.size());
        }
        CountDownLatch finalStateLatch = new CountDownLatch(replicaPositions.size());
        AtomicInteger replicaNum = new AtomicInteger(1);
        replicaPositions.forEach(pos -> {
            DocCollection collection;
            List replicas;
            if (withCollection != null && ((replicas = (collection = clusterState.getCollection(withCollection)).getReplicas(pos.node)) == null || replicas.isEmpty())) {
                HashMap<String, Object> replicaProps = new HashMap<String, Object>();
                replicaProps.put("node_name", pos.node);
                replicaProps.put("type", pos.type.toString());
                String coreName = String.format(Locale.ROOT, "%s_%s_replica_%s%s", withCollection, withCollectionShard, pos.type.name().substring(0, 1).toLowerCase(Locale.ROOT), collection.getReplicas().size() + 1);
                try {
                    replicaProps.put("core", coreName);
                    replicaProps.put("SEARCHER.searcher.deletedDocs", new AtomicLong(0L));
                    replicaProps.put("SEARCHER.searcher.numDocs", new AtomicLong(0L));
                    replicaProps.put("SEARCHER.searcher.maxDoc", new AtomicLong(0L));
                    ReplicaInfo ri = new ReplicaInfo("core_node" + Assign.incAndGetId(this.stateManager, withCollection, 0), coreName, withCollection, withCollectionShard, pos.type, pos.node, replicaProps);
                    this.cloudManager.submit(() -> {
                        this.simAddReplica(pos.node, ri, false);
                        return true;
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            HashMap<String, Object> replicaProps = new HashMap<String, Object>();
            replicaProps.put("node_name", pos.node);
            replicaProps.put("type", pos.type.toString());
            String coreName = String.format(Locale.ROOT, "%s_%s_replica_%s%s", collectionName, pos.shard, pos.type.name().substring(0, 1).toLowerCase(Locale.ROOT), replicaNum.getAndIncrement());
            try {
                replicaProps.put("core", coreName);
                replicaProps.put("SEARCHER.searcher.deletedDocs", new AtomicLong(0L));
                replicaProps.put("SEARCHER.searcher.numDocs", new AtomicLong(0L));
                replicaProps.put("SEARCHER.searcher.maxDoc", new AtomicLong(0L));
                ReplicaInfo ri = new ReplicaInfo("core_node" + Assign.incAndGetId(this.stateManager, collectionName, 0), coreName, collectionName, pos.shard, pos.type, pos.node, replicaProps);
                this.cloudManager.submit(() -> {
                    this.simAddReplica(pos.node, ri, true);
                    finalStateLatch.countDown();
                    return true;
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.lock.lockInterruptibly();
        try {
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
        if (waitForFinalState && !(finished = finalStateLatch.await(this.cloudManager.getTimeSource().convertDelay(TimeUnit.SECONDS, 60L, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS))) {
            results.add("failure", (Object)"Timeout waiting for all replicas to become active.");
            return;
        }
        results.add("success", (Object)"");
        log.debug("-- finished createCollection {}, currentVersion={}", (Object)collectionName, (Object)this.clusterStateVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simDeleteCollection(String collection, String async, NamedList results) throws Exception {
        this.ensureNotClosed();
        if (async != null) {
            results.add("requestid", (Object)async);
        }
        this.lock.lockInterruptibly();
        try {
            this.collProperties.remove(collection);
            this.sliceProperties.remove(collection);
            this.leaderThrottles.remove(collection);
            this.colShardReplicaMap.remove(collection);
            SplitShardCmd.unlockForSplit(this.cloudManager, collection, null);
            this.opDelay(collection, CollectionParams.CollectionAction.DELETE.name());
            this.opDelays.remove(collection);
            this.nodeReplicaMap.forEach((n, replicas) -> {
                List list = replicas;
                synchronized (list) {
                    Iterator it = replicas.iterator();
                    while (it.hasNext()) {
                        ReplicaInfo ri = (ReplicaInfo)it.next();
                        if (!ri.getCollection().equals(collection)) continue;
                        it.remove();
                        Number cores = (Number)this.cloudManager.getSimNodeStateProvider().simGetNodeValue((String)n, "cores");
                        if (cores == null) continue;
                        if (cores.intValue() == 0) {
                            throw new RuntimeException("Unexpected value of 'cores' (" + cores + ") on node: " + n);
                        }
                        try {
                            this.cloudManager.getSimNodeStateProvider().simSetNodeValue((String)n, "cores", cores.intValue() - 1);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException("interrupted");
                        }
                    }
                }
            });
            this.collectionsStatesRef.set(null);
            results.add("success", (Object)"");
        }
        catch (Exception e) {
            log.warn("Exception", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simDeleteAllCollections() throws Exception {
        this.lock.lockInterruptibly();
        try {
            this.collectionsStatesRef.set(null);
            this.collProperties.clear();
            this.sliceProperties.clear();
            this.leaderThrottles.clear();
            this.nodeReplicaMap.clear();
            this.colShardReplicaMap.clear();
            this.cloudManager.getSimNodeStateProvider().simGetAllNodeValues().forEach((n, values) -> {
                values.put("cores", 0);
                values.put("freedisk", SimCloudManager.DEFAULT_FREE_DISK);
                values.put(Variable.Type.TOTALDISK.tagName, SimCloudManager.DEFAULT_TOTAL_DISK);
                values.put("sysLoadAvg", 1.0);
                values.put("heapUsage", 123450000);
            });
            this.cloudManager.getDistribStateManager().removeRecursively("/collections", true, false);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simMoveReplica(ZkNodeProps message, NamedList results) throws Exception {
        this.ensureNotClosed();
        if (message.getStr("async") != null) {
            results.add("requestid", (Object)message.getStr("async"));
        }
        String collection = message.getStr("collection");
        String targetNode = message.getStr("targetNode");
        ClusterState clusterState = this.getClusterState();
        DocCollection coll = clusterState.getCollection(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " does not exist");
        }
        String replicaName = message.getStr("replica");
        Replica replica = coll.getReplica(replicaName);
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " replica: " + replicaName + " does not exist");
        }
        Slice slice = null;
        for (Slice s : coll.getSlices()) {
            if (!s.getReplicas().contains(replica)) continue;
            slice = s;
        }
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Replica has no 'slice' property! : " + replica);
        }
        this.opDelay(collection, CollectionParams.CollectionAction.MOVEREPLICA.name());
        ReplicaInfo ri = this.getReplicaInfo(replica);
        if (ri != null && ri.getVariable(Variable.Type.CORE_IDX.tagName) != null) {
            long sizeInGB = ((Number)ri.getVariable(Variable.Type.CORE_IDX.tagName)).longValue();
            long opDelay = this.opDelays.getOrDefault(ri.getCollection(), Collections.emptyMap()).getOrDefault(CollectionParams.CollectionAction.MOVEREPLICA.name(), this.defaultOpDelays.get(CollectionParams.CollectionAction.MOVEREPLICA.name()));
            if (sizeInGB > (opDelay = TimeUnit.MILLISECONDS.toSeconds(opDelay))) {
                this.cloudManager.getTimeSource().sleep(TimeUnit.SECONDS.toMillis(sizeInGB - opDelay) * 5L);
            }
        }
        String newSolrCoreName = Assign.buildSolrCoreName(this.stateManager, coll, slice.getName(), replica.getType());
        String coreNodeName = Assign.assignCoreNodeName(this.stateManager, coll);
        Map<String, Object> props = replica.getProperties().entrySet().stream().filter(e -> !NO_COPY_PROPS.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
        ReplicaInfo newReplica = new ReplicaInfo(coreNodeName, newSolrCoreName, collection, slice.getName(), replica.getType(), targetNode, props);
        log.debug("-- new replica: {}", (Object)newReplica);
        this.simAddReplica(targetNode, newReplica, false);
        this.simRemoveReplica(replica.getNodeName(), collection, replica.getName());
        results.add("success", (Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simCreateShard(ZkNodeProps message, NamedList results) throws Exception {
        this.ensureNotClosed();
        if (message.getStr("async") != null) {
            results.add("requestid", (Object)message.getStr("async"));
        }
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        ClusterState clusterState = this.getClusterState();
        this.lock.lockInterruptibly();
        try {
            ZkWriteCommand cmd = new CollectionMutator(this.cloudManager).createShard(clusterState, message);
            if (cmd.noop) {
                results.add("success", (Object)"no-op");
                return;
            }
            this.opDelay(collectionName, CollectionParams.CollectionAction.CREATESHARD.name());
            DocCollection collection = cmd.collection;
            Slice slice = collection.getSlice(sliceName);
            Map props = this.sliceProperties.computeIfAbsent(collection.getName(), c -> new ConcurrentHashMap()).computeIfAbsent(sliceName, s -> new ConcurrentHashMap());
            props.clear();
            slice.getProperties().entrySet().stream().filter(e -> !((String)e.getKey()).equals("range")).filter(e -> !((String)e.getKey()).equals("replicas")).forEach(e -> props.put(e.getKey(), e.getValue()));
            EnumMap<Replica.Type, Integer> replicaTypesVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
            int numNrtReplicas = message.getInt("nrtReplicas", message.getInt("replicationFactor", collection.getInt("nrtReplicas", collection.getInt("replicationFactor", Integer.valueOf(1)))));
            int numTlogReplicas = message.getInt("tlogReplicas", message.getInt("tlogReplicas", collection.getInt("tlogReplicas", Integer.valueOf(0))));
            int numPullReplicas = message.getInt("pullReplicas", message.getInt("pullReplicas", collection.getInt("pullReplicas", Integer.valueOf(0))));
            replicaTypesVsCount.put(Replica.Type.NRT, numNrtReplicas);
            replicaTypesVsCount.put(Replica.Type.TLOG, numTlogReplicas);
            replicaTypesVsCount.put(Replica.Type.PULL, numPullReplicas);
            ZkNodeProps addReplicasProps = new ZkNodeProps(new String[]{"collection", collectionName, "shard", sliceName, "nrtReplicas", String.valueOf(replicaTypesVsCount.get(Replica.Type.NRT)), "tlogReplicas", String.valueOf(replicaTypesVsCount.get(Replica.Type.TLOG)), "pullReplicas", String.valueOf(replicaTypesVsCount.get(Replica.Type.PULL)), "createNodeSet", message.getStr("createNodeSet")});
            try {
                this.simAddReplica(addReplicasProps, results);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            this.collProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap());
            results.add("success", (Object)"");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSplitShard(ZkNodeProps message, NamedList results) throws Exception {
        Map sProps;
        this.ensureNotClosed();
        if (message.getStr("async") != null) {
            results.add("requestid", (Object)message.getStr("async"));
        }
        String collectionName = message.getStr("collection");
        AtomicReference<String> sliceName = new AtomicReference<String>();
        sliceName.set(message.getStr("shard"));
        String splitKey = message.getStr("split.key");
        String methodStr = message.getStr("splitMethod", SolrIndexSplitter.SplitMethod.REWRITE.toLower());
        SolrIndexSplitter.SplitMethod splitMethod = SolrIndexSplitter.SplitMethod.get(methodStr);
        if (splitMethod == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown value 'splitMethod: " + methodStr);
        }
        ClusterState clusterState = this.getClusterState();
        DocCollection collection = clusterState.getCollection(collectionName);
        Slice parentSlice = SplitShardCmd.getParentSlice(clusterState, collectionName, sliceName, splitKey);
        Replica leader = parentSlice.getLeader();
        if (leader == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Shard " + collectionName + " /  " + sliceName.get() + " has no leader and can't be split");
        }
        SplitShardCmd.checkDiskSpace(collectionName, sliceName.get(), leader, splitMethod, this.cloudManager);
        SplitShardCmd.lockForSplit(this.cloudManager, collectionName, sliceName.get());
        Map props = this.sliceProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).computeIfAbsent(sliceName.get(), ss -> new ConcurrentHashMap());
        if (props.containsKey(BUFFERED_UPDATES)) {
            SplitShardCmd.unlockForSplit(this.cloudManager, collectionName, sliceName.get());
            throw new Exception("--- SOLR-12729: Overlapping splitShard commands for " + collectionName + "/" + sliceName.get());
        }
        props.put(BUFFERED_UPDATES, new AtomicLong());
        ArrayList<DocRouter.Range> subRanges = new ArrayList<DocRouter.Range>();
        ArrayList<String> subSlices = new ArrayList<String>();
        ArrayList<String> subShardNames = new ArrayList<String>();
        this.opDelay(collectionName, CollectionParams.CollectionAction.SPLITSHARD.name());
        SplitShardCmd.fillRanges(this.cloudManager, message, collection, parentSlice, subRanges, subSlices, subShardNames, true);
        int repFactor = parentSlice.getReplicas().size();
        Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(collectionName).forShard(subSlices).assignNrtReplicas(repFactor).assignTlogReplicas(0).assignPullReplicas(0).onNodes(new ArrayList<String>(clusterState.getLiveNodes())).build();
        Assign.AssignStrategyFactory assignStrategyFactory = new Assign.AssignStrategyFactory(this.cloudManager);
        Assign.AssignStrategy assignStrategy = assignStrategyFactory.create(clusterState, collection);
        List<ReplicaPosition> replicaPositions = assignStrategy.assign(this.cloudManager, assignRequest);
        PolicyHelper.SessionWrapper sessionWrapper = PolicyHelper.getLastSessionWrapper((boolean)true);
        if (sessionWrapper != null) {
            sessionWrapper.release();
        }
        String numDocsStr = String.valueOf(this.getReplicaInfo(leader).getVariable("SEARCHER.searcher.numDocs", (Object)"0"));
        long numDocs = Long.parseLong(numDocsStr);
        long newNumDocs = numDocs / (long)subSlices.size();
        long remainderDocs = numDocs % (long)subSlices.size();
        long newIndexSize = SimCloudManager.DEFAULT_IDX_SIZE_BYTES + newNumDocs * 2048L;
        long remainderIndexSize = SimCloudManager.DEFAULT_IDX_SIZE_BYTES + remainderDocs * 2048L;
        String remainderSlice = null;
        for (int i = 0; i < subRanges.size(); ++i) {
            String subSlice = (String)subSlices.get(i);
            DocRouter.Range range = (DocRouter.Range)subRanges.get(i);
            Map sliceProps = this.sliceProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).computeIfAbsent(subSlice, ss -> new ConcurrentHashMap());
            sliceProps.put("range", range);
            sliceProps.put("parent", sliceName.get());
            sliceProps.put("state", Slice.State.CONSTRUCTION.toString());
            sliceProps.put("stateTimestamp", String.valueOf(this.cloudManager.getTimeSource().getEpochTimeNs()));
        }
        for (ReplicaPosition replicaPosition : replicaPositions) {
            String subSliceName = replicaPosition.shard;
            String subShardNodeName = replicaPosition.node;
            String solrCoreName = Assign.buildSolrCoreName(collectionName, subSliceName, replicaPosition.type, Assign.incAndGetId(this.stateManager, collectionName, 0));
            HashMap<String, Object> replicaProps = new HashMap<String, Object>();
            replicaProps.put("shard", replicaPosition.shard);
            replicaProps.put("node_name", replicaPosition.node);
            replicaProps.put("type", replicaPosition.type.toString());
            replicaProps.put("base_url", Utils.getBaseUrlForNodeName((String)subShardNodeName, (String)"http"));
            long replicasNumDocs = newNumDocs;
            long replicasIndexSize = newIndexSize;
            if (remainderSlice == null) {
                remainderSlice = subSliceName;
            }
            if (remainderSlice.equals(subSliceName)) {
                replicasNumDocs += remainderDocs;
                replicasIndexSize += remainderIndexSize;
            }
            replicaProps.put("SEARCHER.searcher.numDocs", new AtomicLong(replicasNumDocs));
            replicaProps.put("SEARCHER.searcher.maxDoc", new AtomicLong(replicasNumDocs));
            replicaProps.put("SEARCHER.searcher.deletedDocs", new AtomicLong(0L));
            replicaProps.put(Variable.Type.CORE_IDX.metricsAttribute, new AtomicLong(replicasIndexSize));
            replicaProps.put("INDEX.sizeInGB", new AtomicDouble(((Double)Variable.Type.CORE_IDX.convertVal((Object)replicasIndexSize)).doubleValue()));
            ReplicaInfo ri = new ReplicaInfo("core_node" + Assign.incAndGetId(this.stateManager, collectionName, 0), solrCoreName, collectionName, replicaPosition.shard, replicaPosition.type, subShardNodeName, replicaProps);
            this.simAddReplica(replicaPosition.node, ri, false);
        }
        this.simRunLeaderElection(Collections.singleton(collectionName), true);
        boolean success = false;
        try {
            CloudUtil.waitForState(this.cloudManager, collectionName, 30L, TimeUnit.SECONDS, (liveNodes, state) -> {
                for (String subSlice : subSlices) {
                    Slice s = state.getSlice(subSlice);
                    if (s.getLeader() == null) {
                        log.debug("** no leader in {} / {}", (Object)collectionName, (Object)s);
                        return false;
                    }
                    if (s.getReplicas().size() >= repFactor) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("** expected {} repFactor but there are {} replicas", (Object)repFactor, (Object)s.getReplicas().size());
                    }
                    return false;
                }
                return true;
            });
            success = true;
        }
        finally {
            if (!success) {
                sProps = this.sliceProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).computeIfAbsent(sliceName.get(), s -> new ConcurrentHashMap());
                sProps.remove(BUFFERED_UPDATES);
                SplitShardCmd.unlockForSplit(this.cloudManager, collectionName, sliceName.get());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("-- switching slice states after split shard: collection={}, parent={}, subSlices={}", new Object[]{collectionName, sliceName.get(), subSlices});
        }
        this.lock.lockInterruptibly();
        try {
            sProps = this.sliceProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).computeIfAbsent(sliceName.get(), s -> new ConcurrentHashMap());
            sProps.put("state", Slice.State.INACTIVE.toString());
            sProps.put("stateTimestamp", String.valueOf(this.cloudManager.getTimeSource().getEpochTimeNs()));
            AtomicLong bufferedUpdates = (AtomicLong)sProps.remove(BUFFERED_UPDATES);
            if (bufferedUpdates.get() > 0L) {
                long perShard = bufferedUpdates.get() / (long)subSlices.size();
                long remainder = bufferedUpdates.get() % (long)subSlices.size();
                if (log.isDebugEnabled()) {
                    log.debug("-- applying {} buffered docs from {} / {}, perShard={}, remainder={}", new Object[]{bufferedUpdates.get(), collectionName, parentSlice.getName(), perShard, remainder});
                }
                for (int i = 0; i < subSlices.size(); ++i) {
                    String sub = (String)subSlices.get(i);
                    long numUpdates = perShard;
                    if (i == 0) {
                        numUpdates += remainder;
                    }
                    this.simSetShardValue(collectionName, sub, "SEARCHER.searcher.numDocs", numUpdates, true, false);
                    this.simSetShardValue(collectionName, sub, "SEARCHER.searcher.maxDoc", numUpdates, true, false);
                }
            }
            for (String s2 : subSlices) {
                Map sliceProps = this.sliceProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).computeIfAbsent(s2, ss -> new ConcurrentHashMap());
                sliceProps.put("state", Slice.State.ACTIVE.toString());
                sliceProps.put("stateTimestamp", String.valueOf(this.cloudManager.getTimeSource().getEpochTimeNs()));
            }
            this.collectionsStatesRef.set(null);
        }
        finally {
            SplitShardCmd.unlockForSplit(this.cloudManager, collectionName, sliceName.get());
            this.lock.unlock();
        }
        results.add("success", (Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simDeleteShard(ZkNodeProps message, NamedList results) throws Exception {
        this.ensureNotClosed();
        if (message.getStr("async") != null) {
            results.add("requestid", (Object)message.getStr("async"));
        }
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        ClusterState clusterState = this.getClusterState();
        DocCollection collection = clusterState.getCollection(collectionName);
        if (collection == null) {
            throw new Exception("Collection " + collectionName + " doesn't exist");
        }
        Slice slice = collection.getSlice(sliceName);
        if (slice == null) {
            throw new Exception(" Collection " + collectionName + " slice " + sliceName + " doesn't exist.");
        }
        this.opDelay(collectionName, CollectionParams.CollectionAction.DELETESHARD.name());
        this.lock.lockInterruptibly();
        try {
            this.sliceProperties.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).remove(sliceName);
            this.colShardReplicaMap.computeIfAbsent(collectionName, c -> new ConcurrentHashMap()).remove(sliceName);
            this.nodeReplicaMap.forEach((n, replicas) -> {
                List list = replicas;
                synchronized (list) {
                    Iterator it = replicas.iterator();
                    while (it.hasNext()) {
                        ReplicaInfo ri = (ReplicaInfo)it.next();
                        if (!ri.getCollection().equals(collectionName) || !ri.getShard().equals(sliceName)) continue;
                        it.remove();
                    }
                }
            });
            this.collectionsStatesRef.set(null);
            results.add("success", (Object)"");
        }
        catch (Exception e) {
            results.add("failure", (Object)e.toString());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSystemCollection() throws IOException {
        try {
            SimClusterStateProvider simClusterStateProvider = this;
            synchronized (simClusterStateProvider) {
                if (this.colShardReplicaMap.containsKey(".system")) {
                    return;
                }
            }
            String repFactor = String.valueOf(Math.min(3, this.liveNodes.size()));
            ZkNodeProps props = new ZkNodeProps(new String[]{"name", ".system", "replicationFactor", repFactor, "numShards", "1", "waitForFinalState", "true"});
            this.simCreateCollection(props, new NamedList());
            CloudUtil.waitForState(this.cloudManager, ".system", 120L, TimeUnit.SECONDS, CloudUtil.clusterShape(1, Integer.parseInt(repFactor), false, true));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResponse simUpdate(UpdateRequest req) throws SolrException, InterruptedException, IOException {
        ModifiableSolrParams modifiableSolrParams;
        this.ensureNotClosed();
        String collection = req.getCollection();
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not set");
        }
        this.ensureSystemCollection(collection);
        DocCollection coll = this.getClusterState().getCollection(collection);
        DocRouter router = coll.getRouter();
        List deletes = req.getDeleteById();
        HashMap<String, AtomicLong> freediskDeltaPerNode = new HashMap<String, AtomicLong>();
        if (deletes != null && !deletes.isEmpty()) {
            HashMap deletesPerShard = new HashMap();
            HashMap<String, Number> indexSizePerShard = new HashMap<String, Number>();
            for (String string : deletes) {
                Slice s2 = router.getTargetSlice(string, null, null, (SolrParams)req.getParams(), coll);
                Replica leader = s2.getLeader();
                if (leader == null) {
                    throw new IOException("-- no leader in " + s2);
                }
                this.cloudManager.getMetricManager().registry(SimClusterStateProvider.createRegistryName(collection, s2.getName(), leader)).counter("UPDATE./update.requests").inc();
                ReplicaInfo ri = this.getReplicaInfo(leader);
                Number numDocs = (Number)ri.getVariable("SEARCHER.searcher.numDocs");
                if (numDocs == null || numDocs.intValue() <= 0) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("-- attempting to delete nonexistent doc {} from {}", (Object)string, (Object)s2.getLeader());
                    continue;
                }
                s2.getReplicas().forEach(r -> freediskDeltaPerNode.computeIfAbsent(r.getNodeName(), node -> new AtomicLong(0L)).addAndGet(2048L));
                AtomicLong bufferedUpdates = (AtomicLong)this.sliceProperties.get(collection).get(s2.getName()).get(BUFFERED_UPDATES);
                if (bufferedUpdates != null) {
                    if (bufferedUpdates.get() > 0L) {
                        bufferedUpdates.decrementAndGet();
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("-- attempting to delete nonexistent buffered doc {} from {}", (Object)string, (Object)s2.getLeader());
                    continue;
                }
                deletesPerShard.computeIfAbsent(s2.getName(), slice -> new AtomicLong(0L)).incrementAndGet();
                Number indexSize = (Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
                if (indexSize == null) continue;
                indexSizePerShard.put(s2.getName(), indexSize);
            }
            if (!deletesPerShard.isEmpty()) {
                this.lock.lockInterruptibly();
                try {
                    for (Map.Entry entry : deletesPerShard.entrySet()) {
                        String shard = (String)entry.getKey();
                        this.simSetShardValue(collection, shard, "SEARCHER.searcher.deletedDocs", ((AtomicLong)entry.getValue()).get(), true, false);
                        this.simSetShardValue(collection, shard, "SEARCHER.searcher.numDocs", -((AtomicLong)entry.getValue()).get(), true, false);
                        Number indexSize = (Number)indexSizePerShard.get(shard);
                        long delSize = 2048L * ((AtomicLong)entry.getValue()).get();
                        if (indexSize != null) {
                            if ((indexSize = Long.valueOf(indexSize.longValue() - delSize)).longValue() < SimCloudManager.DEFAULT_IDX_SIZE_BYTES) {
                                indexSize = SimCloudManager.DEFAULT_IDX_SIZE_BYTES;
                            }
                            this.simSetShardValue(collection, shard, Variable.Type.CORE_IDX.metricsAttribute, new AtomicLong(indexSize.longValue()), false, false);
                            this.simSetShardValue(collection, shard, "INDEX.sizeInGB", new AtomicDouble(((Double)Variable.Type.CORE_IDX.convertVal((Object)indexSize)).doubleValue()), false, false);
                            continue;
                        }
                        throw new Exception("unexpected indexSize for collection=" + collection + ", shard=" + shard + ": " + indexSize);
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        if ((deletes = req.getDeleteQuery()) != null && !deletes.isEmpty()) {
            for (String q : deletes) {
                if (!"*:*".equals(q)) {
                    throw new UnsupportedOperationException("Only '*:*' query is supported in deleteByQuery");
                }
                for (Slice slice2 : coll.getSlices()) {
                    Replica leader = slice2.getLeader();
                    if (leader == null) {
                        throw new IOException("-- no leader in " + slice2);
                    }
                    this.cloudManager.getMetricManager().registry(SimClusterStateProvider.createRegistryName(collection, slice2.getName(), leader)).counter("UPDATE./update.requests").inc();
                    ReplicaInfo ri = this.getReplicaInfo(leader);
                    Number numDocs = (Number)ri.getVariable("SEARCHER.searcher.numDocs");
                    if (numDocs == null || numDocs.intValue() == 0) continue;
                    this.lock.lockInterruptibly();
                    try {
                        Number indexSize = (Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
                        if (indexSize == null) {
                            throw new RuntimeException("Missing index size in " + ri);
                        }
                        long delta2 = indexSize.longValue() < SimCloudManager.DEFAULT_IDX_SIZE_BYTES ? 0L : indexSize.longValue() - SimCloudManager.DEFAULT_IDX_SIZE_BYTES;
                        slice2.getReplicas().forEach(r -> freediskDeltaPerNode.computeIfAbsent(r.getNodeName(), node -> new AtomicLong(0L)).addAndGet(delta2));
                        this.simSetShardValue(collection, slice2.getName(), "SEARCHER.searcher.deletedDocs", new AtomicLong(numDocs.longValue()), false, false);
                        this.simSetShardValue(collection, slice2.getName(), "SEARCHER.searcher.numDocs", new AtomicLong(0L), false, false);
                        this.simSetShardValue(collection, slice2.getName(), Variable.Type.CORE_IDX.metricsAttribute, new AtomicLong(SimCloudManager.DEFAULT_IDX_SIZE_BYTES), false, false);
                        this.simSetShardValue(collection, slice2.getName(), "INDEX.sizeInGB", new AtomicDouble(((Double)Variable.Type.CORE_IDX.convertVal((Object)SimCloudManager.DEFAULT_IDX_SIZE_BYTES)).doubleValue()), false, false);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
        }
        List docs = req.getDocuments();
        int docCount = 0;
        Iterator it = null;
        if (docs != null) {
            docCount = docs.size();
        } else {
            it = req.getDocIterator();
            if (it != null) {
                while (it.hasNext()) {
                    it.next();
                    ++docCount;
                }
            }
        }
        if (docCount > 0) {
            HashMap<String, AtomicLong> hashMap = new HashMap<String, AtomicLong>();
            HashMap<String, Map> metricUpdates = new HashMap<String, Map>();
            boolean modified = false;
            this.lock.lockInterruptibly();
            try {
                coll = this.getClusterState().getCollection(collection);
                Slice[] slices = coll.getActiveSlicesArr();
                if (slices.length == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection without slices");
                }
                int[] perSlice = new int[slices.length];
                if (it != null) {
                    int totalAdded = 0;
                    for (int i = 0; i < slices.length; ++i) {
                        Slice s4 = slices[i];
                        long count2 = (long)docCount * ((long)s4.getRange().max - (long)s4.getRange().min) / 0x100000000L;
                        perSlice[i] = (int)count2;
                        totalAdded += perSlice[i];
                    }
                    int diff = docCount - totalAdded;
                    if (diff > 0) {
                        int perRemain = diff / slices.length;
                        int remainder = diff % slices.length;
                        int remainderSlice = slices.length > 1 ? this.bulkUpdateRandom.nextInt(slices.length) : 0;
                        for (int i = 0; i < slices.length; ++i) {
                            int n = i;
                            perSlice[n] = perSlice[n] + perRemain;
                            if (i != remainderSlice) continue;
                            int n2 = i;
                            perSlice[n2] = perSlice[n2] + remainder;
                        }
                    }
                    for (int i = 0; i < slices.length; ++i) {
                        Slice s5 = slices[i];
                        Replica leader = s5.getLeader();
                        if (leader == null) {
                            throw new IOException("-- no leader in " + s5);
                        }
                        metricUpdates.computeIfAbsent(s5.getName(), sh -> new HashMap()).computeIfAbsent(leader.getCoreName(), cn -> new AtomicLong()).addAndGet(perSlice[i]);
                        modified = true;
                        long perSliceCount = perSlice[i];
                        s5.getReplicas().forEach(r -> freediskDeltaPerNode.computeIfAbsent(r.getNodeName(), node -> new AtomicLong(0L)).addAndGet(-perSliceCount * 2048L));
                        AtomicLong bufferedUpdates = (AtomicLong)this.sliceProperties.get(collection).get(s5.getName()).get(BUFFERED_UPDATES);
                        if (bufferedUpdates != null) {
                            bufferedUpdates.addAndGet(perSlice[i]);
                            continue;
                        }
                        hashMap.computeIfAbsent(s5.getName(), sh -> new AtomicLong()).addAndGet(perSlice[i]);
                    }
                } else {
                    for (SolrInputDocument doc : docs) {
                        String id = (String)doc.getFieldValue("id");
                        if (id == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Document without id: " + doc);
                        }
                        Slice s6 = coll.getRouter().getTargetSlice(id, doc, null, null, coll);
                        Replica leader = s6.getLeader();
                        if (leader == null) {
                            throw new IOException("-- no leader in " + s6);
                        }
                        metricUpdates.computeIfAbsent(s6.getName(), sh -> new HashMap()).computeIfAbsent(leader.getCoreName(), cn -> new AtomicLong()).incrementAndGet();
                        modified = true;
                        s6.getReplicas().forEach(r -> freediskDeltaPerNode.computeIfAbsent(r.getNodeName(), node -> new AtomicLong()).addAndGet(-2048L));
                        AtomicLong bufferedUpdates = (AtomicLong)this.sliceProperties.get(collection).get(s6.getName()).get(BUFFERED_UPDATES);
                        if (bufferedUpdates != null) {
                            bufferedUpdates.incrementAndGet();
                            continue;
                        }
                        hashMap.computeIfAbsent(s6.getName(), sh -> new AtomicLong()).incrementAndGet();
                    }
                }
                if (modified) {
                    hashMap.forEach((sh, count) -> {
                        try {
                            this.simSetShardValue(collection, (String)sh, "SEARCHER.searcher.numDocs", count.get(), true, false);
                            this.simSetShardValue(collection, (String)sh, "SEARCHER.searcher.maxDoc", count.get(), true, false);
                            this.simSetShardValue(collection, (String)sh, "UPDATE./update.requests", count.get(), true, false);
                            this.simSetShardValue(collection, (String)sh, Variable.Type.CORE_IDX.metricsAttribute, 2048L * count.get(), true, false);
                            this.simSetShardValue(collection, (String)sh, "INDEX.sizeInGB", Variable.Type.CORE_IDX.convertVal((Object)(2048L * count.get())), true, false);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                    metricUpdates.forEach((sh, cores) -> cores.forEach((core, count) -> {
                        String registry = SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, collection, sh, Utils.parseMetricsReplicaName((String)collection, (String)core));
                        this.cloudManager.getMetricManager().registry(registry).counter("UPDATE./update.requests").inc(count.get());
                    }));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (!freediskDeltaPerNode.isEmpty()) {
            SimNodeStateProvider simNodeStateProvider = this.cloudManager.getSimNodeStateProvider();
            freediskDeltaPerNode.forEach((node, delta) -> {
                if (delta.get() == 0L) {
                    return;
                }
                try {
                    nodeStateProvider.simUpdateNodeValue((String)node, Variable.Type.FREEDISK.tagName, val -> {
                        if (val == null) {
                            throw new RuntimeException("no freedisk for node " + node);
                        }
                        double freedisk = ((Number)val).doubleValue();
                        double deltaGB = (Double)Variable.Type.FREEDISK.convertVal((Object)delta.get());
                        if ((freedisk += deltaGB) < 0.0) {
                            log.warn("-- freedisk={} - ran out of disk space on node {}", (Object)freedisk, node);
                            freedisk = 0.0;
                        }
                        return freedisk;
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        if ((modifiableSolrParams = req.getParams()) != null && (modifiableSolrParams.getBool("optimize", false) || modifiableSolrParams.getBool("expungeDeletes", false))) {
            this.lock.lockInterruptibly();
            try {
                coll.getSlices().forEach(s -> {
                    Replica leader = s.getLeader();
                    ReplicaInfo ri = this.getReplicaInfo(leader);
                    Number numDocs = (Number)ri.getVariable("SEARCHER.searcher.numDocs");
                    if (numDocs == null || numDocs.intValue() == 0) {
                        numDocs = 0;
                    }
                    try {
                        this.simSetShardValue(ri.getCollection(), ri.getShard(), "SEARCHER.searcher.maxDoc", numDocs, false, false);
                        this.simSetShardValue(ri.getCollection(), ri.getShard(), "SEARCHER.searcher.deletedDocs", 0, false, false);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            finally {
                this.lock.unlock();
            }
        }
        return new UpdateResponse();
    }

    public QueryResponse simQuery(QueryRequest req) throws SolrException, InterruptedException, IOException {
        this.ensureNotClosed();
        String collection = req.getCollection();
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection not set");
        }
        this.ensureSystemCollection(collection);
        if (!this.colShardReplicaMap.containsKey(collection)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection does not exist");
        }
        String query = req.getParams().get("q");
        if (query == null || !query.equals("*:*")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only '*:*' query is supported");
        }
        ClusterState clusterState = this.getClusterState();
        DocCollection coll = clusterState.getCollection(collection);
        AtomicLong count = new AtomicLong();
        for (Slice s : coll.getActiveSlicesArr()) {
            Replica r = s.getLeader();
            if (r == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, collection + "/" + s.getName() + " has no leader");
            }
            ReplicaInfo ri = this.getReplicaInfo(r);
            Number numDocs = (Number)ri.getVariable("SEARCHER.searcher.numDocs", (Object)0L);
            count.addAndGet(numDocs.longValue());
            AtomicLong bufferedUpdates = (AtomicLong)this.sliceProperties.get(collection).get(s.getName()).get(BUFFERED_UPDATES);
            if (bufferedUpdates == null) continue;
            count.addAndGet(bufferedUpdates.get());
        }
        QueryResponse rsp = new QueryResponse();
        NamedList values = new NamedList();
        values.add("responseHeader", (Object)new NamedList());
        SolrDocumentList docs = new SolrDocumentList();
        docs.setNumFound(count.get());
        values.add("response", (Object)docs);
        rsp.setResponse(values);
        return rsp;
    }

    private void ensureSystemCollection(String collection) throws InterruptedException, IOException {
        if (!this.simListCollections().contains(collection)) {
            if (".system".equals(collection)) {
                this.createSystemCollection();
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collection + "' doesn't exist");
            }
        }
    }

    private static String createRegistryName(String collection, String shard, Replica r) {
        return SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, collection, shard, Utils.parseMetricsReplicaName((String)collection, (String)r.getCoreName()));
    }

    private synchronized Map<String, Object> saveClusterProperties() throws Exception {
        if (this.lastSavedProperties != null && this.lastSavedProperties.equals(this.clusterProperties)) {
            return this.lastSavedProperties;
        }
        byte[] data = Utils.toJSON(this.clusterProperties);
        VersionedData oldData = this.stateManager.getData("/clusterprops.json");
        int version = oldData != null ? oldData.getVersion() : -1;
        this.stateManager.setData("/clusterprops.json", data, version);
        this.lastSavedProperties = new ConcurrentHashMap<String, Object>((Map)Utils.fromJSON((byte[])data));
        return this.lastSavedProperties;
    }

    public void simSetClusterProperties(Map<String, Object> properties) throws Exception {
        this.lock.lockInterruptibly();
        try {
            this.clusterProperties.clear();
            if (properties != null) {
                this.clusterProperties.putAll(properties);
            }
            this.saveClusterProperties();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simSetClusterProperty(String key, Object value) throws Exception {
        this.lock.lockInterruptibly();
        try {
            if (value != null) {
                this.clusterProperties.put(key, value);
            } else {
                this.clusterProperties.remove(key);
            }
            this.saveClusterProperties();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSetCollectionProperties(String coll, Map<String, Object> properties) throws Exception {
        this.lock.lockInterruptibly();
        try {
            if (properties == null) {
                this.collProperties.remove(coll);
            } else {
                Map props = this.collProperties.computeIfAbsent(coll, c -> new HashMap());
                props.clear();
                props.putAll(properties);
            }
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSetCollectionProperty(String coll, String key, String value) throws Exception {
        this.lock.lockInterruptibly();
        try {
            Map props = this.collProperties.computeIfAbsent(coll, c -> new HashMap());
            if (value == null) {
                props.remove(key);
            } else {
                props.put(key, value);
            }
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simSetSliceProperties(String coll, String slice, Map<String, Object> properties) throws Exception {
        this.lock.lockInterruptibly();
        try {
            Map sliceProps = this.sliceProperties.computeIfAbsent(coll, c -> new HashMap()).computeIfAbsent(slice, s -> new HashMap());
            sliceProps.clear();
            if (properties != null) {
                sliceProps.putAll(properties);
            }
            this.collectionsStatesRef.set(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void simSetCollectionValue(String collection, String key, Object value) throws Exception {
        this.simSetCollectionValue(collection, key, value, false, false);
    }

    public void simSetCollectionValue(String collection, String key, Object value, boolean delta, boolean divide) throws Exception {
        this.simSetShardValue(collection, null, key, value, delta, divide);
    }

    public void simSetShardValue(String collection, String shard, String key, Object value) throws Exception {
        this.simSetShardValue(collection, shard, key, value, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void simSetShardValue(String collection, String shard, String key, Object value, boolean delta, boolean divide) throws Exception {
        List infos;
        if (shard == null) {
            infos = new ArrayList();
            this.colShardReplicaMap.computeIfAbsent(collection, c -> new ConcurrentHashMap()).forEach((sh, replicas) -> infos.addAll(replicas));
        } else {
            infos = this.colShardReplicaMap.computeIfAbsent(collection, c -> new ConcurrentHashMap()).computeIfAbsent(shard, s -> new ArrayList());
        }
        if (infos.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection " + collection + " doesn't exist (shard=" + shard + ").");
        }
        if (divide && value != null && value instanceof Number) {
            value = value instanceof Long || value instanceof Integer ? (Number)(((Number)value).longValue() / (long)infos.size()) : (Number)(((Number)value).doubleValue() / (double)infos.size());
        }
        Iterator iterator = infos.iterator();
        while (iterator.hasNext()) {
            ReplicaInfo r;
            ReplicaInfo replicaInfo = r = (ReplicaInfo)iterator.next();
            synchronized (replicaInfo) {
                if (value == null) {
                    r.getVariables().remove(key);
                } else if (delta) {
                    Object prevValue = r.getVariables().get(key);
                    if (prevValue != null) {
                        if (!(prevValue instanceof Number) || !(value instanceof Number)) throw new UnsupportedOperationException("delta cannot be applied to non-numeric values: " + prevValue + " and " + value);
                        if ((prevValue instanceof Long || prevValue instanceof Integer || prevValue instanceof AtomicLong || prevValue instanceof AtomicInteger) && (value instanceof Long || value instanceof Integer)) {
                            long newValue = ((Number)prevValue).longValue() + ((Number)value).longValue();
                            if (prevValue instanceof AtomicLong) {
                                ((AtomicLong)prevValue).set(newValue);
                            } else if (prevValue instanceof AtomicInteger) {
                                ((AtomicInteger)prevValue).set(((Number)prevValue).intValue() + ((Number)value).intValue());
                            } else {
                                r.getVariables().put(key, newValue);
                            }
                        } else {
                            double newValue = ((Number)prevValue).doubleValue() + ((Number)value).doubleValue();
                            if (prevValue instanceof AtomicDouble) {
                                ((AtomicDouble)prevValue).set(newValue);
                            } else {
                                r.getVariables().put(key, newValue);
                            }
                        }
                    } else if (value instanceof Integer) {
                        r.getVariables().put(key, new AtomicInteger((Integer)value));
                    } else if (value instanceof Long) {
                        r.getVariables().put(key, new AtomicLong((Long)value));
                    } else if (value instanceof Double) {
                        r.getVariables().put(key, new AtomicDouble(((Double)value).doubleValue()));
                    } else {
                        r.getVariables().put(key, value);
                    }
                } else if (value instanceof Integer) {
                    r.getVariables().put(key, new AtomicInteger((Integer)value));
                } else if (value instanceof Long) {
                    r.getVariables().put(key, new AtomicLong((Long)value));
                } else if (value instanceof Double) {
                    r.getVariables().put(key, new AtomicDouble(((Double)value).doubleValue()));
                } else {
                    r.getVariables().put(key, value);
                }
            }
        }
    }

    public void simSetReplicaValues(String node, Map<String, Map<String, List<ReplicaInfo>>> source, boolean overwrite) {
        List<ReplicaInfo> infos = this.nodeReplicaMap.get(node);
        if (infos == null) {
            throw new RuntimeException("Node not present: " + node);
        }
        HashMap infoMap = new HashMap();
        infos.forEach(ri -> infoMap.computeIfAbsent(ri.getCollection(), o -> new HashMap()).put(ri.getName(), ri));
        source.forEach((coll, shards) -> shards.forEach((shard, replicas) -> replicas.forEach(r -> {
            ReplicaInfo target = (ReplicaInfo)infoMap.getOrDefault(coll, Collections.emptyMap()).get(r.getName());
            if (target == null) {
                throw new RuntimeException("Unable to find simulated replica of " + r);
            }
            r.getVariables().forEach((k, v) -> {
                if (target.getVariables().containsKey(k)) {
                    if (overwrite) {
                        target.getVariables().put(k, v);
                    }
                } else {
                    target.getVariables().put(k, v);
                }
            });
        })));
    }

    public List<ReplicaInfo> simGetReplicaInfos(String node) {
        List replicas = this.nodeReplicaMap.computeIfAbsent(node, o -> Collections.synchronizedList(new ArrayList()));
        return Arrays.asList(replicas.toArray(new ReplicaInfo[replicas.size()]));
    }

    public List<ReplicaInfo> simGetReplicaInfos(String collection, String shard) {
        List replicas = this.colShardReplicaMap.computeIfAbsent(collection, c -> new ConcurrentHashMap()).computeIfAbsent(shard, s -> new ArrayList());
        if (replicas == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(replicas.toArray(new ReplicaInfo[replicas.size()]));
    }

    public ReplicaInfo simGetReplicaInfo(String collection, String coreNode) {
        Map shardsReplicas = this.colShardReplicaMap.computeIfAbsent(collection, c -> new ConcurrentHashMap());
        for (List replicas : shardsReplicas.values()) {
            for (ReplicaInfo ri : replicas) {
                if (!ri.getName().equals(coreNode)) continue;
                return ri;
            }
        }
        return null;
    }

    public List<String> simListCollections() throws InterruptedException {
        return new ArrayList<String>(this.colShardReplicaMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> simGetCollectionStats() throws IOException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            TreeMap<String, Map<String, Object>> stats = new TreeMap<String, Map<String, Object>>();
            this.collectionsStatesRef.set(null);
            ClusterState state = this.getClusterState();
            state.forEachCollection(coll -> {
                LinkedHashMap<String, Object> perColl = new LinkedHashMap<String, Object>();
                stats.put(coll.getName(), perColl);
                perColl.put("shardsTotal", coll.getSlices().size());
                TreeMap<String, AtomicInteger> shardState = new TreeMap<String, AtomicInteger>();
                int noLeader = 0;
                SummaryStatistics docs = new SummaryStatistics();
                SummaryStatistics bytes = new SummaryStatistics();
                SummaryStatistics inactiveDocs = new SummaryStatistics();
                SummaryStatistics inactiveBytes = new SummaryStatistics();
                long deletedDocs = 0L;
                long bufferedDocs = 0L;
                int totalReplicas = 0;
                int activeReplicas = 0;
                for (Slice s : coll.getSlices()) {
                    shardState.computeIfAbsent(s.getState().toString(), st -> new AtomicInteger()).incrementAndGet();
                    totalReplicas += s.getReplicas().size();
                    if (s.getState() != Slice.State.ACTIVE) {
                        ReplicaInfo ri;
                        if (s.getReplicas().isEmpty() || (ri = this.getReplicaInfo((Replica)s.getReplicas().iterator().next())) == null) continue;
                        Number numDocs = (Number)ri.getVariable("SEARCHER.searcher.numDocs");
                        Number numBytes = (Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
                        if (numDocs != null) {
                            inactiveDocs.addValue(numDocs.doubleValue());
                        }
                        if (numBytes == null) continue;
                        inactiveBytes.addValue(numBytes.doubleValue());
                        continue;
                    }
                    AtomicLong buffered = (AtomicLong)this.sliceProperties.get(coll.getName()).get(s.getName()).get(BUFFERED_UPDATES);
                    if (buffered != null) {
                        bufferedDocs += buffered.get();
                    }
                    for (Replica r : s.getReplicas()) {
                        if (r.getState() != Replica.State.ACTIVE) continue;
                        ++activeReplicas;
                    }
                    Replica leader = s.getLeader();
                    if (leader == null) {
                        ++noLeader;
                        if (!s.getReplicas().isEmpty()) {
                            leader = (Replica)s.getReplicas().iterator().next();
                        }
                    }
                    ReplicaInfo ri = null;
                    if (leader != null && (ri = this.getReplicaInfo(leader)) == null) {
                        log.warn("Unknown ReplicaInfo for {}", (Object)leader);
                    }
                    if (ri == null) continue;
                    Number numDocs = (Number)ri.getVariable("SEARCHER.searcher.numDocs");
                    Number delDocs = (Number)ri.getVariable("SEARCHER.searcher.deleteDocs");
                    Number numBytes = (Number)ri.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
                    if (numDocs != null) {
                        docs.addValue(numDocs.doubleValue());
                    }
                    if (delDocs != null) {
                        deletedDocs += delDocs.longValue();
                    }
                    if (numBytes == null) continue;
                    bytes.addValue(numBytes.doubleValue());
                }
                perColl.put("shardsState", shardState);
                perColl.put("  shardsWithoutLeader", noLeader);
                perColl.put("totalReplicas", totalReplicas);
                perColl.put("  activeReplicas", activeReplicas);
                perColl.put("  inactiveReplicas", totalReplicas - activeReplicas);
                long totalDocs = (long)docs.getSum() + bufferedDocs;
                perColl.put("totalActiveDocs", String.format(Locale.ROOT, "%,d", totalDocs));
                perColl.put("  bufferedDocs", String.format(Locale.ROOT, "%,d", bufferedDocs));
                perColl.put("  maxActiveSliceDocs", String.format(Locale.ROOT, "%,d", (long)docs.getMax()));
                perColl.put("  minActiveSliceDocs", String.format(Locale.ROOT, "%,d", (long)docs.getMin()));
                perColl.put("  avgActiveSliceDocs", String.format(Locale.ROOT, "%,.0f", docs.getMean()));
                perColl.put("totalInactiveDocs", String.format(Locale.ROOT, "%,d", (long)inactiveDocs.getSum()));
                perColl.put("  maxInactiveSliceDocs", String.format(Locale.ROOT, "%,d", (long)inactiveDocs.getMax()));
                perColl.put("  minInactiveSliceDocs", String.format(Locale.ROOT, "%,d", (long)inactiveDocs.getMin()));
                perColl.put("  avgInactiveSliceDocs", String.format(Locale.ROOT, "%,.0f", inactiveDocs.getMean()));
                perColl.put("totalActiveBytes", String.format(Locale.ROOT, "%,d", (long)bytes.getSum()));
                perColl.put("  maxActiveSliceBytes", String.format(Locale.ROOT, "%,d", (long)bytes.getMax()));
                perColl.put("  minActiveSliceBytes", String.format(Locale.ROOT, "%,d", (long)bytes.getMin()));
                perColl.put("  avgActiveSliceBytes", String.format(Locale.ROOT, "%,.0f", bytes.getMean()));
                perColl.put("totalInactiveBytes", String.format(Locale.ROOT, "%,d", (long)inactiveBytes.getSum()));
                perColl.put("  maxInactiveSliceBytes", String.format(Locale.ROOT, "%,d", (long)inactiveBytes.getMax()));
                perColl.put("  minInactiveSliceBytes", String.format(Locale.ROOT, "%,d", (long)inactiveBytes.getMin()));
                perColl.put("  avgInactiveSliceBytes", String.format(Locale.ROOT, "%,.0f", inactiveBytes.getMean()));
                perColl.put("totalActiveDeletedDocs", String.format(Locale.ROOT, "%,d", deletedDocs));
            });
            TreeMap<String, Map<String, Object>> treeMap = stats;
            return treeMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ClusterState.CollectionRef getState(String collection) {
        try {
            return this.getClusterState().getCollectionRef(collection);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Set<String> getLiveNodes() {
        return this.liveNodes.get();
    }

    public List<String> resolveAlias(String alias) {
        throw new UnsupportedOperationException("resolveAlias not implemented");
    }

    public Map<String, String> getAliasProperties(String alias) {
        throw new UnsupportedOperationException("getAliasProperties not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getClusterState() throws IOException {
        this.ensureNotClosed();
        this.lock.lockInterruptibly();
        try {
            ClusterState state;
            Map<String, DocCollection> states = this.getCollectionStates();
            ClusterState clusterState = state = new ClusterState(Integer.valueOf(this.clusterStateVersion), this.liveNodes.get(), states);
            this.lock.unlock();
            return clusterState;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DocCollection> getCollectionStates() throws IOException, InterruptedException {
        this.lock.lockInterruptibly();
        try {
            Map<String, DocCollection> collectionStates = this.collectionsStatesRef.get();
            if (collectionStates != null) {
                Map<String, DocCollection> map = collectionStates;
                return map;
            }
            this.collectionsStatesRef.set(null);
            log.debug("** creating new collection states, currentVersion={}", (Object)this.clusterStateVersion);
            HashMap<String, Map> collMap = new HashMap<String, Map>();
            this.nodeReplicaMap.forEach((n, replicas) -> {
                List list = replicas;
                synchronized (list) {
                    replicas.forEach(ri -> {
                        HashMap<String, String> props;
                        ReplicaInfo replicaInfo = ri;
                        synchronized (replicaInfo) {
                            props = new HashMap<String, String>(ri.getVariables());
                        }
                        props.put("node_name", (String)n);
                        props.put("core", ri.getCore());
                        props.put("type", ri.getType().toString());
                        props.put("state", ri.getState().toString());
                        Replica r = new Replica(ri.getName(), props, ri.getCollection(), ri.getShard());
                        collMap.computeIfAbsent(ri.getCollection(), c -> new HashMap()).computeIfAbsent(ri.getShard(), s -> new HashMap()).put(ri.getName(), r);
                    });
                }
            });
            this.sliceProperties.forEach((c, perSliceProps) -> perSliceProps.forEach((slice, props) -> collMap.computeIfAbsent((String)c, co -> new ConcurrentHashMap()).computeIfAbsent(slice, s -> new ConcurrentHashMap())));
            this.collProperties.keySet().forEach(c -> collMap.computeIfAbsent((String)c, co -> new ConcurrentHashMap()));
            HashMap<String, DocCollection> res = new HashMap<String, DocCollection>();
            collMap.forEach((coll, shards) -> {
                HashMap slices = new HashMap();
                shards.forEach((s, replicas) -> {
                    Map sliceProps = this.sliceProperties.computeIfAbsent((String)coll, c -> new ConcurrentHashMap()).computeIfAbsent(s, sl -> new ConcurrentHashMap());
                    Slice slice = new Slice(s, replicas, sliceProps, coll);
                    slices.put(s, slice);
                });
                Map collProps = this.collProperties.computeIfAbsent((String)coll, c -> new ConcurrentHashMap());
                Map<String, String> routerProp = collProps.getOrDefault("router", Collections.singletonMap("name", "compositeId"));
                DocRouter router = DocRouter.getDocRouter((String)routerProp.getOrDefault("name", "compositeId"));
                DocCollection dc = new DocCollection(coll, slices, collProps, router, this.clusterStateVersion, "/clusterstate.json");
                res.put((String)coll, dc);
            });
            this.saveClusterState(new ClusterState(Integer.valueOf(this.clusterStateVersion), this.liveNodes.get(), res));
            this.collectionsStatesRef.set(res);
            HashMap<String, DocCollection> hashMap = res;
            return hashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, Object> getClusterProperties() {
        return this.clusterProperties;
    }

    public String getPolicyNameByCollection(String coll) {
        Map props = this.collProperties.computeIfAbsent(coll, c -> new HashMap());
        return (String)props.get("policy");
    }

    public void connect() {
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void ensureNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("already closed");
        }
    }
}

