/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.runtime.FlatLists;

public abstract class BiRel
extends AbstractRelNode {
    protected RelNode left;
    protected RelNode right;

    protected BiRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right) {
        super(cluster, traitSet);
        this.left = left;
        this.right = right;
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        visitor.visit(this.left, 0, this);
        visitor.visit(this.right, 1, this);
    }

    @Override
    public List<RelNode> getInputs() {
        return FlatLists.of(this.left, this.right);
    }

    public RelNode getLeft() {
        return this.left;
    }

    public RelNode getRight() {
        return this.right;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        switch (ordinalInParent) {
            case 0: {
                this.left = p;
                break;
            }
            case 1: {
                this.right = p;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Input " + ordinalInParent);
            }
        }
        this.recomputeDigest();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).input("left", this.left).input("right", this.right);
    }
}

