/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import opennlp.tools.formats.letsmt.LetsmtDocument;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

class LetsmtSentenceStream
implements ObjectStream<SentenceSample> {
    private final LetsmtDocument source;
    private Iterator<LetsmtDocument.LetsmtSentence> sentenceIt;

    LetsmtSentenceStream(LetsmtDocument source) {
        this.source = source;
        this.reset();
    }

    @Override
    public SentenceSample read() throws IOException {
        StringBuilder sentencesString = new StringBuilder();
        LinkedList<Span> sentenceSpans = new LinkedList<Span>();
        for (int i = 0; this.sentenceIt.hasNext() && i < 25; ++i) {
            LetsmtDocument.LetsmtSentence sentence = this.sentenceIt.next();
            int begin = sentencesString.length();
            if (sentence.getTokens() != null) {
                sentencesString.append(String.join((CharSequence)" ", sentence.getTokens()));
            } else if (sentence.getNonTokenizedText() != null) {
                sentencesString.append(sentence.getNonTokenizedText());
            }
            sentenceSpans.add(new Span(begin, sentencesString.length()));
            sentencesString.append(' ');
        }
        if (sentenceSpans.size() == 0) {
            return null;
        }
        return new SentenceSample(sentencesString.toString(), sentenceSpans.toArray(new Span[sentenceSpans.size()]));
    }

    @Override
    public void reset() {
        this.sentenceIt = this.source.getSentences().iterator();
    }
}

