/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

abstract class MethodCallNode
extends JavaValueNode {
    String methodName;
    String javaClassName;
    RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    protected JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    String[] methodParameterTypes;

    MethodCallNode() {
    }

    public void init(Object object) {
        this.methodName = (String)object;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public Member getResolvedMethod() {
        return this.method;
    }

    public RoutineAliasInfo getRoutineInfo() {
        return this.routineInfo;
    }

    public void addParms(List list) throws StandardException {
        this.methodParms = new JavaValueNode[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            QueryTreeNode queryTreeNode = (QueryTreeNode)list.get(i);
            if (!(queryTreeNode instanceof JavaValueNode)) {
                queryTreeNode = (QueryTreeNode)this.getNodeFactory().getNode(28, queryTreeNode, this.getContextManager());
            }
            this.methodParms[i] = (JavaValueNode)queryTreeNode;
        }
    }

    public Class[] getMethodParameterClasses() {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        Class[] classArray = new Class[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            String string = this.methodParameterTypes[i];
            try {
                classArray[i] = classInspector.getClass(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return classArray;
    }

    void getCorrelationTables(JBitSet jBitSet) throws StandardException {
        CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(ColumnReference.class);
        this.accept(collectNodesVisitor);
        Vector vector = collectNodesVisitor.getList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ColumnReference columnReference = (ColumnReference)enumeration.nextElement();
            if (!columnReference.getCorrelated()) continue;
            jBitSet.set(columnReference.getTableNumber());
        }
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.methodParms != null) {
            int n = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[n];
            }
            for (int i = 0; i < n; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i] = this.methodParms[i].bindExpression(fromList, subqueryList, vector);
                if (this.routineInfo != null) continue;
                this.signature[i] = this.methodParms[i].getJSQLType();
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String string, String[] stringArray, String[] stringArray2) throws StandardException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i].length() != 0 ? stringArray[i] : "UNTYPED");
            if (stringArray2 == null || stringArray2[i].equals(stringArray[i])) continue;
            stringBuffer.append("(" + stringArray2[i] + ")");
        }
        throw StandardException.newException("42X50", (Object)string, (Object)this.methodName, (Object)stringBuffer);
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i].preprocess(n, fromList, subqueryList, predicateList);
            }
        }
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                bl2 = this.methodParms[i].categorize(jBitSet, bl) && bl2;
            }
        }
        return bl2;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] == null) continue;
                this.methodParms[i] = this.methodParms[i].remapColumnReferencesToExpressions();
            }
        }
        return this;
    }

    public int generateParameters(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String[] stringArray = this.methodParameterTypes;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        for (int i = 0; i < this.methodParms.length; ++i) {
            this.generateOneParameter(expressionClassBuilder, methodBuilder, i);
            String string = MethodCallNode.getParameterTypeName(this.methodParms[i]);
            String string2 = stringArray[i];
            if (string2.equals(string)) continue;
            if (ClassInspector.primitiveType(string2)) {
                methodBuilder.cast(string2);
                continue;
            }
            if (this.routineInfo != null) continue;
            methodBuilder.upCast(string2);
        }
        return this.methodParms.length;
    }

    public static String getParameterTypeName(JavaValueNode javaValueNode) throws StandardException {
        String string = javaValueNode.isPrimitiveType() ? javaValueNode.getPrimitiveTypeName() : javaValueNode.getJavaTypeName();
        return string;
    }

    public void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.methodParms[n].generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void setNullParameterInfo(String[] stringArray) throws StandardException {
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!this.methodParms[i].getJavaTypeName().equals("")) continue;
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(stringArray[i]);
            ((SQLToJavaValueNode)this.methodParms[i]).value.setType(dataTypeDescriptor);
            this.methodParms[i].setJavaTypeName(stringArray[i]);
            this.signature[i] = this.methodParms[i].getJSQLType();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String string, boolean bl) throws StandardException {
        Object object;
        String string2;
        String[] stringArray;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            String string3;
            StringBuffer stringBuffer = new StringBuffer().append(string);
            if (bl) {
                string3 = "::";
                throw StandardException.newException("42X01", stringBuffer.append(string3).append(this.methodName).toString());
            }
            string3 = ".";
            throw StandardException.newException("42X01", stringBuffer.append(string3).append(this.methodName).toString());
        }
        int n = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] stringArray2 = null;
        boolean[] blArray = this.getIsParam();
        boolean bl2 = this.routineInfo != null && n != 0 && n != this.methodParms.length;
        int n2 = this.methodName.indexOf(40);
        if (n2 != -1) {
            stringArray = this.parseValidateSignature(this.methodName, n2, bl2);
            this.methodName = this.methodName.substring(0, n2);
            bl2 = false;
        } else {
            stringArray = this.getObjectSignature();
        }
        try {
            this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, null, blArray, bl, bl2);
            if (n2 == -1 && this.routineInfo == null && this.method == null) {
                stringArray2 = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, stringArray2, blArray, bl, bl2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(string, stringArray, stringArray2);
        }
        this.actualMethodReturnType = string2 = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (string2.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09");
            }
        } else {
            boolean bl3;
            Object object2;
            String string4;
            String string5 = null;
            object = (TypeDescriptorImpl)this.routineInfo.getReturnType();
            if (object == null) {
                string4 = "void";
            } else {
                TypeId typeId = TypeId.getBuiltInTypeId(((TypeDescriptorImpl)object).getJDBCTypeId());
                if (((TypeDescriptorImpl)object).isRowMultiSet() && this.routineInfo.getParameterStyle() == 1) {
                    string4 = ResultSet.class.getName();
                } else if (((TypeDescriptorImpl)object).getTypeId().userType()) {
                    string4 = ((UserDefinedTypeIdImpl)((TypeDescriptorImpl)object).getTypeId()).getClassName();
                } else {
                    string4 = typeId.getCorrespondingJavaTypeName();
                    if (!string4.equals(string2)) {
                        switch (((TypeDescriptorImpl)object).getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 16: {
                                object2 = this.getTypeCompiler(typeId);
                                string4 = object2.getCorrespondingPrimitiveTypeName();
                                if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                                string5 = typeId.getCorrespondingJavaTypeName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ResultSet.class.getName().equals(string4)) {
                try {
                    object2 = classInspector.getClass(string2);
                    bl3 = ResultSet.class.isAssignableFrom((Class<?>)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl3 = false;
                }
            } else {
                bl3 = string4.equals(string2);
            }
            if (!bl3) {
                this.throwNoMethodFound(string4 + " " + string, stringArray, stringArray2);
            }
            if (string5 != null) {
                string2 = string5;
            }
            if (this.routineInfo.getReturnType() != null) {
                this.setCollationType(this.routineInfo.getReturnType().getCollationType());
            }
        }
        this.setJavaTypeName(string2);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        block12: for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            object = this.methodParameterTypes[i];
            if (this.routineInfo != null && i < this.routineInfo.getParameterCount()) {
                int n3 = this.routineInfo.getParameterModes()[i];
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        object = ((String)object).substring(0, ((String)object).length() - 2);
                        break;
                    }
                    case 4: {
                        continue block12;
                    }
                }
            }
            if (!ClassInspector.primitiveType((String)object)) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string2);
        if (!this.getCompilerContext().getReturnParameterFlag()) return;
        this.getCompilerContext().getParameterTypes()[0] = dataTypeDescriptor;
    }

    private String[] parseValidateSignature(String string, int n, boolean bl) throws StandardException {
        String[] stringArray;
        int n2 = string.length();
        if (n + 1 == n2 || string.charAt(n2 - 1) != ')') {
            throw StandardException.newException("46J01");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, n2 - 1), ",", true);
        String[] stringArray2 = new String[this.signature.length];
        boolean bl2 = false;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray3;
            Object object;
            stringArray = stringTokenizer.nextToken().trim();
            if (",".equals(stringArray)) {
                if (!bl2) {
                    throw StandardException.newException("46J01");
                }
                bl2 = false;
                continue;
            }
            if (stringArray.length() == 0) {
                throw StandardException.newException("46J01");
            }
            bl2 = true;
            if (++n3 > this.signature.length) {
                if (bl) {
                    object = this.signature[this.signature.length - 1].getSQLType().getTypeId().getCorrespondingJavaTypeName();
                    if (!stringArray.equals(object)) {
                        throw StandardException.newException("22005", (Object)stringArray, object);
                    }
                    if (stringArray2.length == this.signature.length) {
                        stringArray3 = new String[stringTokenizer.countTokens()];
                        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                        stringArray2 = stringArray3;
                    }
                    stringArray2[n3 - 1] = stringArray;
                    continue;
                }
                throw StandardException.newException("46J02", (Object)Integer.toString(n3), (Object)Integer.toString(this.signature.length));
            }
            object = this.signature[n3 - 1].getSQLType().getTypeId();
            if (stringArray.equals(((TypeId)object).getCorrespondingJavaTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            if ((((TypeId)object).isNumericTypeId() && !((TypeId)object).isDecimalTypeId() || ((TypeId)object).isBooleanTypeId()) && stringArray.equals((stringArray3 = this.getTypeCompiler((TypeId)object)).getCorrespondingPrimitiveTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            throw StandardException.newException("22005", (Object)stringArray, (Object)((TypeId)object).getSQLTypeName());
        }
        if (n3 != 0 && !bl2) {
            throw StandardException.newException("46J01");
        }
        if (n3 < stringArray2.length) {
            if (bl && n3 == this.signature.length - 1) {
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                return stringArray;
            }
            throw StandardException.newException("46J02", (Object)Integer.toString(n3), (Object)Integer.toString(this.signature.length));
        }
        return stringArray2;
    }

    protected boolean someParametersAreNull() {
        int n = this.signature.length;
        for (int i = 0; i < n; ++i) {
            if (this.signature[i] != null) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getObjectTypeName(this.signature[i]);
        }
        return stringArray;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[this.methodParms.length];
        for (int i = 0; i < this.methodParms.length; ++i) {
            if (!(this.methodParms[i] instanceof SQLToJavaValueNode)) continue;
            SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[i];
            if (!sQLToJavaValueNode.value.requiresTypeFromContext()) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private String getObjectTypeName(JSQLType jSQLType) throws StandardException {
        if (jSQLType != null) {
            switch (jSQLType.getCategory()) {
                case 0: {
                    TypeId typeId = this.mapToTypeID(jSQLType);
                    if (typeId == null) {
                        return null;
                    }
                    switch (typeId.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 16: {
                            if (this.routineInfo == null) break;
                            TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                            return typeCompiler.getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return typeId.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jSQLType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
                }
            }
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean bl) throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        block5: for (int i = 0; i < n; ++i) {
            JSQLType jSQLType = this.signature[i];
            if (jSQLType == null) {
                stringArray[i] = "";
                continue;
            }
            switch (jSQLType.getCategory()) {
                case 0: {
                    if (this.procedurePrimitiveArrayType != null && i < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[i] != null) {
                        stringArray[i] = this.procedurePrimitiveArrayType[i];
                        continue block5;
                    }
                    TypeId typeId = this.mapToTypeID(jSQLType);
                    if (typeId.isNumericTypeId() && !typeId.isDecimalTypeId() || typeId.isBooleanTypeId()) {
                        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                        stringArray[i] = typeCompiler.getCorrespondingPrimitiveTypeName();
                        if (!bl) continue block5;
                        this.methodParms[i].castToPrimitive(true);
                        continue block5;
                    }
                    stringArray[i] = typeId.getCorrespondingJavaTypeName();
                    continue block5;
                }
                case 1: {
                    stringArray[i] = jSQLType.getJavaClassName();
                    continue block5;
                }
                case 2: {
                    stringArray[i] = JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
                    if (!bl) continue block5;
                    this.methodParms[i].castToPrimitive(true);
                    continue block5;
                }
            }
        }
        return stringArray;
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int n = 2;
        if (this.methodParms != null) {
            for (int i = 0; i < this.methodParms.length; ++i) {
                if (this.methodParms[i] != null) {
                    int n2 = this.methodParms[i].getOrderableVariantType();
                    if (n2 >= n) continue;
                    n = n2;
                    continue;
                }
                n = 0;
            }
        }
        return n;
    }

    public DataTypeDescriptor getDataType() throws StandardException {
        TypeDescriptor typeDescriptor;
        if (this.routineInfo != null && (typeDescriptor = this.routineInfo.getReturnType()) != null) {
            return DataTypeDescriptor.getType(typeDescriptor);
        }
        return super.getDataType();
    }

    public JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        for (int i = 0; !visitor.stopTraversal() && i < this.methodParms.length; ++i) {
            if (this.methodParms[i] == null) continue;
            this.methodParms[i] = (JavaValueNode)this.methodParms[i].accept(visitor);
        }
    }
}

