# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class SourcesService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """SourcesService - a operation defined in OpenAPI."""
        if api_client is None:
            raise ValueError("Invalid value for `api_client`, must be defined.")
        self.api_client = api_client

    def delete_sources_id(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sources_id(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sources_id_with_http_info(source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sources_id_with_http_info(source_id, **kwargs)  # noqa: E501
            return data

    def delete_sources_id_with_http_info(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sources_id_with_http_info(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_sources_id_prepare(source_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_sources_id_async(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_sources_id_prepare(source_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources/{sourceID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_sources_id_prepare(self, source_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_sources_id', all_params, local_var_params)
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `delete_sources_id`")  # noqa: E501

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_sources(self, **kwargs):  # noqa: E501,D401,D403
        """List all sources.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Sources
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sources_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sources_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sources_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all sources.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Sources
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/sources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Sources',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_sources_async(self, **kwargs):  # noqa: E501,D401,D403
        """List all sources.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Sources
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Sources',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_sources_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'org']  # noqa: E501
        self._check_operation_params('get_sources', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_sources_id(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sources_id_with_http_info(source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sources_id_with_http_info(source_id, **kwargs)  # noqa: E501
            return data

    def get_sources_id_with_http_info(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_with_http_info(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_prepare(source_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Source',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_sources_id_async(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_prepare(source_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources/{sourceID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Source',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_sources_id_prepare(self, source_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_sources_id', all_params, local_var_params)
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `get_sources_id`")  # noqa: E501

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_sources_id_buckets(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_buckets(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sources_id_buckets_with_http_info(source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sources_id_buckets_with_http_info(source_id, **kwargs)  # noqa: E501
            return data

    def get_sources_id_buckets_with_http_info(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_buckets_with_http_info(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_buckets_prepare(source_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Buckets',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_sources_id_buckets_async(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get buckets in a source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str org: The name of the organization.
        :return: Buckets
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_buckets_prepare(source_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources/{sourceID}/buckets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Buckets',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_sources_id_buckets_prepare(self, source_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source_id', 'zap_trace_span', 'org']  # noqa: E501
        self._check_operation_params('get_sources_id_buckets', all_params, local_var_params)
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `get_sources_id_buckets`")  # noqa: E501

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_sources_id_health(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get the health of a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_health(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: HealthCheck
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sources_id_health_with_http_info(source_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sources_id_health_with_http_info(source_id, **kwargs)  # noqa: E501
            return data

    def get_sources_id_health_with_http_info(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get the health of a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sources_id_health_with_http_info(source_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: HealthCheck
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_health_prepare(source_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}/health', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='HealthCheck',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_sources_id_health_async(self, source_id, **kwargs):  # noqa: E501,D401,D403
        """Get the health of a source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: HealthCheck
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_sources_id_health_prepare(source_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources/{sourceID}/health', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='HealthCheck',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_sources_id_health_prepare(self, source_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_sources_id_health', all_params, local_var_params)
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `get_sources_id_health`")  # noqa: E501

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_sources_id(self, source_id, source, **kwargs):  # noqa: E501,D401,D403
        """Update a Source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_sources_id(source_id, source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param Source source: Source update (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_sources_id_with_http_info(source_id, source, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_sources_id_with_http_info(source_id, source, **kwargs)  # noqa: E501
            return data

    def patch_sources_id_with_http_info(self, source_id, source, **kwargs):  # noqa: E501,D401,D403
        """Update a Source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_sources_id_with_http_info(source_id, source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param Source source: Source update (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_sources_id_prepare(source_id, source, **kwargs)

        return self.api_client.call_api(
            '/api/v2/sources/{sourceID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Source',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_sources_id_async(self, source_id, source, **kwargs):  # noqa: E501,D401,D403
        """Update a Source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str source_id: The source ID. (required)
        :param Source source: Source update (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_sources_id_prepare(source_id, source, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources/{sourceID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Source',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_sources_id_prepare(self, source_id, source, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source_id', 'source', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_sources_id', all_params, local_var_params)
        # verify the required parameter 'source_id' is set
        if ('source_id' not in local_var_params or
                local_var_params['source_id'] is None):
            raise ValueError("Missing the required parameter `source_id` when calling `patch_sources_id`")  # noqa: E501
        # verify the required parameter 'source' is set
        if ('source' not in local_var_params or
                local_var_params['source'] is None):
            raise ValueError("Missing the required parameter `source` when calling `patch_sources_id`")  # noqa: E501

        path_params = {}
        if 'source_id' in local_var_params:
            path_params['sourceID'] = local_var_params['source_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'source' in local_var_params:
            body_params = local_var_params['source']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_sources(self, source, **kwargs):  # noqa: E501,D401,D403
        """Create a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_sources(source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Source source: Source to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_sources_with_http_info(source, **kwargs)  # noqa: E501
        else:
            (data) = self.post_sources_with_http_info(source, **kwargs)  # noqa: E501
            return data

    def post_sources_with_http_info(self, source, **kwargs):  # noqa: E501,D401,D403
        """Create a source.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_sources_with_http_info(source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Source source: Source to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_sources_prepare(source, **kwargs)

        return self.api_client.call_api(
            '/api/v2/sources', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Source',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_sources_async(self, source, **kwargs):  # noqa: E501,D401,D403
        """Create a source.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param Source source: Source to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: Source
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_sources_prepare(source, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/sources', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Source',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_sources_prepare(self, source, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['source', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_sources', all_params, local_var_params)
        # verify the required parameter 'source' is set
        if ('source' not in local_var_params or
                local_var_params['source'] is None):
            raise ValueError("Missing the required parameter `source` when calling `post_sources`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'source' in local_var_params:
            body_params = local_var_params['source']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
