/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) | (- 0u)) => uvec3(36u, 32u, 88u)
 * (uvec3(36u, 32u, 88u) | (- 6u)) => uvec3(4294967294u, 4294967290u, 4294967290u)
 * (uvec3(36u, 32u, 88u) | (- 12u)) => uvec3(4294967284u, 4294967284u, 4294967292u)
 * (uvec3(36u, 32u, 88u) | (- 32u)) => uvec3(4294967268u, 4294967264u, 4294967288u)
 * (uvec3(36u, 32u, 88u) | (- 74u)) => uvec3(4294967222u, 4294967222u, 4294967294u)
 * (uvec3(59u, 77u, 68u) | (- 0u)) => uvec3(59u, 77u, 68u)
 * (uvec3(59u, 77u, 68u) | (- 6u)) => uvec3(4294967291u, 4294967295u, 4294967294u)
 * (uvec3(59u, 77u, 68u) | (- 12u)) => uvec3(4294967295u, 4294967293u, 4294967284u)
 * (uvec3(59u, 77u, 68u) | (- 32u)) => uvec3(4294967291u, 4294967277u, 4294967268u)
 * (uvec3(59u, 77u, 68u) | (- 74u)) => uvec3(4294967231u, 4294967295u, 4294967286u)
 */
#version 150

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) | (- 0u)), uvec3(36u, 32u, 88u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) | (- 6u)), uvec3(4294967294u, 4294967290u, 4294967290u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) | (- 12u)), uvec3(4294967284u, 4294967284u, 4294967292u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) | (- 32u)), uvec3(4294967268u, 4294967264u, 4294967288u))) ? 1 : -1] array3;
  float[all(equal((uvec3(36u, 32u, 88u) | (- 74u)), uvec3(4294967222u, 4294967222u, 4294967294u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) | (- 0u)), uvec3(59u, 77u, 68u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) | (- 6u)), uvec3(4294967291u, 4294967295u, 4294967294u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) | (- 12u)), uvec3(4294967295u, 4294967293u, 4294967284u))) ? 1 : -1] array7;
  float[all(equal((uvec3(59u, 77u, 68u) | (- 32u)), uvec3(4294967291u, 4294967277u, 4294967268u))) ? 1 : -1] array8;
  float[all(equal((uvec3(59u, 77u, 68u) | (- 74u)), uvec3(4294967231u, 4294967295u, 4294967286u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
