/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) & 12) => ivec4(0, 8, 8, 4)
 * (ivec4(-64, 72, 88, -76) & -6) => ivec4(-64, 72, 88, -80)
 * (ivec4(-64, 72, 88, -76) & 76) => ivec4(64, 72, 72, 4)
 * (ivec4(-64, 72, 88, -76) & -32) => ivec4(-64, 64, 64, -96)
 * (ivec4(-64, 72, 88, -76) & 0) => ivec4(0, 0, 0, 0)
 * (ivec4(64, 72, 88, 76) & 12) => ivec4(0, 8, 8, 12)
 * (ivec4(64, 72, 88, 76) & -6) => ivec4(64, 72, 88, 72)
 * (ivec4(64, 72, 88, 76) & 76) => ivec4(64, 72, 72, 76)
 * (ivec4(64, 72, 88, 76) & -32) => ivec4(64, 64, 64, 64)
 * (ivec4(64, 72, 88, 76) & 0) => ivec4(0, 0, 0, 0)
 * (ivec4(-24, 40, -23, 64) & 12) => ivec4(8, 8, 8, 0)
 * (ivec4(-24, 40, -23, 64) & -6) => ivec4(-24, 40, -24, 64)
 * (ivec4(-24, 40, -23, 64) & 76) => ivec4(72, 8, 72, 64)
 * (ivec4(-24, 40, -23, 64) & -32) => ivec4(-32, 32, -32, 64)
 * (ivec4(-24, 40, -23, 64) & 0) => ivec4(0, 0, 0, 0)
 * (ivec4(24, 40, 23, 64) & 12) => ivec4(8, 8, 4, 0)
 * (ivec4(24, 40, 23, 64) & -6) => ivec4(24, 40, 18, 64)
 * (ivec4(24, 40, 23, 64) & 76) => ivec4(8, 8, 4, 64)
 * (ivec4(24, 40, 23, 64) & -32) => ivec4(0, 32, 0, 64)
 * (ivec4(24, 40, 23, 64) & 0) => ivec4(0, 0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) & 12), ivec4(0, 8, 8, 4))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) & -6), ivec4(-64, 72, 88, -80))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) & 76), ivec4(64, 72, 72, 4))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) & -32), ivec4(-64, 64, 64, -96))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) & 0), ivec4(0, 0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) & 12), ivec4(0, 8, 8, 12))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) & -6), ivec4(64, 72, 88, 72))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) & 76), ivec4(64, 72, 72, 76))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) & -32), ivec4(64, 64, 64, 64))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) & 0), ivec4(0, 0, 0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) & 12), ivec4(8, 8, 8, 0))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) & -6), ivec4(-24, 40, -24, 64))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) & 76), ivec4(72, 8, 72, 64))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) & -32), ivec4(-32, 32, -32, 64))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) & 0), ivec4(0, 0, 0, 0))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) & 12), ivec4(8, 8, 4, 0))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) & -6), ivec4(24, 40, 18, 64))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) & 76), ivec4(8, 8, 4, 64))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) & -32), ivec4(0, 32, 0, 64))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) & 0), ivec4(0, 0, 0, 0))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
