"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReport = void 0;

var _constants = require("../utils/constants");

var _savedSearchReportHelper = require("../utils/savedSearchReportHelper");

var _visualReportHelper = require("../utils/visual_report/visualReportHelper");

var _saveReport = require("./saveReport");

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const createReport = async (request, context, report, config, savedReportId) => {
  const isScheduledTask = false; //@ts-ignore

  const logger = context.reporting_plugin.logger; //@ts-ignore

  const semaphore = context.reporting_plugin.semaphore; // @ts-ignore

  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request);
  const opensearchClient = context.core.opensearch.legacy.client; // @ts-ignore

  const timezone = request.query.timezone; // @ts-ignore

  const dateFormat = request.query.dateFormat || _constants.DATA_REPORT_CONFIG.excelDateFormat; // @ts-ignore

  const csvSeparator = request.query.csvSeparator || ',';
  const protocol = config.get('osd_server', 'protocol');
  const hostname = config.get('osd_server', 'hostname');
  const port = config.get('osd_server', 'port');
  const basePath = config.osdConfig.get('server', 'basePath');
  let createReportResult;
  let reportId;
  const {
    report_definition: {
      report_params: reportParams
    }
  } = report;
  const {
    report_source: reportSource
  } = reportParams;

  try {
    // create new report instance and set report state to "pending"
    if (savedReportId) {
      reportId = savedReportId;
    } else {
      const opensearchResp = await (0, _saveReport.saveReport)(report, opensearchReportsClient);
      reportId = opensearchResp.reportInstance.id;
    } // generate report


    if (reportSource === _constants.REPORT_TYPE.savedSearch) {
      createReportResult = await (0, _savedSearchReportHelper.createSavedSearchReport)(report, opensearchClient, dateFormat, csvSeparator, isScheduledTask, logger);
    } else {
      // report source can only be one of [saved search, visualization, dashboard, notebook]
      // compose url
      const relativeUrl = report.query_url.startsWith(basePath) ? report.query_url : `${basePath}${report.query_url}`;
      const completeQueryUrl = `${protocol}://${hostname}:${port}${relativeUrl}`;

      const extraHeaders = _lodash.default.pick(request.headers, _constants.EXTRA_HEADERS);

      const [value, release] = await semaphore.acquire();

      try {
        createReportResult = await (0, _visualReportHelper.createVisualReport)(reportParams, completeQueryUrl, logger, extraHeaders, timezone);
      } finally {
        release();
      }
    } // update report state to "created"
    // TODO: temporarily remove the following
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.created);
    // }

  } catch (error) {
    // update report instance with "error" state
    // TODO: save error detail and display on UI
    // TODO: temporarily disable the following, will add back
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.error);
    // }
    throw error;
  }

  return createReportResult;
};

exports.createReport = createReport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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