"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REPORTING_NOTIFICATIONS_DASHBOARDS_API = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.OPENSEARCH_REPORTS_API = exports.NOTIFICATIONS_API = exports.API_PREFIX = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const PLUGIN_NAME = 'Reporting';
exports.PLUGIN_NAME = PLUGIN_NAME;
const PLUGIN_ID = 'reports-dashboards';
exports.PLUGIN_ID = PLUGIN_ID;
const API_PREFIX = '/api/reporting';
exports.API_PREFIX = API_PREFIX;
const BASE_REPORTS_URI = '/_plugins/_reports';
const OPENSEARCH_REPORTS_API = {
  ON_DEMAND_REPORT: `${BASE_REPORTS_URI}/on_demand`,
  REPORT_INSTANCE: `${BASE_REPORTS_URI}/instance`,
  LIST_REPORT_INSTANCES: `${BASE_REPORTS_URI}/instances`,
  REPORT_DEFINITION: `${BASE_REPORTS_URI}/definition`,
  LIST_REPORT_DEFINITIONS: `${BASE_REPORTS_URI}/definitions`
};
exports.OPENSEARCH_REPORTS_API = OPENSEARCH_REPORTS_API;
const REPORTING_NOTIFICATIONS_API_PREFIX = '/api/reporting_notifications';
const REPORTING_NOTIFICATIONS_DASHBOARDS_API = Object.freeze({
  GET_CONFIGS: `${REPORTING_NOTIFICATIONS_API_PREFIX}/get_configs`,
  GET_EVENT: `${REPORTING_NOTIFICATIONS_API_PREFIX}/get_event`,
  SEND_TEST_MESSAGE: `${REPORTING_NOTIFICATIONS_API_PREFIX}/test_message`
});
exports.REPORTING_NOTIFICATIONS_DASHBOARDS_API = REPORTING_NOTIFICATIONS_DASHBOARDS_API;
const NOTIFICATIONS_API_BASE_PATH = '/_plugins/_notifications';
const NOTIFICATIONS_API = Object.freeze({
  CONFIGS: `${NOTIFICATIONS_API_BASE_PATH}/configs`,
  EVENTS: `${NOTIFICATIONS_API_BASE_PATH}/events`,
  TEST_MESSAGE: `${NOTIFICATIONS_API_BASE_PATH}/feature/test`
});
exports.NOTIFICATIONS_API = NOTIFICATIONS_API;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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