"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationServiceMock = exports.mainStateMock = exports.coreServicesMock = void 0;

var _services = require("../../public/services");

var _constants = require("../../public/utils/constants");

var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn().mockName('addDanger'),
      addSuccess: jest.fn().mockName('addSuccess'),
      addError: jest.fn().mockName('addError')
    }
  }
};
exports.coreServicesMock = coreServicesMock;
const browserServicesMock = new _services.NotificationService(_httpClientMock.default);
const notificationServiceMock = {
  notificationService: browserServicesMock
};
exports.notificationServiceMock = notificationServiceMock;
const mainStateMock = {
  availableChannels: _constants.CHANNEL_TYPE,
  availableConfigTypes: ['slack', 'chime', 'webhook', 'email', 'sns', 'smtp_account', 'ses_account', 'email_group'],
  tooltipSupport: true
};
exports.mainStateMock = mainStateMock;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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