// This file is autogenerated by build-schema-validator.js, do not edit

function nop () { return true }

'use strict';
var formats = require('ajv/lib/compile/formats')();
var equal = require('ajv/lib/compile/equal');
var validate = (function() {
  var refVal = [];
  var refVal1 = {
    "type": "integer",
    "minimum": 0
  };
  refVal[1] = refVal1;
  var refVal2 = (function() {
    return function validate(data, dataPath, parentData, parentDataProperty, rootData) {
      'use strict';
      var vErrors = null;
      var errors = 0;
      var errs_1 = errors;
      var errs_2 = errors;
      if ((typeof data !== "number" || (data % 1) || data !== data)) {
        validate.errors = [{
          keyword: 'type',
          dataPath: (dataPath || '') + "",
          schemaPath: '#/definitions/nonNegativeInteger/type',
          params: {
            type: 'integer'
          },
          message: 'should be integer'
        }];
        return false;
      }
      if (typeof data === "number") {
        if (data < 0 || data !== data) {
          validate.errors = [{
            keyword: 'minimum',
            dataPath: (dataPath || '') + "",
            schemaPath: '#/definitions/nonNegativeInteger/minimum',
            params: {
              comparison: '>=',
              limit: 0,
              exclusive: false
            },
            message: 'should be >= 0'
          }];
          return false;
        }
      }
      var valid2 = errors === errs_2;
      var valid1 = errors === errs_1;
      validate.errors = vErrors;
      return errors === 0;
    };
  })();
  refVal2.schema = {
    "allOf": [{
      "$ref": "#/definitions/nonNegativeInteger"
    }, {
      "default": 0
    }]
  };
  refVal2.errors = null;
  refVal[2] = refVal2;
  var refVal3 = (function() {
    return function validate(data, dataPath, parentData, parentDataProperty, rootData) {
      'use strict';
      var vErrors = null;
      var errors = 0;
      if (rootData === undefined) rootData = data;
      if (Array.isArray(data)) {
        if (data.length < 1) {
          validate.errors = [{
            keyword: 'minItems',
            dataPath: (dataPath || '') + "",
            schemaPath: '#/minItems',
            params: {
              limit: 1
            },
            message: 'should NOT have fewer than 1 items'
          }];
          return false;
        } else {
          var errs__0 = errors;
          var valid0;
          for (var i0 = 0; i0 < data.length; i0++) {
            var errs_1 = errors;
            if (!nop(data[i0], (dataPath || '') + '[' + i0 + ']', data, i0, rootData)) {
              if (vErrors === null) vErrors = nop.errors;
              else vErrors = vErrors.concat(nop.errors);
              errors = vErrors.length;
            }
            var valid1 = errors === errs_1;
            if (!valid1) break;
          }
        }
      } else {
        validate.errors = [{
          keyword: 'type',
          dataPath: (dataPath || '') + "",
          schemaPath: '#/type',
          params: {
            type: 'array'
          },
          message: 'should be array'
        }];
        return false;
      }
      validate.errors = vErrors;
      return errors === 0;
    };
  })();
  refVal3.schema = {
    "type": "array",
    "minItems": 1,
    "items": {
      "$ref": "#"
    }
  };
  refVal3.errors = null;
  refVal[3] = refVal3;
  var refVal4 = {
    "type": "array",
    "items": {
      "type": "string"
    },
    "uniqueItems": true,
    "default": []
  };
  refVal[4] = refVal4;
  var refVal5 = {
    "enum": ["array", "boolean", "integer", "null", "number", "object", "string"]
  };
  refVal[5] = refVal5;
  return function validate(data, dataPath, parentData, parentDataProperty, rootData) {
    'use strict'; /*# sourceURL=http://json-schema.org/draft-07/schema# */
    var vErrors = null;
    var errors = 0;
    if (rootData === undefined) rootData = data;
    if ((!data || typeof data !== "object" || Array.isArray(data)) && typeof data !== "boolean") {
      validate.errors = [{
        keyword: 'type',
        dataPath: (dataPath || '') + "",
        schemaPath: '#/type',
        params: {
          type: 'object,boolean'
        },
        message: 'should be object,boolean'
      }];
      return false;
    }
    if ((data && typeof data === "object" && !Array.isArray(data))) {
      var errs__0 = errors;
      var valid1 = true;
      var data1 = data.$id;
      if (data1 === undefined) {
        valid1 = true;
      } else {
        var errs_1 = errors;
        if (errors === errs_1) {
          if (typeof data1 === "string") {
            if (!formats['uri-reference'].test(data1)) {
              validate.errors = [{
                keyword: 'format',
                dataPath: (dataPath || '') + '.$id',
                schemaPath: '#/properties/%24id/format',
                params: {
                  format: 'uri-reference'
                },
                message: 'should match format "uri-reference"'
              }];
              return false;
            }
          } else {
            validate.errors = [{
              keyword: 'type',
              dataPath: (dataPath || '') + '.$id',
              schemaPath: '#/properties/%24id/type',
              params: {
                type: 'string'
              },
              message: 'should be string'
            }];
            return false;
          }
        }
        var valid1 = errors === errs_1;
      }
      if (valid1) {
        var data1 = data.$schema;
        if (data1 === undefined) {
          valid1 = true;
        } else {
          var errs_1 = errors;
          if (errors === errs_1) {
            if (typeof data1 === "string") {
              if (!formats.uri.test(data1)) {
                validate.errors = [{
                  keyword: 'format',
                  dataPath: (dataPath || '') + '.$schema',
                  schemaPath: '#/properties/%24schema/format',
                  params: {
                    format: 'uri'
                  },
                  message: 'should match format "uri"'
                }];
                return false;
              }
            } else {
              validate.errors = [{
                keyword: 'type',
                dataPath: (dataPath || '') + '.$schema',
                schemaPath: '#/properties/%24schema/type',
                params: {
                  type: 'string'
                },
                message: 'should be string'
              }];
              return false;
            }
          }
          var valid1 = errors === errs_1;
        }
        if (valid1) {
          var data1 = data.$ref;
          if (data1 === undefined) {
            valid1 = true;
          } else {
            var errs_1 = errors;
            if (errors === errs_1) {
              if (typeof data1 === "string") {
                if (!formats['uri-reference'].test(data1)) {
                  validate.errors = [{
                    keyword: 'format',
                    dataPath: (dataPath || '') + '.$ref',
                    schemaPath: '#/properties/%24ref/format',
                    params: {
                      format: 'uri-reference'
                    },
                    message: 'should match format "uri-reference"'
                  }];
                  return false;
                }
              } else {
                validate.errors = [{
                  keyword: 'type',
                  dataPath: (dataPath || '') + '.$ref',
                  schemaPath: '#/properties/%24ref/type',
                  params: {
                    type: 'string'
                  },
                  message: 'should be string'
                }];
                return false;
              }
            }
            var valid1 = errors === errs_1;
          }
          if (valid1) {
            if (data.$comment === undefined) {
              valid1 = true;
            } else {
              var errs_1 = errors;
              if (typeof data.$comment !== "string") {
                validate.errors = [{
                  keyword: 'type',
                  dataPath: (dataPath || '') + '.$comment',
                  schemaPath: '#/properties/%24comment/type',
                  params: {
                    type: 'string'
                  },
                  message: 'should be string'
                }];
                return false;
              }
              var valid1 = errors === errs_1;
            }
            if (valid1) {
              if (data.title === undefined) {
                valid1 = true;
              } else {
                var errs_1 = errors;
                if (typeof data.title !== "string") {
                  validate.errors = [{
                    keyword: 'type',
                    dataPath: (dataPath || '') + '.title',
                    schemaPath: '#/properties/title/type',
                    params: {
                      type: 'string'
                    },
                    message: 'should be string'
                  }];
                  return false;
                }
                var valid1 = errors === errs_1;
              }
              if (valid1) {
                if (data.description === undefined) {
                  valid1 = true;
                } else {
                  var errs_1 = errors;
                  if (typeof data.description !== "string") {
                    validate.errors = [{
                      keyword: 'type',
                      dataPath: (dataPath || '') + '.description',
                      schemaPath: '#/properties/description/type',
                      params: {
                        type: 'string'
                      },
                      message: 'should be string'
                    }];
                    return false;
                  }
                  var valid1 = errors === errs_1;
                }
                if (valid1) {
                  if (valid1) {
                    if (data.readOnly === undefined) {
                      valid1 = true;
                    } else {
                      var errs_1 = errors;
                      if (typeof data.readOnly !== "boolean") {
                        validate.errors = [{
                          keyword: 'type',
                          dataPath: (dataPath || '') + '.readOnly',
                          schemaPath: '#/properties/readOnly/type',
                          params: {
                            type: 'boolean'
                          },
                          message: 'should be boolean'
                        }];
                        return false;
                      }
                      var valid1 = errors === errs_1;
                    }
                    if (valid1) {
                      if (data.examples === undefined) {
                        valid1 = true;
                      } else {
                        var errs_1 = errors;
                        if (Array.isArray(data.examples)) {
                          var errs__1 = errors;
                          var valid1;
                        } else {
                          validate.errors = [{
                            keyword: 'type',
                            dataPath: (dataPath || '') + '.examples',
                            schemaPath: '#/properties/examples/type',
                            params: {
                              type: 'array'
                            },
                            message: 'should be array'
                          }];
                          return false;
                        }
                        var valid1 = errors === errs_1;
                      }
                      if (valid1) {
                        var data1 = data.multipleOf;
                        if (data1 === undefined) {
                          valid1 = true;
                        } else {
                          var errs_1 = errors;
                          if (typeof data1 === "number") {
                            if (data1 <= 0 || data1 !== data1) {
                              validate.errors = [{
                                keyword: 'exclusiveMinimum',
                                dataPath: (dataPath || '') + '.multipleOf',
                                schemaPath: '#/properties/multipleOf/exclusiveMinimum',
                                params: {
                                  comparison: '>',
                                  limit: 0,
                                  exclusive: true
                                },
                                message: 'should be > 0'
                              }];
                              return false;
                            }
                          } else {
                            validate.errors = [{
                              keyword: 'type',
                              dataPath: (dataPath || '') + '.multipleOf',
                              schemaPath: '#/properties/multipleOf/type',
                              params: {
                                type: 'number'
                              },
                              message: 'should be number'
                            }];
                            return false;
                          }
                          var valid1 = errors === errs_1;
                        }
                        if (valid1) {
                          if (data.maximum === undefined) {
                            valid1 = true;
                          } else {
                            var errs_1 = errors;
                            if (typeof data.maximum !== "number") {
                              validate.errors = [{
                                keyword: 'type',
                                dataPath: (dataPath || '') + '.maximum',
                                schemaPath: '#/properties/maximum/type',
                                params: {
                                  type: 'number'
                                },
                                message: 'should be number'
                              }];
                              return false;
                            }
                            var valid1 = errors === errs_1;
                          }
                          if (valid1) {
                            if (data.exclusiveMaximum === undefined) {
                              valid1 = true;
                            } else {
                              var errs_1 = errors;
                              if (typeof data.exclusiveMaximum !== "number") {
                                validate.errors = [{
                                  keyword: 'type',
                                  dataPath: (dataPath || '') + '.exclusiveMaximum',
                                  schemaPath: '#/properties/exclusiveMaximum/type',
                                  params: {
                                    type: 'number'
                                  },
                                  message: 'should be number'
                                }];
                                return false;
                              }
                              var valid1 = errors === errs_1;
                            }
                            if (valid1) {
                              if (data.minimum === undefined) {
                                valid1 = true;
                              } else {
                                var errs_1 = errors;
                                if (typeof data.minimum !== "number") {
                                  validate.errors = [{
                                    keyword: 'type',
                                    dataPath: (dataPath || '') + '.minimum',
                                    schemaPath: '#/properties/minimum/type',
                                    params: {
                                      type: 'number'
                                    },
                                    message: 'should be number'
                                  }];
                                  return false;
                                }
                                var valid1 = errors === errs_1;
                              }
                              if (valid1) {
                                if (data.exclusiveMinimum === undefined) {
                                  valid1 = true;
                                } else {
                                  var errs_1 = errors;
                                  if (typeof data.exclusiveMinimum !== "number") {
                                    validate.errors = [{
                                      keyword: 'type',
                                      dataPath: (dataPath || '') + '.exclusiveMinimum',
                                      schemaPath: '#/properties/exclusiveMinimum/type',
                                      params: {
                                        type: 'number'
                                      },
                                      message: 'should be number'
                                    }];
                                    return false;
                                  }
                                  var valid1 = errors === errs_1;
                                }
                                if (valid1) {
                                  var data1 = data.maxLength;
                                  if (data1 === undefined) {
                                    valid1 = true;
                                  } else {
                                    var errs_1 = errors;
                                    var errs_2 = errors;
                                    if ((typeof data1 !== "number" || (data1 % 1) || data1 !== data1)) {
                                      validate.errors = [{
                                        keyword: 'type',
                                        dataPath: (dataPath || '') + '.maxLength',
                                        schemaPath: '#/definitions/nonNegativeInteger/type',
                                        params: {
                                          type: 'integer'
                                        },
                                        message: 'should be integer'
                                      }];
                                      return false;
                                    }
                                    if (typeof data1 === "number") {
                                      if (data1 < 0 || data1 !== data1) {
                                        validate.errors = [{
                                          keyword: 'minimum',
                                          dataPath: (dataPath || '') + '.maxLength',
                                          schemaPath: '#/definitions/nonNegativeInteger/minimum',
                                          params: {
                                            comparison: '>=',
                                            limit: 0,
                                            exclusive: false
                                          },
                                          message: 'should be >= 0'
                                        }];
                                        return false;
                                      }
                                    }
                                    var valid2 = errors === errs_2;
                                    var valid1 = errors === errs_1;
                                  }
                                  if (valid1) {
                                    if (data.minLength === undefined) {
                                      valid1 = true;
                                    } else {
                                      var errs_1 = errors;
                                      if (!refVal2(data.minLength, (dataPath || '') + '.minLength', data, 'minLength', rootData)) {
                                        if (vErrors === null) vErrors = refVal2.errors;
                                        else vErrors = vErrors.concat(refVal2.errors);
                                        errors = vErrors.length;
                                      }
                                      var valid1 = errors === errs_1;
                                    }
                                    if (valid1) {
                                      var data1 = data.pattern;
                                      if (data1 === undefined) {
                                        valid1 = true;
                                      } else {
                                        var errs_1 = errors;
                                        if (errors === errs_1) {
                                          if (typeof data1 === "string") {
                                            if (!formats.regex(data1)) {
                                              validate.errors = [{
                                                keyword: 'format',
                                                dataPath: (dataPath || '') + '.pattern',
                                                schemaPath: '#/properties/pattern/format',
                                                params: {
                                                  format: 'regex'
                                                },
                                                message: 'should match format "regex"'
                                              }];
                                              return false;
                                            }
                                          } else {
                                            validate.errors = [{
                                              keyword: 'type',
                                              dataPath: (dataPath || '') + '.pattern',
                                              schemaPath: '#/properties/pattern/type',
                                              params: {
                                                type: 'string'
                                              },
                                              message: 'should be string'
                                            }];
                                            return false;
                                          }
                                        }
                                        var valid1 = errors === errs_1;
                                      }
                                      if (valid1) {
                                        if (data.additionalItems === undefined) {
                                          valid1 = true;
                                        } else {
                                          var errs_1 = errors;
                                          if (!validate(data.additionalItems, (dataPath || '') + '.additionalItems', data, 'additionalItems', rootData)) {
                                            if (vErrors === null) vErrors = validate.errors;
                                            else vErrors = vErrors.concat(validate.errors);
                                            errors = vErrors.length;
                                          }
                                          var valid1 = errors === errs_1;
                                        }
                                        if (valid1) {
                                          var data1 = data.items;
                                          if (data1 === undefined) {
                                            valid1 = true;
                                          } else {
                                            var errs_1 = errors;
                                            var errs__1 = errors;
                                            var valid1 = false;
                                            var errs_2 = errors;
                                            if (!validate(data1, (dataPath || '') + '.items', data, 'items', rootData)) {
                                              if (vErrors === null) vErrors = validate.errors;
                                              else vErrors = vErrors.concat(validate.errors);
                                              errors = vErrors.length;
                                            }
                                            var valid2 = errors === errs_2;
                                            valid1 = valid1 || valid2;
                                            if (!valid1) {
                                              var errs_2 = errors;
                                              if (!refVal3(data1, (dataPath || '') + '.items', data, 'items', rootData)) {
                                                if (vErrors === null) vErrors = refVal3.errors;
                                                else vErrors = vErrors.concat(refVal3.errors);
                                                errors = vErrors.length;
                                              }
                                              var valid2 = errors === errs_2;
                                              valid1 = valid1 || valid2;
                                            }
                                            if (!valid1) {
                                              var err = {
                                                keyword: 'anyOf',
                                                dataPath: (dataPath || '') + '.items',
                                                schemaPath: '#/properties/items/anyOf',
                                                params: {},
                                                message: 'should match some schema in anyOf'
                                              };
                                              if (vErrors === null) vErrors = [err];
                                              else vErrors.push(err);
                                              errors++;
                                              validate.errors = vErrors;
                                              return false;
                                            } else {
                                              errors = errs__1;
                                              if (vErrors !== null) {
                                                if (errs__1) vErrors.length = errs__1;
                                                else vErrors = null;
                                              }
                                            }
                                            var valid1 = errors === errs_1;
                                          }
                                          if (valid1) {
                                            var data1 = data.maxItems;
                                            if (data1 === undefined) {
                                              valid1 = true;
                                            } else {
                                              var errs_1 = errors;
                                              var errs_2 = errors;
                                              if ((typeof data1 !== "number" || (data1 % 1) || data1 !== data1)) {
                                                validate.errors = [{
                                                  keyword: 'type',
                                                  dataPath: (dataPath || '') + '.maxItems',
                                                  schemaPath: '#/definitions/nonNegativeInteger/type',
                                                  params: {
                                                    type: 'integer'
                                                  },
                                                  message: 'should be integer'
                                                }];
                                                return false;
                                              }
                                              if (typeof data1 === "number") {
                                                if (data1 < 0 || data1 !== data1) {
                                                  validate.errors = [{
                                                    keyword: 'minimum',
                                                    dataPath: (dataPath || '') + '.maxItems',
                                                    schemaPath: '#/definitions/nonNegativeInteger/minimum',
                                                    params: {
                                                      comparison: '>=',
                                                      limit: 0,
                                                      exclusive: false
                                                    },
                                                    message: 'should be >= 0'
                                                  }];
                                                  return false;
                                                }
                                              }
                                              var valid2 = errors === errs_2;
                                              var valid1 = errors === errs_1;
                                            }
                                            if (valid1) {
                                              if (data.minItems === undefined) {
                                                valid1 = true;
                                              } else {
                                                var errs_1 = errors;
                                                if (!refVal[2](data.minItems, (dataPath || '') + '.minItems', data, 'minItems', rootData)) {
                                                  if (vErrors === null) vErrors = refVal[2].errors;
                                                  else vErrors = vErrors.concat(refVal[2].errors);
                                                  errors = vErrors.length;
                                                }
                                                var valid1 = errors === errs_1;
                                              }
                                              if (valid1) {
                                                if (data.uniqueItems === undefined) {
                                                  valid1 = true;
                                                } else {
                                                  var errs_1 = errors;
                                                  if (typeof data.uniqueItems !== "boolean") {
                                                    validate.errors = [{
                                                      keyword: 'type',
                                                      dataPath: (dataPath || '') + '.uniqueItems',
                                                      schemaPath: '#/properties/uniqueItems/type',
                                                      params: {
                                                        type: 'boolean'
                                                      },
                                                      message: 'should be boolean'
                                                    }];
                                                    return false;
                                                  }
                                                  var valid1 = errors === errs_1;
                                                }
                                                if (valid1) {
                                                  if (data.contains === undefined) {
                                                    valid1 = true;
                                                  } else {
                                                    var errs_1 = errors;
                                                    if (!validate(data.contains, (dataPath || '') + '.contains', data, 'contains', rootData)) {
                                                      if (vErrors === null) vErrors = validate.errors;
                                                      else vErrors = vErrors.concat(validate.errors);
                                                      errors = vErrors.length;
                                                    }
                                                    var valid1 = errors === errs_1;
                                                  }
                                                  if (valid1) {
                                                    var data1 = data.maxProperties;
                                                    if (data1 === undefined) {
                                                      valid1 = true;
                                                    } else {
                                                      var errs_1 = errors;
                                                      var errs_2 = errors;
                                                      if ((typeof data1 !== "number" || (data1 % 1) || data1 !== data1)) {
                                                        validate.errors = [{
                                                          keyword: 'type',
                                                          dataPath: (dataPath || '') + '.maxProperties',
                                                          schemaPath: '#/definitions/nonNegativeInteger/type',
                                                          params: {
                                                            type: 'integer'
                                                          },
                                                          message: 'should be integer'
                                                        }];
                                                        return false;
                                                      }
                                                      if (typeof data1 === "number") {
                                                        if (data1 < 0 || data1 !== data1) {
                                                          validate.errors = [{
                                                            keyword: 'minimum',
                                                            dataPath: (dataPath || '') + '.maxProperties',
                                                            schemaPath: '#/definitions/nonNegativeInteger/minimum',
                                                            params: {
                                                              comparison: '>=',
                                                              limit: 0,
                                                              exclusive: false
                                                            },
                                                            message: 'should be >= 0'
                                                          }];
                                                          return false;
                                                        }
                                                      }
                                                      var valid2 = errors === errs_2;
                                                      var valid1 = errors === errs_1;
                                                    }
                                                    if (valid1) {
                                                      if (data.minProperties === undefined) {
                                                        valid1 = true;
                                                      } else {
                                                        var errs_1 = errors;
                                                        if (!refVal[2](data.minProperties, (dataPath || '') + '.minProperties', data, 'minProperties', rootData)) {
                                                          if (vErrors === null) vErrors = refVal[2].errors;
                                                          else vErrors = vErrors.concat(refVal[2].errors);
                                                          errors = vErrors.length;
                                                        }
                                                        var valid1 = errors === errs_1;
                                                      }
                                                      if (valid1) {
                                                        var data1 = data.required;
                                                        if (data1 === undefined) {
                                                          valid1 = true;
                                                        } else {
                                                          var errs_1 = errors;
                                                          var errs_2 = errors;
                                                          if (Array.isArray(data1)) {
                                                            var errs__2 = errors;
                                                            var valid2;
                                                            for (var i2 = 0; i2 < data1.length; i2++) {
                                                              var errs_3 = errors;
                                                              if (typeof data1[i2] !== "string") {
                                                                validate.errors = [{
                                                                  keyword: 'type',
                                                                  dataPath: (dataPath || '') + '.required[' + i2 + ']',
                                                                  schemaPath: '#/definitions/stringArray/items/type',
                                                                  params: {
                                                                    type: 'string'
                                                                  },
                                                                  message: 'should be string'
                                                                }];
                                                                return false;
                                                              }
                                                              var valid3 = errors === errs_3;
                                                              if (!valid3) break;
                                                            }
                                                            if (errs__2 == errors) {
                                                              var i = data1.length,
                                                                valid2 = true,
                                                                j;
                                                              if (i > 1) {
                                                                var itemIndices = {},
                                                                  item;
                                                                for (; i--;) {
                                                                  var item = data1[i];
                                                                  if (typeof item !== "string") continue;
                                                                  if (typeof itemIndices[item] == 'number') {
                                                                    valid2 = false;
                                                                    j = itemIndices[item];
                                                                    break;
                                                                  }
                                                                  itemIndices[item] = i;
                                                                }
                                                              }
                                                              if (!valid2) {
                                                                validate.errors = [{
                                                                  keyword: 'uniqueItems',
                                                                  dataPath: (dataPath || '') + '.required',
                                                                  schemaPath: '#/definitions/stringArray/uniqueItems',
                                                                  params: {
                                                                    i: i,
                                                                    j: j
                                                                  },
                                                                  message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)'
                                                                }];
                                                                return false;
                                                              }
                                                            }
                                                          } else {
                                                            validate.errors = [{
                                                              keyword: 'type',
                                                              dataPath: (dataPath || '') + '.required',
                                                              schemaPath: '#/definitions/stringArray/type',
                                                              params: {
                                                                type: 'array'
                                                              },
                                                              message: 'should be array'
                                                            }];
                                                            return false;
                                                          }
                                                          var valid2 = errors === errs_2;
                                                          var valid1 = errors === errs_1;
                                                        }
                                                        if (valid1) {
                                                          if (data.additionalProperties === undefined) {
                                                            valid1 = true;
                                                          } else {
                                                            var errs_1 = errors;
                                                            if (!validate(data.additionalProperties, (dataPath || '') + '.additionalProperties', data, 'additionalProperties', rootData)) {
                                                              if (vErrors === null) vErrors = validate.errors;
                                                              else vErrors = vErrors.concat(validate.errors);
                                                              errors = vErrors.length;
                                                            }
                                                            var valid1 = errors === errs_1;
                                                          }
                                                          if (valid1) {
                                                            var data1 = data.definitions;
                                                            if (data1 === undefined) {
                                                              valid1 = true;
                                                            } else {
                                                              var errs_1 = errors;
                                                              if ((data1 && typeof data1 === "object" && !Array.isArray(data1))) {
                                                                var errs__1 = errors;
                                                                var valid2 = true;
                                                                for (var key1 in data1) {
                                                                  var errs_2 = errors;
                                                                  if (!validate(data1[key1], (dataPath || '') + '.definitions[\'' + key1 + '\']', data1, key1, rootData)) {
                                                                    if (vErrors === null) vErrors = validate.errors;
                                                                    else vErrors = vErrors.concat(validate.errors);
                                                                    errors = vErrors.length;
                                                                  }
                                                                  var valid2 = errors === errs_2;
                                                                  if (!valid2) break;
                                                                }
                                                              } else {
                                                                validate.errors = [{
                                                                  keyword: 'type',
                                                                  dataPath: (dataPath || '') + '.definitions',
                                                                  schemaPath: '#/properties/definitions/type',
                                                                  params: {
                                                                    type: 'object'
                                                                  },
                                                                  message: 'should be object'
                                                                }];
                                                                return false;
                                                              }
                                                              var valid1 = errors === errs_1;
                                                            }
                                                            if (valid1) {
                                                              var data1 = data.properties;
                                                              if (data1 === undefined) {
                                                                valid1 = true;
                                                              } else {
                                                                var errs_1 = errors;
                                                                if ((data1 && typeof data1 === "object" && !Array.isArray(data1))) {
                                                                  var errs__1 = errors;
                                                                  var valid2 = true;
                                                                  for (var key1 in data1) {
                                                                    var errs_2 = errors;
                                                                    if (!validate(data1[key1], (dataPath || '') + '.properties[\'' + key1 + '\']', data1, key1, rootData)) {
                                                                      if (vErrors === null) vErrors = validate.errors;
                                                                      else vErrors = vErrors.concat(validate.errors);
                                                                      errors = vErrors.length;
                                                                    }
                                                                    var valid2 = errors === errs_2;
                                                                    if (!valid2) break;
                                                                  }
                                                                } else {
                                                                  validate.errors = [{
                                                                    keyword: 'type',
                                                                    dataPath: (dataPath || '') + '.properties',
                                                                    schemaPath: '#/properties/properties/type',
                                                                    params: {
                                                                      type: 'object'
                                                                    },
                                                                    message: 'should be object'
                                                                  }];
                                                                  return false;
                                                                }
                                                                var valid1 = errors === errs_1;
                                                              }
                                                              if (valid1) {
                                                                var data1 = data.patternProperties;
                                                                if (data1 === undefined) {
                                                                  valid1 = true;
                                                                } else {
                                                                  var errs_1 = errors;
                                                                  if ((data1 && typeof data1 === "object" && !Array.isArray(data1))) {
                                                                    var errs__1 = errors;
                                                                    for (var key1 in data1) {
                                                                      var startErrs1 = errors;
                                                                      var data2 = key1;
                                                                      var errs_2 = errors;
                                                                      if (errors === errs_2) {
                                                                        if (typeof data2 === "string") {
                                                                          if (!formats.regex(data2)) {
                                                                            var err = {
                                                                              keyword: 'format',
                                                                              dataPath: (dataPath || '') + '.patternProperties',
                                                                              schemaPath: '#/properties/patternProperties/propertyNames/format',
                                                                              params: {
                                                                                format: 'regex'
                                                                              },
                                                                              message: 'should match format "regex"'
                                                                            };
                                                                            if (vErrors === null) vErrors = [err];
                                                                            else vErrors.push(err);
                                                                            errors++;
                                                                          }
                                                                        }
                                                                      }
                                                                      var valid2 = errors === errs_2;
                                                                      if (!valid2) {
                                                                        for (var i1 = startErrs1; i1 < errors; i1++) {
                                                                          vErrors[i1].propertyName = key1;
                                                                        }
                                                                        var err = {
                                                                          keyword: 'propertyNames',
                                                                          dataPath: (dataPath || '') + '.patternProperties',
                                                                          schemaPath: '#/properties/patternProperties/propertyNames',
                                                                          params: {
                                                                            propertyName: '' + key1 + ''
                                                                          },
                                                                          message: 'property name \'' + key1 + '\' is invalid'
                                                                        };
                                                                        if (vErrors === null) vErrors = [err];
                                                                        else vErrors.push(err);
                                                                        errors++;
                                                                        validate.errors = vErrors;
                                                                        return false;
                                                                        break;
                                                                      }
                                                                    }
                                                                    if (errs__1 == errors) {
                                                                      var errs__1 = errors;
                                                                      var valid2 = true;
                                                                      for (var key1 in data1) {
                                                                        var errs_2 = errors;
                                                                        if (!validate(data1[key1], (dataPath || '') + '.patternProperties[\'' + key1 + '\']', data1, key1, rootData)) {
                                                                          if (vErrors === null) vErrors = validate.errors;
                                                                          else vErrors = vErrors.concat(validate.errors);
                                                                          errors = vErrors.length;
                                                                        }
                                                                        var valid2 = errors === errs_2;
                                                                        if (!valid2) break;
                                                                      }
                                                                    }
                                                                  } else {
                                                                    validate.errors = [{
                                                                      keyword: 'type',
                                                                      dataPath: (dataPath || '') + '.patternProperties',
                                                                      schemaPath: '#/properties/patternProperties/type',
                                                                      params: {
                                                                        type: 'object'
                                                                      },
                                                                      message: 'should be object'
                                                                    }];
                                                                    return false;
                                                                  }
                                                                  var valid1 = errors === errs_1;
                                                                }
                                                                if (valid1) {
                                                                  var data1 = data.dependencies;
                                                                  if (data1 === undefined) {
                                                                    valid1 = true;
                                                                  } else {
                                                                    var errs_1 = errors;
                                                                    if ((data1 && typeof data1 === "object" && !Array.isArray(data1))) {
                                                                      var errs__1 = errors;
                                                                      var valid2 = true;
                                                                      for (var key1 in data1) {
                                                                        var data2 = data1[key1];
                                                                        var errs_2 = errors;
                                                                        var errs__2 = errors;
                                                                        var valid2 = false;
                                                                        var errs_3 = errors;
                                                                        if (!validate(data2, (dataPath || '') + '.dependencies[\'' + key1 + '\']', data1, key1, rootData)) {
                                                                          if (vErrors === null) vErrors = validate.errors;
                                                                          else vErrors = vErrors.concat(validate.errors);
                                                                          errors = vErrors.length;
                                                                        }
                                                                        var valid3 = errors === errs_3;
                                                                        valid2 = valid2 || valid3;
                                                                        if (!valid2) {
                                                                          var errs_3 = errors;
                                                                          var errs_4 = errors;
                                                                          if (Array.isArray(data2)) {
                                                                            var errs__4 = errors;
                                                                            var valid4;
                                                                            for (var i4 = 0; i4 < data2.length; i4++) {
                                                                              var errs_5 = errors;
                                                                              if (typeof data2[i4] !== "string") {
                                                                                var err = {
                                                                                  keyword: 'type',
                                                                                  dataPath: (dataPath || '') + '.dependencies[\'' + key1 + '\'][' + i4 + ']',
                                                                                  schemaPath: '#/definitions/stringArray/items/type',
                                                                                  params: {
                                                                                    type: 'string'
                                                                                  },
                                                                                  message: 'should be string'
                                                                                };
                                                                                if (vErrors === null) vErrors = [err];
                                                                                else vErrors.push(err);
                                                                                errors++;
                                                                              }
                                                                              var valid5 = errors === errs_5;
                                                                              if (!valid5) break;
                                                                            }
                                                                            if (errs__4 == errors) {
                                                                              var i = data2.length,
                                                                                valid4 = true,
                                                                                j;
                                                                              if (i > 1) {
                                                                                var itemIndices = {},
                                                                                  item;
                                                                                for (; i--;) {
                                                                                  var item = data2[i];
                                                                                  if (typeof item !== "string") continue;
                                                                                  if (typeof itemIndices[item] == 'number') {
                                                                                    valid4 = false;
                                                                                    j = itemIndices[item];
                                                                                    break;
                                                                                  }
                                                                                  itemIndices[item] = i;
                                                                                }
                                                                              }
                                                                              if (!valid4) {
                                                                                var err = {
                                                                                  keyword: 'uniqueItems',
                                                                                  dataPath: (dataPath || '') + '.dependencies[\'' + key1 + '\']',
                                                                                  schemaPath: '#/definitions/stringArray/uniqueItems',
                                                                                  params: {
                                                                                    i: i,
                                                                                    j: j
                                                                                  },
                                                                                  message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)'
                                                                                };
                                                                                if (vErrors === null) vErrors = [err];
                                                                                else vErrors.push(err);
                                                                                errors++;
                                                                              }
                                                                            }
                                                                          } else {
                                                                            var err = {
                                                                              keyword: 'type',
                                                                              dataPath: (dataPath || '') + '.dependencies[\'' + key1 + '\']',
                                                                              schemaPath: '#/definitions/stringArray/type',
                                                                              params: {
                                                                                type: 'array'
                                                                              },
                                                                              message: 'should be array'
                                                                            };
                                                                            if (vErrors === null) vErrors = [err];
                                                                            else vErrors.push(err);
                                                                            errors++;
                                                                          }
                                                                          var valid4 = errors === errs_4;
                                                                          var valid3 = errors === errs_3;
                                                                          valid2 = valid2 || valid3;
                                                                        }
                                                                        if (!valid2) {
                                                                          var err = {
                                                                            keyword: 'anyOf',
                                                                            dataPath: (dataPath || '') + '.dependencies[\'' + key1 + '\']',
                                                                            schemaPath: '#/properties/dependencies/additionalProperties/anyOf',
                                                                            params: {},
                                                                            message: 'should match some schema in anyOf'
                                                                          };
                                                                          if (vErrors === null) vErrors = [err];
                                                                          else vErrors.push(err);
                                                                          errors++;
                                                                          validate.errors = vErrors;
                                                                          return false;
                                                                        } else {
                                                                          errors = errs__2;
                                                                          if (vErrors !== null) {
                                                                            if (errs__2) vErrors.length = errs__2;
                                                                            else vErrors = null;
                                                                          }
                                                                        }
                                                                        var valid2 = errors === errs_2;
                                                                        if (!valid2) break;
                                                                      }
                                                                    } else {
                                                                      validate.errors = [{
                                                                        keyword: 'type',
                                                                        dataPath: (dataPath || '') + '.dependencies',
                                                                        schemaPath: '#/properties/dependencies/type',
                                                                        params: {
                                                                          type: 'object'
                                                                        },
                                                                        message: 'should be object'
                                                                      }];
                                                                      return false;
                                                                    }
                                                                    var valid1 = errors === errs_1;
                                                                  }
                                                                  if (valid1) {
                                                                    if (data.propertyNames === undefined) {
                                                                      valid1 = true;
                                                                    } else {
                                                                      var errs_1 = errors;
                                                                      if (!validate(data.propertyNames, (dataPath || '') + '.propertyNames', data, 'propertyNames', rootData)) {
                                                                        if (vErrors === null) vErrors = validate.errors;
                                                                        else vErrors = vErrors.concat(validate.errors);
                                                                        errors = vErrors.length;
                                                                      }
                                                                      var valid1 = errors === errs_1;
                                                                    }
                                                                    if (valid1) {
                                                                      if (valid1) {
                                                                        var data1 = data.enum;
                                                                        if (data1 === undefined) {
                                                                          valid1 = true;
                                                                        } else {
                                                                          var errs_1 = errors;
                                                                          if (Array.isArray(data1)) {
                                                                            if (data1.length < 1) {
                                                                              validate.errors = [{
                                                                                keyword: 'minItems',
                                                                                dataPath: (dataPath || '') + '.enum',
                                                                                schemaPath: '#/properties/enum/minItems',
                                                                                params: {
                                                                                  limit: 1
                                                                                },
                                                                                message: 'should NOT have fewer than 1 items'
                                                                              }];
                                                                              return false;
                                                                            } else {
                                                                              var errs__1 = errors;
                                                                              var valid1;
                                                                              if (errs__1 == errors) {
                                                                                var i = data1.length,
                                                                                  valid1 = true,
                                                                                  j;
                                                                                if (i > 1) {
                                                                                  outer: for (; i--;) {
                                                                                    for (j = i; j--;) {
                                                                                      if (equal(data1[i], data1[j])) {
                                                                                        valid1 = false;
                                                                                        break outer;
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                                if (!valid1) {
                                                                                  validate.errors = [{
                                                                                    keyword: 'uniqueItems',
                                                                                    dataPath: (dataPath || '') + '.enum',
                                                                                    schemaPath: '#/properties/enum/uniqueItems',
                                                                                    params: {
                                                                                      i: i,
                                                                                      j: j
                                                                                    },
                                                                                    message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)'
                                                                                  }];
                                                                                  return false;
                                                                                }
                                                                              }
                                                                            }
                                                                          } else {
                                                                            validate.errors = [{
                                                                              keyword: 'type',
                                                                              dataPath: (dataPath || '') + '.enum',
                                                                              schemaPath: '#/properties/enum/type',
                                                                              params: {
                                                                                type: 'array'
                                                                              },
                                                                              message: 'should be array'
                                                                            }];
                                                                            return false;
                                                                          }
                                                                          var valid1 = errors === errs_1;
                                                                        }
                                                                        if (valid1) {
                                                                          var data1 = data.type;
                                                                          if (data1 === undefined) {
                                                                            valid1 = true;
                                                                          } else {
                                                                            var errs_1 = errors;
                                                                            var errs__1 = errors;
                                                                            var valid1 = false;
                                                                            var errs_2 = errors;
                                                                            var errs_3 = errors;
                                                                            var schema3 = refVal5.enum;
                                                                            var valid3;
                                                                            valid3 = false;
                                                                            for (var i3 = 0; i3 < schema3.length; i3++)
                                                                              if (equal(data1, schema3[i3])) {
                                                                                valid3 = true;
                                                                                break;
                                                                              } if (!valid3) {
                                                                              var err = {
                                                                                keyword: 'enum',
                                                                                dataPath: (dataPath || '') + '.type',
                                                                                schemaPath: '#/definitions/simpleTypes/enum',
                                                                                params: {
                                                                                  allowedValues: schema3
                                                                                },
                                                                                message: 'should be equal to one of the allowed values'
                                                                              };
                                                                              if (vErrors === null) vErrors = [err];
                                                                              else vErrors.push(err);
                                                                              errors++;
                                                                            }
                                                                            var valid3 = errors === errs_3;
                                                                            var valid2 = errors === errs_2;
                                                                            valid1 = valid1 || valid2;
                                                                            if (!valid1) {
                                                                              var errs_2 = errors;
                                                                              if (Array.isArray(data1)) {
                                                                                if (data1.length < 1) {
                                                                                  var err = {
                                                                                    keyword: 'minItems',
                                                                                    dataPath: (dataPath || '') + '.type',
                                                                                    schemaPath: '#/properties/type/anyOf/1/minItems',
                                                                                    params: {
                                                                                      limit: 1
                                                                                    },
                                                                                    message: 'should NOT have fewer than 1 items'
                                                                                  };
                                                                                  if (vErrors === null) vErrors = [err];
                                                                                  else vErrors.push(err);
                                                                                  errors++;
                                                                                } else {
                                                                                  var errs__2 = errors;
                                                                                  var valid2;
                                                                                  for (var i2 = 0; i2 < data1.length; i2++) {
                                                                                    var errs_3 = errors;
                                                                                    var errs_4 = errors;
                                                                                    var schema4 = refVal[5].enum;
                                                                                    var valid4;
                                                                                    valid4 = false;
                                                                                    for (var i4 = 0; i4 < schema4.length; i4++)
                                                                                      if (equal(data1[i2], schema4[i4])) {
                                                                                        valid4 = true;
                                                                                        break;
                                                                                      } if (!valid4) {
                                                                                      var err = {
                                                                                        keyword: 'enum',
                                                                                        dataPath: (dataPath || '') + '.type[' + i2 + ']',
                                                                                        schemaPath: '#/definitions/simpleTypes/enum',
                                                                                        params: {
                                                                                          allowedValues: schema4
                                                                                        },
                                                                                        message: 'should be equal to one of the allowed values'
                                                                                      };
                                                                                      if (vErrors === null) vErrors = [err];
                                                                                      else vErrors.push(err);
                                                                                      errors++;
                                                                                    }
                                                                                    var valid4 = errors === errs_4;
                                                                                    var valid3 = errors === errs_3;
                                                                                    if (!valid3) break;
                                                                                  }
                                                                                  if (errs__2 == errors) {
                                                                                    var i = data1.length,
                                                                                      valid2 = true,
                                                                                      j;
                                                                                    if (i > 1) {
                                                                                      outer: for (; i--;) {
                                                                                        for (j = i; j--;) {
                                                                                          if (equal(data1[i], data1[j])) {
                                                                                            valid2 = false;
                                                                                            break outer;
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                    if (!valid2) {
                                                                                      var err = {
                                                                                        keyword: 'uniqueItems',
                                                                                        dataPath: (dataPath || '') + '.type',
                                                                                        schemaPath: '#/properties/type/anyOf/1/uniqueItems',
                                                                                        params: {
                                                                                          i: i,
                                                                                          j: j
                                                                                        },
                                                                                        message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)'
                                                                                      };
                                                                                      if (vErrors === null) vErrors = [err];
                                                                                      else vErrors.push(err);
                                                                                      errors++;
                                                                                    }
                                                                                  }
                                                                                }
                                                                              } else {
                                                                                var err = {
                                                                                  keyword: 'type',
                                                                                  dataPath: (dataPath || '') + '.type',
                                                                                  schemaPath: '#/properties/type/anyOf/1/type',
                                                                                  params: {
                                                                                    type: 'array'
                                                                                  },
                                                                                  message: 'should be array'
                                                                                };
                                                                                if (vErrors === null) vErrors = [err];
                                                                                else vErrors.push(err);
                                                                                errors++;
                                                                              }
                                                                              var valid2 = errors === errs_2;
                                                                              valid1 = valid1 || valid2;
                                                                            }
                                                                            if (!valid1) {
                                                                              var err = {
                                                                                keyword: 'anyOf',
                                                                                dataPath: (dataPath || '') + '.type',
                                                                                schemaPath: '#/properties/type/anyOf',
                                                                                params: {},
                                                                                message: 'should match some schema in anyOf'
                                                                              };
                                                                              if (vErrors === null) vErrors = [err];
                                                                              else vErrors.push(err);
                                                                              errors++;
                                                                              validate.errors = vErrors;
                                                                              return false;
                                                                            } else {
                                                                              errors = errs__1;
                                                                              if (vErrors !== null) {
                                                                                if (errs__1) vErrors.length = errs__1;
                                                                                else vErrors = null;
                                                                              }
                                                                            }
                                                                            var valid1 = errors === errs_1;
                                                                          }
                                                                          if (valid1) {
                                                                            if (data.format === undefined) {
                                                                              valid1 = true;
                                                                            } else {
                                                                              var errs_1 = errors;
                                                                              if (typeof data.format !== "string") {
                                                                                validate.errors = [{
                                                                                  keyword: 'type',
                                                                                  dataPath: (dataPath || '') + '.format',
                                                                                  schemaPath: '#/properties/format/type',
                                                                                  params: {
                                                                                    type: 'string'
                                                                                  },
                                                                                  message: 'should be string'
                                                                                }];
                                                                                return false;
                                                                              }
                                                                              var valid1 = errors === errs_1;
                                                                            }
                                                                            if (valid1) {
                                                                              if (data.contentMediaType === undefined) {
                                                                                valid1 = true;
                                                                              } else {
                                                                                var errs_1 = errors;
                                                                                if (typeof data.contentMediaType !== "string") {
                                                                                  validate.errors = [{
                                                                                    keyword: 'type',
                                                                                    dataPath: (dataPath || '') + '.contentMediaType',
                                                                                    schemaPath: '#/properties/contentMediaType/type',
                                                                                    params: {
                                                                                      type: 'string'
                                                                                    },
                                                                                    message: 'should be string'
                                                                                  }];
                                                                                  return false;
                                                                                }
                                                                                var valid1 = errors === errs_1;
                                                                              }
                                                                              if (valid1) {
                                                                                if (data.contentEncoding === undefined) {
                                                                                  valid1 = true;
                                                                                } else {
                                                                                  var errs_1 = errors;
                                                                                  if (typeof data.contentEncoding !== "string") {
                                                                                    validate.errors = [{
                                                                                      keyword: 'type',
                                                                                      dataPath: (dataPath || '') + '.contentEncoding',
                                                                                      schemaPath: '#/properties/contentEncoding/type',
                                                                                      params: {
                                                                                        type: 'string'
                                                                                      },
                                                                                      message: 'should be string'
                                                                                    }];
                                                                                    return false;
                                                                                  }
                                                                                  var valid1 = errors === errs_1;
                                                                                }
                                                                                if (valid1) {
                                                                                  if (data.if === undefined) {
                                                                                    valid1 = true;
                                                                                  } else {
                                                                                    var errs_1 = errors;
                                                                                    if (!validate(data.if, (dataPath || '') + '.if', data, 'if', rootData)) {
                                                                                      if (vErrors === null) vErrors = validate.errors;
                                                                                      else vErrors = vErrors.concat(validate.errors);
                                                                                      errors = vErrors.length;
                                                                                    }
                                                                                    var valid1 = errors === errs_1;
                                                                                  }
                                                                                  if (valid1) {
                                                                                    if (data.then === undefined) {
                                                                                      valid1 = true;
                                                                                    } else {
                                                                                      var errs_1 = errors;
                                                                                      if (!validate(data.then, (dataPath || '') + '.then', data, 'then', rootData)) {
                                                                                        if (vErrors === null) vErrors = validate.errors;
                                                                                        else vErrors = vErrors.concat(validate.errors);
                                                                                        errors = vErrors.length;
                                                                                      }
                                                                                      var valid1 = errors === errs_1;
                                                                                    }
                                                                                    if (valid1) {
                                                                                      if (data.else === undefined) {
                                                                                        valid1 = true;
                                                                                      } else {
                                                                                        var errs_1 = errors;
                                                                                        if (!validate(data.else, (dataPath || '') + '.else', data, 'else', rootData)) {
                                                                                          if (vErrors === null) vErrors = validate.errors;
                                                                                          else vErrors = vErrors.concat(validate.errors);
                                                                                          errors = vErrors.length;
                                                                                        }
                                                                                        var valid1 = errors === errs_1;
                                                                                      }
                                                                                      if (valid1) {
                                                                                        if (data.allOf === undefined) {
                                                                                          valid1 = true;
                                                                                        } else {
                                                                                          var errs_1 = errors;
                                                                                          if (!refVal[3](data.allOf, (dataPath || '') + '.allOf', data, 'allOf', rootData)) {
                                                                                            if (vErrors === null) vErrors = refVal[3].errors;
                                                                                            else vErrors = vErrors.concat(refVal[3].errors);
                                                                                            errors = vErrors.length;
                                                                                          }
                                                                                          var valid1 = errors === errs_1;
                                                                                        }
                                                                                        if (valid1) {
                                                                                          if (data.anyOf === undefined) {
                                                                                            valid1 = true;
                                                                                          } else {
                                                                                            var errs_1 = errors;
                                                                                            if (!refVal[3](data.anyOf, (dataPath || '') + '.anyOf', data, 'anyOf', rootData)) {
                                                                                              if (vErrors === null) vErrors = refVal[3].errors;
                                                                                              else vErrors = vErrors.concat(refVal[3].errors);
                                                                                              errors = vErrors.length;
                                                                                            }
                                                                                            var valid1 = errors === errs_1;
                                                                                          }
                                                                                          if (valid1) {
                                                                                            if (data.oneOf === undefined) {
                                                                                              valid1 = true;
                                                                                            } else {
                                                                                              var errs_1 = errors;
                                                                                              if (!refVal[3](data.oneOf, (dataPath || '') + '.oneOf', data, 'oneOf', rootData)) {
                                                                                                if (vErrors === null) vErrors = refVal[3].errors;
                                                                                                else vErrors = vErrors.concat(refVal[3].errors);
                                                                                                errors = vErrors.length;
                                                                                              }
                                                                                              var valid1 = errors === errs_1;
                                                                                            }
                                                                                            if (valid1) {
                                                                                              if (data.not === undefined) {
                                                                                                valid1 = true;
                                                                                              } else {
                                                                                                var errs_1 = errors;
                                                                                                if (!validate(data.not, (dataPath || '') + '.not', data, 'not', rootData)) {
                                                                                                  if (vErrors === null) vErrors = validate.errors;
                                                                                                  else vErrors = vErrors.concat(validate.errors);
                                                                                                  errors = vErrors.length;
                                                                                                }
                                                                                                var valid1 = errors === errs_1;
                                                                                              }
                                                                                            }
                                                                                          }
                                                                                        }
                                                                                      }
                                                                                    }
                                                                                  }
                                                                                }
                                                                              }
                                                                            }
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                  }
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    validate.errors = vErrors;
    return errors === 0;
  };
})();
validate.schema = {
  "$schema": "http://json-schema.org/draft-07/schema#",
  "$id": "http://json-schema.org/draft-07/schema#",
  "title": "Core schema meta-schema",
  "definitions": {
    "schemaArray": {
      "type": "array",
      "minItems": 1,
      "items": {
        "$ref": "#"
      }
    },
    "nonNegativeInteger": {
      "type": "integer",
      "minimum": 0
    },
    "nonNegativeIntegerDefault0": {
      "allOf": [{
        "$ref": "#/definitions/nonNegativeInteger"
      }, {
        "default": 0
      }]
    },
    "simpleTypes": {
      "enum": ["array", "boolean", "integer", "null", "number", "object", "string"]
    },
    "stringArray": {
      "type": "array",
      "items": {
        "type": "string"
      },
      "uniqueItems": true,
      "default": []
    }
  },
  "type": ["object", "boolean"],
  "properties": {
    "$id": {
      "type": "string",
      "format": "uri-reference"
    },
    "$schema": {
      "type": "string",
      "format": "uri"
    },
    "$ref": {
      "type": "string",
      "format": "uri-reference"
    },
    "$comment": {
      "type": "string"
    },
    "title": {
      "type": "string"
    },
    "description": {
      "type": "string"
    },
    "default": true,
    "readOnly": {
      "type": "boolean",
      "default": false
    },
    "examples": {
      "type": "array",
      "items": true
    },
    "multipleOf": {
      "type": "number",
      "exclusiveMinimum": 0
    },
    "maximum": {
      "type": "number"
    },
    "exclusiveMaximum": {
      "type": "number"
    },
    "minimum": {
      "type": "number"
    },
    "exclusiveMinimum": {
      "type": "number"
    },
    "maxLength": {
      "$ref": "#/definitions/nonNegativeInteger"
    },
    "minLength": {
      "$ref": "#/definitions/nonNegativeIntegerDefault0"
    },
    "pattern": {
      "type": "string",
      "format": "regex"
    },
    "additionalItems": {
      "$ref": "#"
    },
    "items": {
      "anyOf": [{
        "$ref": "#"
      }, {
        "$ref": "#/definitions/schemaArray"
      }],
      "default": true
    },
    "maxItems": {
      "$ref": "#/definitions/nonNegativeInteger"
    },
    "minItems": {
      "$ref": "#/definitions/nonNegativeIntegerDefault0"
    },
    "uniqueItems": {
      "type": "boolean",
      "default": false
    },
    "contains": {
      "$ref": "#"
    },
    "maxProperties": {
      "$ref": "#/definitions/nonNegativeInteger"
    },
    "minProperties": {
      "$ref": "#/definitions/nonNegativeIntegerDefault0"
    },
    "required": {
      "$ref": "#/definitions/stringArray"
    },
    "additionalProperties": {
      "$ref": "#"
    },
    "definitions": {
      "type": "object",
      "additionalProperties": {
        "$ref": "#"
      },
      "default": {}
    },
    "properties": {
      "type": "object",
      "additionalProperties": {
        "$ref": "#"
      },
      "default": {}
    },
    "patternProperties": {
      "type": "object",
      "additionalProperties": {
        "$ref": "#"
      },
      "propertyNames": {
        "format": "regex"
      },
      "default": {}
    },
    "dependencies": {
      "type": "object",
      "additionalProperties": {
        "anyOf": [{
          "$ref": "#"
        }, {
          "$ref": "#/definitions/stringArray"
        }]
      }
    },
    "propertyNames": {
      "$ref": "#"
    },
    "const": true,
    "enum": {
      "type": "array",
      "items": true,
      "minItems": 1,
      "uniqueItems": true
    },
    "type": {
      "anyOf": [{
        "$ref": "#/definitions/simpleTypes"
      }, {
        "type": "array",
        "items": {
          "$ref": "#/definitions/simpleTypes"
        },
        "minItems": 1,
        "uniqueItems": true
      }]
    },
    "format": {
      "type": "string"
    },
    "contentMediaType": {
      "type": "string"
    },
    "contentEncoding": {
      "type": "string"
    },
    "if": {
      "$ref": "#"
    },
    "then": {
      "$ref": "#"
    },
    "else": {
      "$ref": "#"
    },
    "allOf": {
      "$ref": "#/definitions/schemaArray"
    },
    "anyOf": {
      "$ref": "#/definitions/schemaArray"
    },
    "oneOf": {
      "$ref": "#/definitions/schemaArray"
    },
    "not": {
      "$ref": "#"
    }
  },
  "default": true
};
validate.errors = null;
module.exports = validate;
