"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPageBody", {
  enumerable: true,
  get: function get() {
    return _page_body.EuiPageBody;
  }
});
exports.OuiPageBody = exports.PADDING_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

var _restrict_width = require("../_restrict_width");

var _panel = require("../../panel");

var _page_body = require("../../../eui_components/page/page_body/page_body");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var paddingSizeToClassNameMap = {
  none: null,
  s: 'ouiPageBody--paddingSmall',
  m: 'ouiPageBody--paddingMedium',
  l: 'ouiPageBody--paddingLarge'
};
var PADDING_SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
exports.PADDING_SIZES = PADDING_SIZES;

var OuiPageBody = function OuiPageBody(_ref) {
  var children = _ref.children,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
      style = _ref.style,
      className = _ref.className,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? 'div' : _ref$component,
      panelled = _ref.panelled,
      panelProps = _ref.panelProps,
      paddingSize = _ref.paddingSize,
      _ref$borderRadius = _ref.borderRadius,
      borderRadius = _ref$borderRadius === void 0 ? 'none' : _ref$borderRadius,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "restrictWidth", "style", "className", "component", "panelled", "panelProps", "paddingSize", "borderRadius"]);

  var _setPropsForRestricte = (0, _restrict_width.setPropsForRestrictedPageWidth)(restrictWidth, style),
      widthClassName = _setPropsForRestricte.widthClassName,
      newStyle = _setPropsForRestricte.newStyle;

  var nonBreakingDefaultPadding = panelled ? 'l' : 'none';
  paddingSize = paddingSize || nonBreakingDefaultPadding;
  var borderRadiusClass = borderRadius === 'none' ? 'ouiPageBody--borderRadiusNone' : '';
  var classes = (0, _classnames.default)('ouiPageBody', borderRadiusClass, // This may duplicate the padding styles from OuiPanel, but allows for some nested configurations in the CSS
  paddingSizeToClassNameMap[paddingSize], (0, _defineProperty2.default)({}, "ouiPageBody--".concat(widthClassName), widthClassName), className);
  return panelled ? /*#__PURE__*/_react.default.createElement(_panel.OuiPanel, (0, _extends2.default)({
    className: classes,
    style: newStyle || style,
    borderRadius: borderRadius,
    paddingSize: paddingSize
  }, panelProps, rest), children) : /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
    className: classes,
    style: newStyle || style
  }, rest), children);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiPageBody = OuiPageBody;