"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInitialPointerState = exports.isClicking = exports.getSpecsFromStore = void 0;
function getSpecsFromStore(specs, chartType, specType) {
    return Object.keys(specs)
        .filter(function (specId) {
        var currentSpec = specs[specId];
        var sameChartType = currentSpec.chartType === chartType;
        var sameSpecType = specType ? currentSpec.specType === specType : true;
        return sameChartType && sameSpecType;
    })
        .map(function (specId) { return specs[specId]; });
}
exports.getSpecsFromStore = getSpecsFromStore;
function isClicking(prevClick, lastClick) {
    if (prevClick === null && lastClick !== null) {
        return true;
    }
    return prevClick !== null && lastClick !== null && prevClick.time !== lastClick.time;
}
exports.isClicking = isClicking;
var getInitialPointerState = function () { return ({
    dragging: false,
    current: {
        position: {
            x: -1,
            y: -1,
        },
        time: 0,
    },
    down: null,
    up: null,
    lastDrag: null,
    lastClick: null,
}); };
exports.getInitialPointerState = getInitialPointerState;
//# sourceMappingURL=utils.js.map