"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withPanelTransform = void 0;
var canvas_1 = require("../../../../../renderers/canvas");
var common_1 = require("../../../../../utils/common");
var utils_1 = require("../../../state/utils/utils");
function withPanelTransform(context, panel, rotation, renderingArea, fn, clippings) {
    var transform = utils_1.computeChartTransform(panel, rotation);
    var left = renderingArea.left + panel.left + transform.x;
    var top = renderingArea.top + panel.top + transform.y;
    canvas_1.withContext(context, function (ctx) {
        ctx.translate(left, top);
        ctx.rotate(common_1.getRadians(rotation));
        if (clippings === null || clippings === void 0 ? void 0 : clippings.shouldClip) {
            var _a = clippings.area, x = _a.x, y = _a.y, width = _a.width, height = _a.height;
            ctx.save();
            ctx.beginPath();
            ctx.rect(x, y, width, height);
            ctx.clip();
        }
        fn(ctx);
        if (clippings === null || clippings === void 0 ? void 0 : clippings.shouldClip) {
            ctx.restore();
        }
    });
}
exports.withPanelTransform = withPanelTransform;
//# sourceMappingURL=panel_transform.js.map