"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.render = void 0;
var text_utils_1 = require("../../../../common/text_utils");
var common_1 = require("../../../../utils/common");
var config_1 = require("../../layout/config/config");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var viewmodel_1 = require("../../layout/viewmodel/viewmodel");
function render(spec, settingsSpec, chartDimensions, heatmapTable, colorScale, filterRanges, gridHeightParams) {
    var textMeasurer = document.createElement('canvas');
    var textMeasurerCtx = textMeasurer.getContext('2d');
    if (!textMeasurerCtx) {
        return viewmodel_types_1.nullShapeViewModel();
    }
    var width = chartDimensions.width, height = chartDimensions.height;
    var specConfig = spec.config;
    var partialConfig = __assign(__assign({}, specConfig), { width: width, height: height });
    var config = common_1.mergePartial(config_1.config, partialConfig);
    return viewmodel_1.shapeViewModel(text_utils_1.measureText(textMeasurerCtx), spec, config, settingsSpec, chartDimensions, heatmapTable, colorScale, filterRanges, gridHeightParams);
}
exports.render = render;
//# sourceMappingURL=scenegraph.js.map