/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.Indent;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.Output;
import java.util.ArrayList;
import java.util.List;

public abstract class Doc {
    private static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    private static final DiscreteDomain<Integer> INTEGERS = DiscreteDomain.integers();
    private boolean widthComputed = false;
    private float width = 0.0f;
    private boolean flatComputed = false;
    private String flat = "";
    private boolean rangeComputed = false;
    private Range<Integer> range = EMPTY_RANGE;

    final float getWidth() {
        if (!this.widthComputed) {
            this.width = this.computeWidth();
            this.widthComputed = true;
        }
        return this.width;
    }

    final String getFlat() {
        if (!this.flatComputed) {
            this.flat = this.computeFlat();
            this.flatComputed = true;
        }
        return this.flat;
    }

    final Range<Integer> range() {
        if (!this.rangeComputed) {
            this.range = this.computeRange();
            this.rangeComputed = true;
        }
        return this.range;
    }

    abstract float computeWidth();

    abstract String computeFlat();

    abstract Range<Integer> computeRange();

    public abstract State computeBreaks(CommentsHelper var1, int var2, State var3);

    public abstract void write(Output var1);

    static final class Tok
    extends Doc
    implements Op {
        private final Input.Tok tok;
        String text;

        private Tok(Input.Tok tok) {
            this.tok = tok;
        }

        static Tok make(Input.Tok tok) {
            return new Tok(tok);
        }

        @Override
        public void add(DocBuilder builder) {
            builder.add(this);
        }

        @Override
        float computeWidth() {
            if (this.tok.isComment()) {
                int idx = this.tok.getOriginalText().indexOf(10);
                if (idx > 0) {
                    return idx;
                }
                return this.tok.length();
            }
            return this.tok.getOriginalText().contains("\n") ? Float.POSITIVE_INFINITY : (float)this.tok.length();
        }

        @Override
        String computeFlat() {
            return this.tok.getOriginalText();
        }

        @Override
        Range<Integer> computeRange() {
            return Range.singleton((Comparable)Integer.valueOf(this.tok.getIndex())).canonical(INTEGERS);
        }

        @Override
        public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            int column = state.column;
            int lines = 0;
            this.text = commentsHelper.rewrite(this.tok, maxWidth, column);
            for (char c : this.text.toCharArray()) {
                if (c == '\n') {
                    column = 0;
                    ++lines;
                    continue;
                }
                ++column;
            }
            return state.withColumn(column);
        }

        @Override
        public void write(Output output) {
            output.append(this.text, this.range());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tok", (Object)this.tok).toString();
        }
    }

    public static final class Break
    extends Doc
    implements Op {
        private final FillMode fillMode;
        private final String flat;
        private final Indent plusIndent;
        private final Optional<Output.BreakTag> optTag;
        boolean broken;
        int newIndent;

        private Break(FillMode fillMode, String flat, Indent plusIndent, Optional<Output.BreakTag> optTag) {
            this.fillMode = fillMode;
            this.flat = flat;
            this.plusIndent = plusIndent;
            this.optTag = optTag;
        }

        public static Break make(FillMode fillMode, String flat, Indent plusIndent) {
            return new Break(fillMode, flat, plusIndent, (Optional<Output.BreakTag>)Optional.absent());
        }

        public static Break make(FillMode fillMode, String flat, Indent plusIndent, Optional<Output.BreakTag> optTag) {
            return new Break(fillMode, flat, plusIndent, optTag);
        }

        public static Break makeForced() {
            return Break.make(FillMode.FORCED, "", Indent.Const.ZERO);
        }

        int getPlusIndent() {
            return this.plusIndent.eval();
        }

        boolean isForced() {
            return this.fillMode == FillMode.FORCED;
        }

        @Override
        public void add(DocBuilder builder) {
            builder.breakDoc(this);
        }

        @Override
        float computeWidth() {
            return this.isForced() ? Float.POSITIVE_INFINITY : (float)this.flat.length();
        }

        @Override
        String computeFlat() {
            return this.flat;
        }

        @Override
        Range<Integer> computeRange() {
            return EMPTY_RANGE;
        }

        public State computeBreaks(State state, int lastIndent, boolean broken) {
            if (this.optTag.isPresent()) {
                ((Output.BreakTag)this.optTag.get()).recordBroken(broken);
            }
            if (broken) {
                this.broken = true;
                this.newIndent = Math.max(lastIndent + this.plusIndent.eval(), 0);
                return state.withColumn(this.newIndent);
            }
            this.broken = false;
            this.newIndent = -1;
            return state.withColumn(state.column + this.flat.length());
        }

        @Override
        public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            throw new UnsupportedOperationException("Did you mean computeBreaks(State, int, boolean)?");
        }

        @Override
        public void write(Output output) {
            if (this.broken) {
                output.append("\n", (Range<Integer>)EMPTY_RANGE);
                output.indent(this.newIndent);
            } else {
                output.append(this.flat, this.range());
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fillMode", (Object)this.fillMode).add("flat", (Object)this.flat).add("plusIndent", (Object)this.plusIndent).add("optTag", this.optTag).toString();
        }
    }

    static final class Space
    extends Doc
    implements Op {
        private static final Space SPACE = new Space();

        private Space() {
        }

        static Space make() {
            return SPACE;
        }

        @Override
        public void add(DocBuilder builder) {
            builder.add(this);
        }

        @Override
        float computeWidth() {
            return 1.0f;
        }

        @Override
        String computeFlat() {
            return " ";
        }

        @Override
        Range<Integer> computeRange() {
            return EMPTY_RANGE;
        }

        @Override
        public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            return state.withColumn(state.column + 1);
        }

        @Override
        public void write(Output output) {
            output.append(" ", this.range());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static final class Token
    extends Doc
    implements Op {
        private final Input.Token token;
        private final RealOrImaginary realOrImaginary;
        private final Indent plusIndentCommentsBefore;
        private final Optional<Indent> breakAndIndentTrailingComment;

        private Token(Input.Token token, RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
            this.token = token;
            this.realOrImaginary = realOrImaginary;
            this.plusIndentCommentsBefore = plusIndentCommentsBefore;
            this.breakAndIndentTrailingComment = breakAndIndentTrailingComment;
        }

        Indent getPlusIndentCommentsBefore() {
            return this.plusIndentCommentsBefore;
        }

        Optional<Indent> breakAndIndentTrailingComment() {
            return this.breakAndIndentTrailingComment;
        }

        static Op make(Input.Token token, RealOrImaginary realOrImaginary, Indent plusIndentCommentsBefore, Optional<Indent> breakAndIndentTrailingComment) {
            return new Token(token, realOrImaginary, plusIndentCommentsBefore, breakAndIndentTrailingComment);
        }

        Input.Token getToken() {
            return this.token;
        }

        RealOrImaginary realOrImaginary() {
            return this.realOrImaginary;
        }

        @Override
        public void add(DocBuilder builder) {
            builder.add(this);
        }

        @Override
        float computeWidth() {
            return this.token.getTok().length();
        }

        @Override
        String computeFlat() {
            return this.token.getTok().getOriginalText();
        }

        @Override
        Range<Integer> computeRange() {
            return Range.singleton((Comparable)Integer.valueOf(this.token.getTok().getIndex())).canonical(INTEGERS);
        }

        @Override
        public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            String text = this.token.getTok().getOriginalText();
            return state.withColumn(state.column + text.length());
        }

        @Override
        public void write(Output output) {
            String text = this.token.getTok().getOriginalText();
            output.append(text, this.range());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).add("realOrImaginary", (Object)this.realOrImaginary).add("plusIndentCommentsBefore", (Object)this.plusIndentCommentsBefore).toString();
        }

        public static enum RealOrImaginary {
            REAL,
            IMAGINARY;


            boolean isReal() {
                return this == REAL;
            }
        }
    }

    static final class Level
    extends Doc {
        private final Indent plusIndent;
        private final List<Doc> docs = new ArrayList<Doc>();
        boolean oneLine = false;
        List<List<Doc>> splits = new ArrayList<List<Doc>>();
        List<Break> breaks = new ArrayList<Break>();

        private Level(Indent plusIndent) {
            this.plusIndent = plusIndent;
        }

        static Level make(Indent plusIndent) {
            return new Level(plusIndent);
        }

        void add(Doc doc) {
            this.docs.add(doc);
        }

        @Override
        float computeWidth() {
            float thisWidth = 0.0f;
            for (Doc doc : this.docs) {
                thisWidth += doc.getWidth();
            }
            return thisWidth;
        }

        @Override
        String computeFlat() {
            StringBuilder builder = new StringBuilder();
            for (Doc doc : this.docs) {
                builder.append(doc.getFlat());
            }
            return builder.toString();
        }

        @Override
        Range<Integer> computeRange() {
            Range<Integer> docRange = EMPTY_RANGE;
            for (Doc doc : this.docs) {
                docRange = Level.union(docRange, doc.range());
            }
            return docRange;
        }

        @Override
        public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state) {
            float thisWidth = this.getWidth();
            if ((float)state.column + thisWidth <= (float)maxWidth) {
                this.oneLine = true;
                return state.withColumn(state.column + (int)thisWidth);
            }
            State broken = this.computeBroken(commentsHelper, maxWidth, new State(state.indent + this.plusIndent.eval(), state.column));
            return state.withColumn(broken.column);
        }

        private static void splitByBreaks(List<Doc> docs, List<List<Doc>> splits, List<Break> breaks) {
            splits.clear();
            breaks.clear();
            splits.add(new ArrayList());
            for (Doc doc : docs) {
                if (doc instanceof Break) {
                    breaks.add((Break)doc);
                    splits.add(new ArrayList());
                    continue;
                }
                splits.get(splits.size() - 1).add(doc);
            }
        }

        private State computeBroken(CommentsHelper commentsHelper, int maxWidth, State state) {
            Level.splitByBreaks(this.docs, this.splits, this.breaks);
            state = Level.computeBreakAndSplit(commentsHelper, maxWidth, state, (Optional<Break>)Optional.absent(), this.splits.get(0));
            for (int i = 0; i < this.breaks.size(); ++i) {
                state = Level.computeBreakAndSplit(commentsHelper, maxWidth, state, (Optional<Break>)Optional.of((Object)this.breaks.get(i)), this.splits.get(i + 1));
            }
            return state;
        }

        private static State computeBreakAndSplit(CommentsHelper commentsHelper, int maxWidth, State state, Optional<Break> optBreakDoc, List<Doc> split) {
            boolean shouldBreak;
            float breakWidth = optBreakDoc.isPresent() ? ((Break)optBreakDoc.get()).getWidth() : 0.0f;
            float splitWidth = Level.getWidth(split);
            boolean bl = shouldBreak = optBreakDoc.isPresent() && ((Break)optBreakDoc.get()).fillMode == FillMode.UNIFIED || state.mustBreak || (float)state.column + breakWidth + splitWidth > (float)maxWidth;
            if (optBreakDoc.isPresent()) {
                state = ((Break)optBreakDoc.get()).computeBreaks(state, state.lastIndent, shouldBreak);
            }
            boolean enoughRoom = (float)state.column + splitWidth <= (float)maxWidth;
            state = Level.computeSplit(commentsHelper, maxWidth, split, state.withMustBreak(false));
            if (!enoughRoom) {
                state = state.withMustBreak(true);
            }
            return state;
        }

        private static State computeSplit(CommentsHelper commentsHelper, int maxWidth, List<Doc> docs, State state) {
            for (Doc doc : docs) {
                state = doc.computeBreaks(commentsHelper, maxWidth, state);
            }
            return state;
        }

        @Override
        public void write(Output output) {
            if (this.oneLine) {
                output.append(this.getFlat(), this.range());
            } else {
                this.writeFilled(output);
            }
        }

        private void writeFilled(Output output) {
            for (Doc doc : this.splits.get(0)) {
                doc.write(output);
            }
            for (int i = 0; i < this.breaks.size(); ++i) {
                this.breaks.get(i).write(output);
                for (Doc doc : this.splits.get(i + 1)) {
                    doc.write(output);
                }
            }
        }

        static float getWidth(List<Doc> docs) {
            float width = 0.0f;
            for (Doc doc : docs) {
                width += doc.getWidth();
            }
            return width;
        }

        private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
            return x.isEmpty() ? y : (y.isEmpty() ? x : x.span(y).canonical(INTEGERS));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("plusIndent", (Object)this.plusIndent).add("docs", this.docs).toString();
        }
    }

    public static final class State {
        final int lastIndent;
        final int indent;
        final int column;
        final boolean mustBreak;

        State(int lastIndent, int indent, int column, boolean mustBreak) {
            this.lastIndent = lastIndent;
            this.indent = indent;
            this.column = column;
            this.mustBreak = mustBreak;
        }

        public State(int indent0, int column0) {
            this(indent0, indent0, column0, false);
        }

        State withColumn(int column) {
            return new State(this.lastIndent, this.indent, column, this.mustBreak);
        }

        State withMustBreak(boolean mustBreak) {
            return new State(this.lastIndent, this.indent, this.column, mustBreak);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lastIndent", this.lastIndent).add("indent", this.indent).add("column", this.column).add("mustBreak", this.mustBreak).toString();
        }
    }

    public static enum FillMode {
        UNIFIED,
        INDEPENDENT,
        FORCED;

    }
}

