"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
var axis_utils_1 = require("../../utils/axis_utils");
var compute_series_domains_1 = require("./compute_series_domains");
var count_bars_in_cluster_1 = require("./count_bars_in_cluster");
var get_axis_styles_1 = require("./get_axis_styles");
var get_bar_paddings_1 = require("./get_bar_paddings");
var get_specs_1 = require("./get_specs");
var is_histogram_mode_enabled_1 = require("./is_histogram_mode_enabled");
exports.computeAxisTicksDimensionsSelector = re_reselect_1.default([
    get_bar_paddings_1.getBarPaddingsSelector,
    is_histogram_mode_enabled_1.isHistogramModeEnabledSelector,
    get_specs_1.getAxisSpecsSelector,
    get_chart_theme_1.getChartThemeSelector,
    get_settings_specs_1.getSettingsSpecSelector,
    compute_series_domains_1.computeSeriesDomainsSelector,
    count_bars_in_cluster_1.countBarsInClusterSelector,
    get_specs_1.getSeriesSpecsSelector,
    get_axis_styles_1.getAxesStylesSelector,
], function (barsPadding, isHistogramMode, axesSpecs, chartTheme, settingsSpec, seriesDomainsAndData, totalBarsInCluster, seriesSpecs, axesStyles) {
    var _a, _b;
    var xDomain = seriesDomainsAndData.xDomain, yDomain = seriesDomainsAndData.yDomain;
    var fallBackTickFormatter = (_b = (_a = seriesSpecs.find(function (_a) {
        var tickFormat = _a.tickFormat;
        return tickFormat;
    })) === null || _a === void 0 ? void 0 : _a.tickFormat, (_b !== null && _b !== void 0 ? _b : axis_utils_1.defaultTickFormatter));
    var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var axesTicksDimensions = new Map();
    axesSpecs.forEach(function (axisSpec) {
        var _a;
        var id = axisSpec.id;
        var axisStyle = (_a = axesStyles.get(id), (_a !== null && _a !== void 0 ? _a : chartTheme.axes));
        var dimensions = axis_utils_1.computeAxisTicksDimensions(axisSpec, xDomain, yDomain, totalBarsInCluster, bboxCalculator, settingsSpec.rotation, axisStyle, fallBackTickFormatter, barsPadding, isHistogramMode);
        if (dimensions &&
            (!settingsSpec.hideDuplicateAxes || !axis_utils_1.isDuplicateAxis(axisSpec, dimensions, axesTicksDimensions, axesSpecs))) {
            axesTicksDimensions.set(id, dimensions);
        }
    });
    bboxCalculator.destroy();
    return axesTicksDimensions;
})(get_chart_id_1.getChartIdSelector);
//# sourceMappingURL=compute_axis_ticks_dimensions.js.map