/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScrollViewport
extends JPanel {
    private static final int NO_SCROLL = 0;
    public static final int UP_DIRECTION = 1;
    public static final int DOWN_DIRECTION = 2;
    public static final int LEFT_DIRECTION = 4;
    public static final int RIGHT_DIRECTION = 8;
    public static final int VERTICAL_DIRECTION = 3;
    public static final int HORIZONTAL_DIRECTION = 12;
    public static final int ALL_DIRECTION = 15;
    private final JViewport vp = new JViewport();
    private JComponent component;
    private final List<JButton> buttons = new ArrayList<JButton>();
    private final Timer timer = new Timer(100, evt -> this.scroll());
    private int scrollDirection = 0;
    private final int allowedScrollDirections;
    private final transient ComponentAdapter refreshButtonsOnResize = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            ScrollViewport.this.showOrHideButtons();
        }
    };

    public ScrollViewport(JComponent c, int direction) {
        this(direction);
        this.add(c);
    }

    public ScrollViewport(int direction) {
        super(new BorderLayout());
        this.allowedScrollDirections = direction;
        if ((direction & 1) != 0) {
            this.addScrollButton(1, "svpUp", "North");
        }
        if ((direction & 2) != 0) {
            this.addScrollButton(2, "svpDown", "South");
        }
        if ((direction & 4) != 0) {
            this.addScrollButton(4, "svpLeft", "West");
        }
        if ((direction & 8) != 0) {
            this.addScrollButton(8, "svpRight", "East");
        }
        this.add((Component)this.vp, "Center");
        this.addComponentListener(this.refreshButtonsOnResize);
        this.showOrHideButtons();
        if ((direction & 3) != 0) {
            this.addMouseWheelListener(e -> this.scroll(0, e.getUnitsToScroll() * 5));
        } else if ((direction & 0xC) != 0) {
            this.addMouseWheelListener(e -> this.scroll(e.getUnitsToScroll() * 5, 0));
        }
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(400);
    }

    private void addScrollButton(int direction, String icon, String borderLayoutPosition) {
        JButton button = new JButton();
        button.addMouseListener(new ScrollViewPortMouseListener(direction));
        button.setPreferredSize(new Dimension(10, 10));
        button.setIcon(ImageProvider.get(icon));
        this.add((Component)button, borderLayoutPosition);
        this.buttons.add(button);
    }

    public synchronized void scroll() {
        int direction = this.scrollDirection;
        if (this.component == null || direction == 0) {
            return;
        }
        Rectangle viewRect = this.vp.getViewRect();
        int deltaX = 0;
        int deltaY = 0;
        if (direction < 4) {
            deltaY = viewRect.height * 2 / 7;
        } else {
            deltaX = viewRect.width * 2 / 7;
        }
        switch (direction) {
            case 1: {
                deltaY *= -1;
                break;
            }
            case 4: {
                deltaX *= -1;
                break;
            }
        }
        this.scroll(deltaX, deltaY);
    }

    public synchronized void scroll(int deltaX, int deltaY) {
        if (this.component == null) {
            return;
        }
        Dimension compSize = this.component.getSize();
        Rectangle viewRect = this.vp.getViewRect();
        int newX = viewRect.x + deltaX;
        int newY = viewRect.y + deltaY;
        if (newY < 0) {
            newY = 0;
        }
        if (newY > compSize.height - viewRect.height) {
            newY = compSize.height - viewRect.height;
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newX > compSize.width - viewRect.width) {
            newX = compSize.width - viewRect.width;
        }
        this.vp.setViewPosition(new Point(newX, newY));
    }

    public void showOrHideButtons() {
        boolean needButtons = false;
        if ((this.allowedScrollDirections & 3) != 0) {
            needButtons |= this.getViewSize().height > this.getViewRect().height;
        }
        if ((this.allowedScrollDirections & 0xC) != 0) {
            needButtons |= this.getViewSize().width > this.getViewRect().width;
        }
        for (JButton b : this.buttons) {
            b.setVisible(needButtons);
        }
    }

    public Rectangle getViewRect() {
        return this.vp.getViewRect();
    }

    public Dimension getViewSize() {
        return this.vp.getViewSize();
    }

    public Point getViewPosition() {
        return this.vp.getViewPosition();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.component == null) {
            return this.vp.getPreferredSize();
        }
        return this.component.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.component == null) {
            return this.vp.getMinimumSize();
        }
        Dimension minSize = this.component.getMinimumSize();
        if ((this.allowedScrollDirections & 0xC) != 0) {
            minSize = new Dimension(20, minSize.height);
        }
        if ((this.allowedScrollDirections & 3) != 0) {
            minSize = new Dimension(minSize.width, 20);
        }
        return minSize;
    }

    public void add(JComponent c) {
        this.vp.removeAll();
        if (this.component != null) {
            this.component.removeComponentListener(this.refreshButtonsOnResize);
        }
        this.component = c;
        c.addComponentListener(this.refreshButtonsOnResize);
        this.vp.add(c);
    }

    private class ScrollViewPortMouseListener
    extends MouseAdapter {
        private final int direction;

        ScrollViewPortMouseListener(int direction) {
            this.direction = direction;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseReleased(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ScrollViewport.this.scrollDirection = this.direction;
            ScrollViewport.this.scroll();
            ScrollViewport.this.timer.restart();
        }
    }
}

