/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2.json;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri.json.JSONSerializer;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceModificationIQ;
import org.jitsi.xmpp.extensions.colibri2.Capability;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jivesoftware.smackx.muc.MUCRole;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u00142\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\u00020\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\u0016H\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\u00020\u00142\f\u00100\u001a\b\u0012\u0004\u0012\u00020.0\u0016H\u0002J\u0010\u00101\u001a\u00020\r2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\r2\u0006\u00108\u001a\u000209H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jitsi/xmpp/extensions/colibri2/json/Colibri2JSONSerializer;", "", "()V", "CAPABILITIES_LIST", "", "ENDPOINTS", "MEDIA_LIST", "PAYLOAD_TYPES", "RELAYS", "RTP_HEADER_EXTS", "SOURCES", "SOURCE_GROUPS", "serializeAbstractConferenceEntity", "Lorg/json/simple/JSONObject;", "entity", "Lorg/jitsi/xmpp/extensions/colibri2/AbstractConferenceEntity;", "serializeAbstractConferenceModificationIQ", "iq", "Lorg/jitsi/xmpp/extensions/colibri2/AbstractConferenceModificationIQ;", "serializeCapabilities", "Lorg/json/simple/JSONArray;", "capabilities", "", "Lorg/jitsi/xmpp/extensions/colibri2/Capability;", "serializeConferenceModified", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifiedIQ;", "serializeConferenceModify", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "serializeEndpoint", "endpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint;", "serializeEndpoints", "endpoints", "serializeForceMute", "forceMute", "Lorg/jitsi/xmpp/extensions/colibri2/ForceMute;", "serializeMedia", "media", "Lorg/jitsi/xmpp/extensions/colibri2/Media;", "serializeMediaSource", "source", "Lorg/jitsi/xmpp/extensions/colibri2/MediaSource;", "serializeMedias", "medias", "serializeRelay", "relay", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Relay;", "serializeRelays", "relays", "serializeSctp", "sctp", "Lorg/jitsi/xmpp/extensions/colibri2/Sctp;", "serializeSources", "sources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "serializeTransport", "transport", "Lorg/jitsi/xmpp/extensions/colibri2/Transport;", "jitsi-xmpp-extensions"})
public final class Colibri2JSONSerializer {
    @NotNull
    public static final Colibri2JSONSerializer INSTANCE = new Colibri2JSONSerializer();
    @NotNull
    public static final String ENDPOINTS = "endpoints";
    @NotNull
    public static final String RELAYS = "relays";
    @NotNull
    public static final String MEDIA_LIST = "medias";
    @NotNull
    public static final String CAPABILITIES_LIST = "capabilities";
    @NotNull
    public static final String PAYLOAD_TYPES = "payload-types";
    @NotNull
    public static final String RTP_HEADER_EXTS = "rtp-hdrexts";
    @NotNull
    public static final String SOURCE_GROUPS = "ssrc-groups";
    @NotNull
    public static final String SOURCES = "sources";

    private Colibri2JSONSerializer() {
    }

    private final JSONObject serializeMedia(Media media) {
        JSONObject jSONObject;
        JSONObject $this$serializeMedia_u24lambda_u2d0 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeMedia_u24lambda_u2d0.put("type", media.getType().toString());
        List<PayloadTypePacketExtension> list = media.getPayloadTypes();
        Intrinsics.checkNotNullExpressionValue(list, "media.payloadTypes");
        if (!((Collection)list).isEmpty()) {
            $this$serializeMedia_u24lambda_u2d0.put(PAYLOAD_TYPES, JSONSerializer.serializePayloadTypes((Collection<PayloadTypePacketExtension>)media.getPayloadTypes()));
        }
        List<RTPHdrExtPacketExtension> list2 = media.getRtpHdrExts();
        Intrinsics.checkNotNullExpressionValue(list2, "media.rtpHdrExts");
        if (!((Collection)list2).isEmpty()) {
            $this$serializeMedia_u24lambda_u2d0.put(RTP_HEADER_EXTS, JSONSerializer.serializeRtpHdrExts((Collection<RTPHdrExtPacketExtension>)media.getRtpHdrExts()));
        }
        return jSONObject;
    }

    private final JSONObject serializeSctp(Sctp sctp) {
        JSONObject jSONObject;
        block1: {
            Object it;
            JSONObject $this$serializeSctp_u24lambda_u2d3 = jSONObject = new JSONObject();
            boolean bl = false;
            Integer n = sctp.getPort();
            if (n != null) {
                it = n;
                boolean bl2 = false;
                $this$serializeSctp_u24lambda_u2d3.put("port", it);
            }
            Sctp.Role role = sctp.getRole();
            if (role == null) break block1;
            it = role;
            boolean bl3 = false;
            $this$serializeSctp_u24lambda_u2d3.put("role", it);
        }
        return jSONObject;
    }

    private final JSONObject serializeTransport(Transport transport) {
        JSONObject jSONObject;
        block3: {
            AbstractPacketExtension it;
            JSONObject $this$serializeTransport_u24lambda_u2d6 = jSONObject = new JSONObject();
            boolean bl = false;
            if (transport.getIceControlling()) {
                $this$serializeTransport_u24lambda_u2d6.put("ice-controlling", transport.getIceControlling());
            }
            if (transport.getUseUniquePort()) {
                $this$serializeTransport_u24lambda_u2d6.put("use-unique-port", transport.getUseUniquePort());
            }
            IceUdpTransportPacketExtension iceUdpTransportPacketExtension = transport.getIceUdpTransport();
            if (iceUdpTransportPacketExtension != null) {
                it = iceUdpTransportPacketExtension;
                boolean bl2 = false;
                $this$serializeTransport_u24lambda_u2d6.put("transport", JSONSerializer.serializeTransport(it));
            }
            Sctp sctp = transport.getSctp();
            if (sctp == null) break block3;
            it = sctp;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            $this$serializeTransport_u24lambda_u2d6.put("sctp", INSTANCE.serializeSctp((Sctp)it));
        }
        return jSONObject;
    }

    private final JSONObject serializeMediaSource(MediaSource source) {
        JSONObject jSONObject;
        JSONObject $this$serializeMediaSource_u24lambda_u2d7 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeMediaSource_u24lambda_u2d7.put("type", source.getType().toString());
        $this$serializeMediaSource_u24lambda_u2d7.put("id", source.getId());
        List<SourcePacketExtension> list = source.getSources();
        Intrinsics.checkNotNullExpressionValue(list, "source.sources");
        if (!((Collection)list).isEmpty()) {
            $this$serializeMediaSource_u24lambda_u2d7.put(SOURCES, JSONSerializer.serializeSources((Collection<SourcePacketExtension>)source.getSources()));
        }
        List<SourceGroupPacketExtension> list2 = source.getSsrcGroups();
        Intrinsics.checkNotNullExpressionValue(list2, "source.ssrcGroups");
        if (!((Collection)list2).isEmpty()) {
            $this$serializeMediaSource_u24lambda_u2d7.put(SOURCE_GROUPS, JSONSerializer.serializeSourceGroups((Collection<SourceGroupPacketExtension>)source.getSsrcGroups()));
        }
        return jSONObject;
    }

    private final JSONArray serializeMedias(Collection<? extends Media> medias) {
        JSONArray jSONArray;
        JSONArray $this$serializeMedias_u24lambda_u2d9 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = medias;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Media it = (Media)element$iv;
            boolean bl2 = false;
            $this$serializeMedias_u24lambda_u2d9.add(INSTANCE.serializeMedia(it));
        }
        return jSONArray;
    }

    private final JSONArray serializeSources(Sources sources) {
        JSONArray jSONArray;
        JSONArray $this$serializeSources_u24lambda_u2d11 = jSONArray = new JSONArray();
        boolean bl = false;
        List<MediaSource> list = sources.getMediaSources();
        Intrinsics.checkNotNullExpressionValue(list, "sources.mediaSources");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediaSource it = (MediaSource)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            $this$serializeSources_u24lambda_u2d11.add(INSTANCE.serializeMediaSource(it));
        }
        return jSONArray;
    }

    private final JSONObject serializeAbstractConferenceEntity(AbstractConferenceEntity entity) {
        JSONObject jSONObject;
        block4: {
            AbstractPacketExtension it;
            JSONObject $this$serializeAbstractConferenceEntity_u24lambda_u2d14 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$serializeAbstractConferenceEntity_u24lambda_u2d14.put("id", entity.getId());
            if (entity.getCreate()) {
                $this$serializeAbstractConferenceEntity_u24lambda_u2d14.put("create", entity.getCreate());
            }
            if (entity.getExpire()) {
                $this$serializeAbstractConferenceEntity_u24lambda_u2d14.put("expire", entity.getExpire());
            }
            List<Media> list = entity.getMedia();
            Intrinsics.checkNotNullExpressionValue(list, "entity.media");
            if (!((Collection)list).isEmpty()) {
                List<Media> list2 = entity.getMedia();
                Intrinsics.checkNotNullExpressionValue(list2, "entity.media");
                $this$serializeAbstractConferenceEntity_u24lambda_u2d14.put(MEDIA_LIST, INSTANCE.serializeMedias((Collection<? extends Media>)list2));
            }
            Transport transport = entity.getTransport();
            if (transport != null) {
                it = transport;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                $this$serializeAbstractConferenceEntity_u24lambda_u2d14.put("transport", INSTANCE.serializeTransport((Transport)it));
            }
            Sources sources = entity.getSources();
            if (sources == null) break block4;
            it = sources;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            $this$serializeAbstractConferenceEntity_u24lambda_u2d14.put(SOURCES, INSTANCE.serializeSources((Sources)it));
        }
        return jSONObject;
    }

    private final JSONObject serializeForceMute(ForceMute forceMute) {
        JSONObject jSONObject;
        JSONObject $this$serializeForceMute_u24lambda_u2d15 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$serializeForceMute_u24lambda_u2d15.put("audio", forceMute.getAudio());
        $this$serializeForceMute_u24lambda_u2d15.put("video", forceMute.getVideo());
        return jSONObject;
    }

    private final JSONArray serializeCapabilities(Collection<? extends Capability> capabilities) {
        JSONArray jSONArray;
        JSONArray $this$serializeCapabilities_u24lambda_u2d17 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = capabilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Capability it = (Capability)element$iv;
            boolean bl2 = false;
            $this$serializeCapabilities_u24lambda_u2d17.add(it.getName());
        }
        return jSONArray;
    }

    private final JSONObject serializeEndpoint(Colibri2Endpoint endpoint) {
        Object object;
        JSONObject jSONObject;
        JSONObject $this$serializeEndpoint_u24lambda_u2d21 = jSONObject = this.serializeAbstractConferenceEntity(endpoint);
        boolean bl = false;
        String string = endpoint.getStatsId();
        if (string != null) {
            String $this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d18 = object = string;
            boolean bl2 = false;
            $this$serializeEndpoint_u24lambda_u2d21.put("stats-id", $this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d18);
        }
        MUCRole mUCRole = endpoint.getMucRole();
        if (mUCRole != null) {
            object = mUCRole;
            String $this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d19 = object;
            boolean bl3 = false;
            $this$serializeEndpoint_u24lambda_u2d21.put("muc-role", ((Enum)((Object)$this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d19)).toString());
        }
        ForceMute forceMute = endpoint.getForceMute();
        if (forceMute != null) {
            Object $this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d20 = object = forceMute;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue($this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d20, "this");
            $this$serializeEndpoint_u24lambda_u2d21.put("force-mute", INSTANCE.serializeForceMute((ForceMute)$this$serializeEndpoint_u24lambda_u2d21_u24lambda_u2d20));
        }
        List<Capability> list = endpoint.getCapabilities();
        Intrinsics.checkNotNullExpressionValue(list, "endpoint.capabilities");
        if (!((Collection)list).isEmpty()) {
            List<Capability> list2 = endpoint.getCapabilities();
            Intrinsics.checkNotNullExpressionValue(list2, "endpoint.capabilities");
            $this$serializeEndpoint_u24lambda_u2d21.put(CAPABILITIES_LIST, INSTANCE.serializeCapabilities((Collection<? extends Capability>)list2));
        }
        return jSONObject;
    }

    private final JSONObject serializeRelay(Colibri2Relay relay) {
        JSONObject jSONObject;
        block1: {
            JSONObject $this$serializeRelay_u24lambda_u2d24 = jSONObject = this.serializeAbstractConferenceEntity(relay);
            boolean bl = false;
            String string = relay.getMeshId();
            if (string != null) {
                String string2;
                String $this$serializeRelay_u24lambda_u2d24_u24lambda_u2d22 = string2 = string;
                boolean bl2 = false;
                $this$serializeRelay_u24lambda_u2d24.put("mesh-id", $this$serializeRelay_u24lambda_u2d24_u24lambda_u2d22);
            }
            Endpoints endpoints = relay.getEndpoints();
            if (endpoints == null) break block1;
            Endpoints it = endpoints;
            boolean bl3 = false;
            List<Colibri2Endpoint> list = it.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "it.endpoints");
            $this$serializeRelay_u24lambda_u2d24.put(ENDPOINTS, INSTANCE.serializeEndpoints((Collection<? extends Colibri2Endpoint>)list));
        }
        return jSONObject;
    }

    private final JSONArray serializeEndpoints(Collection<? extends Colibri2Endpoint> endpoints) {
        JSONArray jSONArray;
        JSONArray $this$serializeEndpoints_u24lambda_u2d26 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = endpoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Colibri2Endpoint it = (Colibri2Endpoint)element$iv;
            boolean bl2 = false;
            $this$serializeEndpoints_u24lambda_u2d26.add(INSTANCE.serializeEndpoint(it));
        }
        return jSONArray;
    }

    private final JSONArray serializeRelays(Collection<? extends Colibri2Relay> relays) {
        JSONArray jSONArray;
        JSONArray $this$serializeRelays_u24lambda_u2d28 = jSONArray = new JSONArray();
        boolean bl = false;
        Iterable $this$forEach$iv = relays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Colibri2Relay it = (Colibri2Relay)element$iv;
            boolean bl2 = false;
            $this$serializeRelays_u24lambda_u2d28.add(INSTANCE.serializeRelay(it));
        }
        return jSONArray;
    }

    private final JSONObject serializeAbstractConferenceModificationIQ(AbstractConferenceModificationIQ<?> iq) {
        JSONObject jSONObject;
        JSONObject $this$serializeAbstractConferenceModificationIQ_u24lambda_u2d29 = jSONObject = new JSONObject();
        boolean bl = false;
        List<Colibri2Endpoint> list = iq.getEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, "iq.endpoints");
        if (!((Collection)list).isEmpty()) {
            List<Colibri2Endpoint> list2 = iq.getEndpoints();
            Intrinsics.checkNotNullExpressionValue(list2, "iq.endpoints");
            $this$serializeAbstractConferenceModificationIQ_u24lambda_u2d29.put(ENDPOINTS, INSTANCE.serializeEndpoints((Collection<? extends Colibri2Endpoint>)list2));
        }
        List<Colibri2Relay> list3 = iq.getRelays();
        Intrinsics.checkNotNullExpressionValue(list3, "iq.relays");
        if (!((Collection)list3).isEmpty()) {
            List<Colibri2Relay> list4 = iq.getRelays();
            Intrinsics.checkNotNullExpressionValue(list4, "iq.relays");
            $this$serializeAbstractConferenceModificationIQ_u24lambda_u2d29.put(RELAYS, INSTANCE.serializeRelays((Collection<? extends Colibri2Relay>)list4));
        }
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject serializeConferenceModify(@NotNull ConferenceModifyIQ iq) {
        JSONObject jSONObject;
        block4: {
            Intrinsics.checkNotNullParameter(iq, "iq");
            JSONObject $this$serializeConferenceModify_u24lambda_u2d31 = jSONObject = INSTANCE.serializeAbstractConferenceModificationIQ(iq);
            boolean bl = false;
            if (iq.getCreate()) {
                $this$serializeConferenceModify_u24lambda_u2d31.put("create", iq.getCreate());
            }
            if (iq.getExpire()) {
                $this$serializeConferenceModify_u24lambda_u2d31.put("expire", iq.getExpire());
            }
            if (!iq.isCallstatsEnabled()) {
                $this$serializeConferenceModify_u24lambda_u2d31.put("callstats-enabled", iq.isCallstatsEnabled());
            }
            if (!iq.isRtcstatsEnabled()) {
                $this$serializeConferenceModify_u24lambda_u2d31.put("rtcstats-enabled", iq.isRtcstatsEnabled());
            }
            $this$serializeConferenceModify_u24lambda_u2d31.put("meeting-id", iq.getMeetingId());
            String string = iq.getConferenceName();
            if (string == null) break block4;
            String it = string;
            boolean bl2 = false;
            $this$serializeConferenceModify_u24lambda_u2d31.put("name", it);
        }
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final JSONObject serializeConferenceModified(@NotNull ConferenceModifiedIQ iq) {
        JSONObject jSONObject;
        block0: {
            Intrinsics.checkNotNullParameter(iq, "iq");
            JSONObject $this$serializeConferenceModified_u24lambda_u2d33 = jSONObject = INSTANCE.serializeAbstractConferenceModificationIQ(iq);
            boolean bl = false;
            Sources sources = iq.getSources();
            if (sources == null) break block0;
            Sources it = sources;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            $this$serializeConferenceModified_u24lambda_u2d33.put(SOURCES, INSTANCE.serializeSources(it));
        }
        return jSONObject;
    }
}

