/*
 * Decompiled with CFR 0.152.
 */
package generic.jar;

import generic.jar.Resource;
import generic.jar.ResourceFile;
import generic.jar.ResourceFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

public class FileResource
implements Resource {
    private File file;

    public FileResource(File file) {
        this.file = file;
    }

    @Override
    public Resource getResource(String childPath) {
        return new FileResource(new File(this.file, childPath));
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public ResourceFile[] listFiles() {
        File[] listFiles = this.file.listFiles();
        if (listFiles == null) {
            return null;
        }
        ResourceFile[] resourceFiles = new ResourceFile[listFiles.length];
        for (int i = 0; i < listFiles.length; ++i) {
            resourceFiles[i] = new ResourceFile(new FileResource(listFiles[i]));
        }
        return resourceFiles;
    }

    @Override
    public ResourceFile[] listFiles(ResourceFileFilter filter) {
        File[] listFiles = this.file.listFiles();
        if (listFiles == null) {
            return null;
        }
        ArrayList<ResourceFile> fileList = new ArrayList<ResourceFile>();
        for (File listFile : listFiles) {
            ResourceFile resourceFile = new ResourceFile(new FileResource(listFile));
            if (!filter.accept(resourceFile)) continue;
            fileList.add(resourceFile);
        }
        return fileList.toArray(new ResourceFile[fileList.size()]);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.file.toURI().toURL();
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.file);
    }

    @Override
    public FileResource getParent() {
        File parent = this.file.getParentFile();
        if (parent == null && (parent = this.file.getAbsoluteFile().getParentFile()) == null) {
            return null;
        }
        return new FileResource(parent);
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.file.equals(((FileResource)obj).file);
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getResourceAsFile(ResourceFile resourceFile) {
        return this.file;
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public Resource getCanonicalResource() {
        try {
            return new FileResource(this.file.getCanonicalFile());
        }
        catch (IOException e) {
            return this;
        }
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public boolean mkdir() {
        return this.file.mkdir();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public File getFileSystemRoot() {
        File testFile = this.file;
        File parentFile = testFile.getParentFile();
        while (parentFile != null) {
            testFile = parentFile;
            parentFile = testFile.getParentFile();
        }
        return testFile;
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }
}

