/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.VarnodeData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DynamicVariableStorage;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.listing.AutoParameterType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class ParamListStandard
implements ParamList {
    protected int numgroup;
    protected int pointermax;
    protected boolean thisbeforeret;
    protected ParamEntry[] entry;
    protected AddressSpace spacebase;

    private int findEntry(Address loc, int size) {
        for (int i = 0; i < this.entry.length; ++i) {
            if (this.entry[i].getMinSize() > size || this.entry[i].justifiedContain(loc, size) != 0) continue;
            return i;
        }
        return -1;
    }

    protected VariableStorage assignAddress(Program program, DataType tp, int[] status, boolean ishiddenret, boolean isindirect) {
        DataType baseType;
        if (tp == null) {
            tp = DataType.DEFAULT;
        }
        if ((baseType = tp) instanceof TypeDef) {
            baseType = ((TypeDef)baseType).getBaseDataType();
        }
        if (baseType instanceof VoidDataType) {
            return VariableStorage.VOID_STORAGE;
        }
        int sz = tp.getLength();
        if (sz == 0) {
            return VariableStorage.UNASSIGNED_STORAGE;
        }
        for (ParamEntry element : this.entry) {
            DynamicVariableStorage store;
            int grp = element.getGroup();
            if (status[grp] < 0 || element.getType() != 8 && ParamEntry.getMetatype(tp) != element.getType()) continue;
            VarnodeData res = new VarnodeData();
            status[grp] = element.getAddrBySlot(status[grp], tp.getLength(), res);
            if (res.space == null) continue;
            if (element.isExclusion()) {
                int maxgrp = grp + element.getGroupSize();
                for (int j = grp; j < maxgrp; ++j) {
                    status[j] = -1;
                }
                if (element.isFloatExtended()) {
                    sz = element.getSize();
                }
            }
            try {
                if (res.space.getType() == 6) {
                    Varnode[] pieces = element.getJoinRecord();
                    store = new DynamicVariableStorage(program, false, pieces);
                } else {
                    Address addr = res.space.getAddress(res.offset);
                    store = ishiddenret ? new DynamicVariableStorage(program, AutoParameterType.RETURN_STORAGE_PTR, addr, sz) : (isindirect ? new DynamicVariableStorage(program, true, addr, sz) : new DynamicVariableStorage(program, false, addr, sz));
                }
            }
            catch (InvalidInputException e) {
                break;
            }
            return store;
        }
        if (ishiddenret) {
            return DynamicVariableStorage.getUnassignedDynamicStorage(AutoParameterType.RETURN_STORAGE_PTR);
        }
        return DynamicVariableStorage.getUnassignedDynamicStorage(isindirect);
    }

    @Override
    public void assignMap(Program prog, DataType[] proto, boolean isinput, ArrayList<VariableStorage> res, boolean addAutoParams) {
        int i;
        int[] status = new int[this.numgroup];
        for (i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        if (isinput) {
            if (addAutoParams && res.size() == 2) {
                DataTypeManager dtm = prog.getDataTypeManager();
                Pointer pointer = dtm.getPointer(proto[0]);
                VariableStorage store = this.assignAddress(prog, pointer, status, true, false);
                res.set(1, store);
            }
            for (i = 1; i < proto.length; ++i) {
                VariableStorage store;
                if (this.pointermax != 0 && proto[i] != null && proto[i].getLength() > this.pointermax) {
                    DataTypeManager dtm = prog.getDataTypeManager();
                    Pointer pointer = dtm.getPointer(proto[i]);
                    store = this.assignAddress(prog, pointer, status, false, true);
                } else {
                    store = this.assignAddress(prog, proto[i], status, false, false);
                }
                res.add(store);
            }
        } else {
            VariableStorage store = this.assignAddress(prog, proto[0], status, false, false);
            res.add(store);
        }
    }

    @Override
    public VariableStorage[] getPotentialRegisterStorage(Program prog) {
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        for (ParamEntry element : this.entry) {
            ParamEntry pe = element;
            if (!pe.isExclusion() || !pe.getSpace().isRegisterSpace()) continue;
            VariableStorage var = null;
            try {
                var = new VariableStorage(prog, pe.getSpace().getAddress(pe.getAddressBase()), pe.getSize());
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (var == null) continue;
            res.add(var);
        }
        VariableStorage[] arres = new VariableStorage[res.size()];
        res.toArray(arres);
        return arres;
    }

    @Override
    public void restoreXml(XmlPullParser parser, CompilerSpec cspec, boolean normalstack) throws XmlParseException {
        XmlElement el;
        ArrayList<ParamEntry> pe = new ArrayList<ParamEntry>();
        int lastgroup = -1;
        this.numgroup = 0;
        this.spacebase = null;
        this.pointermax = 0;
        this.thisbeforeret = false;
        XmlElement mainel = parser.start(new String[0]);
        String attribute = mainel.getAttribute("pointermax");
        if (attribute != null) {
            this.pointermax = SpecXmlUtils.decodeInt((String)attribute);
        }
        if ((attribute = mainel.getAttribute("thisbeforeretpointer")) != null) {
            this.thisbeforeret = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        boolean seennonfloat = false;
        while ((el = parser.peek()).isStart()) {
            int maxgroup;
            ParamEntry pentry = new ParamEntry(this.numgroup);
            pentry.restoreXml(parser, cspec, normalstack);
            pe.add(pentry);
            if (pentry.getType() == 3) {
                if (seennonfloat) {
                    throw new XmlParseException("parameter list floating-point entries must come first");
                }
            } else {
                seennonfloat = true;
            }
            if (pentry.getSpace().isStackSpace()) {
                this.spacebase = pentry.getSpace();
            }
            if ((maxgroup = pentry.getGroup() + pentry.getGroupSize()) > this.numgroup) {
                this.numgroup = maxgroup;
            }
            if (pentry.getGroup() < lastgroup) {
                throw new XmlParseException("pentrys must come in group order");
            }
            lastgroup = pentry.getGroup();
        }
        parser.end(mainel);
        this.entry = new ParamEntry[pe.size()];
        pe.toArray(this.entry);
    }

    @Override
    public int getStackParameterAlignment() {
        for (ParamEntry pentry : this.entry) {
            if (!pentry.getSpace().isStackSpace()) continue;
            return pentry.getAlign();
        }
        return -1;
    }

    @Override
    public Long getStackParameterOffset() {
        for (ParamEntry element : this.entry) {
            ParamEntry pentry = element;
            if (pentry.isExclusion() || !pentry.getSpace().isStackSpace()) continue;
            long res = pentry.getAddressBase();
            if (pentry.isReverseStack()) {
                res += (long)pentry.getSize();
            }
            res = pentry.getSpace().truncateOffset(res);
            return res;
        }
        return null;
    }

    @Override
    public boolean possibleParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        if (loc == null) {
            return false;
        }
        int num = this.findEntry(loc, size);
        if (num == -1) {
            return false;
        }
        ParamEntry curentry = this.entry[num];
        res.slot = curentry.getSlot(loc, 0);
        res.slotsize = curentry.isExclusion() ? curentry.getGroupSize() : (size - 1) / curentry.getAlign() + 1;
        return true;
    }

    @Override
    public boolean isThisBeforeRetPointer() {
        return this.thisbeforeret;
    }
}

