/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.Arrays;
import java.util.zip.CRC32;

class PngResource {
    private static final int MAX_CHUNK_SIZE = 0xA00000;
    private static final byte[] IEND = new byte[]{73, 69, 78, 68};
    private MemBuffer buf;
    private int bufOffset;

    PngResource(MemBuffer buf) throws MemoryAccessException, InvalidDataTypeException {
        this.buf = buf;
        this.readHeader();
        this.scanContents();
    }

    int getLength() {
        return this.bufOffset;
    }

    private void scanContents() throws InvalidDataTypeException {
        int chunkCount = 0;
        byte[] type = new byte[4];
        int saveOffset = this.bufOffset;
        try {
            do {
                int len;
                if ((len = this.readInt()) < 0 || len > 0xA00000) {
                    throw new InvalidDataTypeException("Invalid PNG Data - too big");
                }
                this.buf.getBytes(type, this.bufOffset);
                this.bufOffset += 4;
                byte[] data = new byte[len];
                this.buf.getBytes(data, this.bufOffset);
                this.bufOffset += len;
                long crc = (long)this.readInt() & 0xFFFFFFFFL;
                if (!this.verifyCRC(type, data, crc)) {
                    throw new InvalidDataTypeException("Invalid PNG Data - bad CRC");
                }
                saveOffset = this.bufOffset;
                ++chunkCount;
            } while (!Arrays.equals(IEND, type));
        }
        catch (MemoryAccessException e) {
            throw new InvalidDataTypeException("Invalid PNG Data - missing data");
        }
        this.bufOffset = saveOffset;
        if (chunkCount == 0) {
            throw new InvalidDataTypeException("Invalid PNG Data - no data");
        }
    }

    private boolean verifyCRC(byte[] type, byte[] data, long crc) {
        CRC32 crc32 = new CRC32();
        crc32.update(type);
        crc32.update(data);
        long crcVal = crc32.getValue();
        return crcVal == crc;
    }

    private void readHeader() throws MemoryAccessException, InvalidDataTypeException {
        long sig = this.readLong();
        if (sig != -8552249625308161526L) {
            throw new InvalidDataTypeException("Invalid PNG Data");
        }
    }

    private long readLong() throws MemoryAccessException {
        long val = 0L;
        for (int i = 0; i < 8; ++i) {
            val <<= 8;
            val |= (long)(this.buf.getByte(this.bufOffset++) & 0xFF);
        }
        return val;
    }

    private int readInt() throws MemoryAccessException {
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val <<= 8;
            val |= this.buf.getByte(this.bufOffset++) & 0xFF;
        }
        return val;
    }
}

