/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.Record;
import ghidra.program.database.mem.ByteSourceRange;
import ghidra.program.database.mem.ByteSourceRangeList;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;

class BufferSubMemoryBlock
extends SubMemoryBlock {
    final DBBuffer buf;

    BufferSubMemoryBlock(MemoryMapDBAdapter adapter, Record record) throws IOException {
        super(adapter, record);
        int bufferID = record.getIntValue(4);
        this.buf = adapter.getBuffer(bufferID);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public byte getByte(long offsetInMemBlock) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        return this.buf.getByte((int)offsetInSubBlock);
    }

    @Override
    public int getBytes(long offsetInMemBlock, byte[] b, int off, int len) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        this.buf.get((int)offsetInSubBlock, b, off, len);
        return len;
    }

    @Override
    public void putByte(long offsetInMemBlock, byte b) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        this.buf.putByte((int)offsetInSubBlock, b);
    }

    @Override
    public int putBytes(long offsetInMemBlock, byte[] b, int off, int len) throws IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        this.buf.put((int)offsetInSubBlock, b, off, len);
        return len;
    }

    @Override
    public void delete() throws IOException {
        this.buf.delete();
        super.delete();
    }

    @Override
    protected boolean join(SubMemoryBlock block) throws IOException {
        if (!(block instanceof BufferSubMemoryBlock)) {
            return false;
        }
        BufferSubMemoryBlock other = (BufferSubMemoryBlock)block;
        if (other.subBlockLength + this.subBlockLength > 0x40000000L) {
            return false;
        }
        this.buf.append(other.buf);
        this.setLength(this.subBlockLength + other.subBlockLength);
        this.adapter.deleteSubBlock(other.record.getKey());
        return true;
    }

    long getKey() {
        return this.record.getKey();
    }

    @Override
    protected MemoryBlockType getType() {
        return MemoryBlockType.DEFAULT;
    }

    @Override
    protected SubMemoryBlock split(long memBlockOffset) throws IOException {
        int offset = (int)(memBlockOffset - this.subBlockOffset);
        long newLength = this.subBlockLength - (long)offset;
        this.subBlockLength = offset;
        this.record.setLongValue(2, this.subBlockLength);
        this.adapter.updateSubBlockRecord(this.record);
        DBBuffer split = this.buf.split(offset);
        Record newSubRecord = this.adapter.createSubBlockRecord(0L, 0L, newLength, (byte)2, split.getId(), 0L);
        return new BufferSubMemoryBlock(this.adapter, newSubRecord);
    }

    @Override
    protected String getDescription() {
        return "";
    }

    @Override
    protected ByteSourceRangeList getByteSourceRangeList(MemoryBlock block, Address start, long memBlockOffset, long size) {
        long sourceId = -this.buf.getId();
        ByteSourceRange bsRange = new ByteSourceRange(block, start, size, sourceId, memBlockOffset - this.subBlockOffset);
        return new ByteSourceRangeList(bsRange);
    }
}

