/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.GPTEntry;

public class MutableGPTEntry
extends GPTEntry {
    public MutableGPTEntry(int blockSize) {
        super(blockSize);
    }

    public MutableGPTEntry(GPTEntry source) {
        super(source);
    }

    public void setPartitionTypeGUID(byte[] data, int off) {
        MutableGPTEntry.copyData(data, off, this.partitionTypeGUID);
    }

    public void setUniquePartitionGUID(byte[] data, int off) {
        MutableGPTEntry.copyData(data, off, this.uniquePartitionGUID);
    }

    public void setStartingLBA(long i) {
        Util.arrayCopy((byte[])Util.toByteArrayLE((long)i), (byte[])this.startingLBA);
    }

    public void setEndingLBA(long i) {
        Util.arrayCopy((byte[])Util.toByteArrayLE((long)i), (byte[])this.endingLBA);
    }

    public void setAttributeBits(long i) {
        Util.arrayCopy((byte[])Util.toByteArrayBE((long)i), (byte[])this.attributeBits);
    }

    public void setPartitionName(byte[] data, int off) {
        MutableGPTEntry.copyData(data, off, this.partitionName);
    }

    public void setFields(GPTEntry gptEntry) {
        super.copyFields(gptEntry);
    }

    private static void copyData(byte[] data, int off, byte[] dest) {
        MutableGPTEntry.copyData(data, off, dest, dest.length);
    }

    private static void copyData(byte[] data, int off, byte[] dest, int len) {
        if (off + len > data.length) {
            throw new IllegalArgumentException("Length of input data must be " + len + ".");
        }
        System.arraycopy(data, off, dest, 0, len);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "MutableGPTEntry:");
        this.printFields(ps, prefix);
    }
}

