/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.IntListIndexer;
import ghidra.util.datastruct.Prime;
import ghidra.util.exception.AssertException;
import java.io.Serializable;
import java.util.Iterator;

public class StringKeyIndexer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_CAPACITY = 13;
    private String[] keys;
    private IntListIndexer indexer;
    private int capacity;

    public StringKeyIndexer() {
        this(13);
    }

    public StringKeyIndexer(int capacity) {
        this.capacity = capacity = Prime.nextPrime(capacity);
        this.indexer = new IntListIndexer(capacity, capacity);
        this.keys = new String[capacity];
    }

    public int put(String key) {
        int index = this.findKey(key);
        if (index == -1) {
            int hashcode;
            if (this.indexer.getSize() >= this.capacity) {
                this.grow();
            }
            if ((index = this.indexer.add(hashcode = (key.hashCode() & Integer.MAX_VALUE) % this.capacity)) < 0) {
                throw new IndexOutOfBoundsException("Maximum capacity reached");
            }
            this.keys[index] = key;
        }
        return index;
    }

    public int get(String key) {
        return this.findKey(key);
    }

    public int remove(String key) {
        int index = this.findKey(key);
        if (index == -1) {
            return -1;
        }
        int hashcode = (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
        this.indexer.remove(hashcode, index);
        this.keys[index] = null;
        return index;
    }

    public int getSize() {
        return this.indexer.getSize();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void clear() {
        this.indexer.clear();
    }

    public String[] getKeys() {
        String[] keyArray = new String[this.getSize()];
        int pos = 0;
        int nLists = this.indexer.getNumLists();
        for (int i = 0; i < nLists; ++i) {
            int keyIndex = this.indexer.first(i);
            while (keyIndex >= 0) {
                keyArray[pos++] = this.keys[keyIndex];
                keyIndex = this.indexer.next(keyIndex);
            }
        }
        if (pos != this.getSize()) {
            throw new AssertException("Trouble in IntKeyIndexer.getKeys(), size = " + this.getSize() + "  pos= " + pos);
        }
        return keyArray;
    }

    public Iterator<String> getKeyIterator() {
        return new KeyIterator();
    }

    private int findKey(String key) {
        int hashcode = (key.hashCode() & Integer.MAX_VALUE) % this.capacity;
        int p = this.indexer.first(hashcode);
        while (p != -1) {
            if (this.keys[p].equals(key)) {
                return p;
            }
            p = this.indexer.next(p);
        }
        return -1;
    }

    private void grow() {
        int newCapacity = Prime.nextPrime(this.indexer.getNewCapacity());
        this.indexer.growCapacity(newCapacity);
        this.indexer.growNumLists(newCapacity);
        this.indexer.clear();
        String[] oldKeys = this.keys;
        this.keys = new String[newCapacity];
        this.capacity = newCapacity;
        for (int i = 0; i < oldKeys.length; ++i) {
            this.put(oldKeys[i]);
        }
    }

    private class KeyIterator
    implements Iterator<String> {
        private int nLists;
        private int index;
        private int keyIndex;
        private String nextKey;

        KeyIterator() {
            this.nLists = StringKeyIndexer.this.indexer.getNumLists();
            this.index = 0;
            this.keyIndex = -1;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                String result = this.nextKey;
                this.findNext();
                return result;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.keyIndex < 0) {
                if (this.index >= this.nLists) {
                    this.nextKey = null;
                    return;
                }
                this.keyIndex = StringKeyIndexer.this.indexer.first(this.index);
                ++this.index;
            }
            this.nextKey = StringKeyIndexer.this.keys[this.keyIndex];
            this.keyIndex = StringKeyIndexer.this.indexer.next(this.keyIndex);
        }
    }
}

