/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.DockingTool;
import docking.action.DockingActionIf;
import docking.actions.KeyBindingUtils;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginClassManager;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.framework.plugintool.util.PluginPackage;
import ghidra.framework.plugintool.util.PluginPackageState;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

public class PluginConfigurationModel {
    private static Icon EXPERIMENTAL_ICON = ResourceManager.loadImage((String)"images/applications-science.png");
    private final ChangeListener listener;
    private final PluginTool tool;
    private PluginClassManager pluginClassManager;
    private Map<PluginDescription, Plugin> loadedPluginMap = new HashMap<PluginDescription, Plugin>();
    private Set<PluginDescription> pluginsWithDependenciesSet = new HashSet<PluginDescription>();
    private List<PluginDescription> unStablePluginDescriptions;
    private PluginPackage unstablePackage;

    public PluginConfigurationModel(PluginTool tool) {
        this(tool, e -> {});
    }

    public PluginConfigurationModel(PluginTool tool, ChangeListener listener) {
        this.tool = tool;
        this.listener = listener;
        this.pluginClassManager = tool.getPluginClassManager();
        this.initLoadedPlugins();
        this.unStablePluginDescriptions = this.pluginClassManager.getNonReleasedPluginDescriptions();
        if (!this.unStablePluginDescriptions.isEmpty()) {
            this.unstablePackage = new PluginPackage("Experimental", EXPERIMENTAL_ICON, "This package contains plugins that are not fully tested and/or documented.You must add these plugins individually.  Adding these plugins could cause the tool to become unstable.", Integer.MAX_VALUE){

                @Override
                public boolean isfullyAddable() {
                    return false;
                }
            };
        }
    }

    public List<PluginPackage> getPluginPackages() {
        List<PluginPackage> pluginPackages = this.pluginClassManager.getPluginPackages();
        ArrayList<PluginPackage> packagesWithStablePlugins = new ArrayList<PluginPackage>();
        for (PluginPackage pluginPackage : pluginPackages) {
            if (this.pluginClassManager.getReleasedPluginDescriptions(pluginPackage).size() <= 0) continue;
            packagesWithStablePlugins.add(pluginPackage);
        }
        if (this.unstablePackage != null) {
            packagesWithStablePlugins.add(this.unstablePackage);
        }
        return packagesWithStablePlugins;
    }

    public List<PluginDescription> getPluginDescriptions(PluginPackage pluginPackage) {
        if (pluginPackage == this.unstablePackage) {
            return this.unStablePluginDescriptions;
        }
        return this.pluginClassManager.getReleasedPluginDescriptions(pluginPackage);
    }

    private void initLoadedPlugins() {
        this.loadedPluginMap.clear();
        this.pluginsWithDependenciesSet.clear();
        List<Plugin> list = this.tool.getManagedPlugins();
        for (Plugin plugin : list) {
            this.loadedPluginMap.put(this.getPluginDescription(plugin), plugin);
            this.findDependencies(plugin, list);
        }
    }

    private void findDependencies(Plugin plugin, List<Plugin> plugins) {
        for (int i = 0; i < plugins.size(); ++i) {
            Plugin p = plugins.get(i);
            if (!p.dependsUpon(plugin)) continue;
            this.pluginsWithDependenciesSet.add(this.getPluginDescription(plugin));
        }
    }

    private PluginDescription getPluginDescription(Plugin plugin) {
        String className = plugin.getClass().getName();
        return this.pluginClassManager.getPluginDescription(className);
    }

    public boolean isLoaded(PluginDescription pluginDescription) {
        return this.loadedPluginMap.containsKey(pluginDescription);
    }

    public PluginPackageState getPackageState(PluginPackage pluginPackage) {
        boolean someInTool = false;
        boolean someNotInTool = false;
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (this.isLoaded(pluginDescription)) {
                someInTool = true;
                continue;
            }
            someNotInTool = true;
        }
        if (!someInTool) {
            return PluginPackageState.NO_PLUGINS_LOADED;
        }
        if (!someNotInTool) {
            return PluginPackageState.ALL_PLUGINS_LOADED;
        }
        return PluginPackageState.SOME_PLUGINS_LOADED;
    }

    public void addPlugin(PluginDescription pluginDescription) {
        try {
            this.tool.addPlugin(pluginDescription.getPluginClass().getName());
        }
        catch (PluginException e) {
            Msg.showError((Object)this, null, (String)"Error Loading Plugin", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.initLoadedPlugins();
        this.listener.stateChanged(null);
    }

    public void removeAllPlugins(PluginPackage pluginPackage) {
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        ArrayList<Plugin> loadedPlugins = new ArrayList<Plugin>();
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (!this.isLoaded(pluginDescription)) continue;
            loadedPlugins.add(this.loadedPluginMap.get(pluginDescription));
        }
        this.tool.removePlugins(loadedPlugins.toArray(new Plugin[loadedPlugins.size()]));
        this.initLoadedPlugins();
        this.listener.stateChanged(null);
    }

    public void addAllPlugins(PluginPackage pluginPackage) {
        List<PluginDescription> pluginDescriptions = this.getPluginDescriptions(pluginPackage);
        ArrayList<String> pluginClasseNames = new ArrayList<String>();
        for (PluginDescription pluginDescription : pluginDescriptions) {
            if (this.isLoaded(pluginDescription)) continue;
            pluginClasseNames.add(pluginDescription.getPluginClass().getName());
        }
        try {
            this.tool.addPlugins(pluginClasseNames.toArray(new String[pluginClasseNames.size()]));
        }
        catch (PluginException e) {
            Msg.showError((Object)this, null, (String)"Error Loading Plugin(s) ", (Object)e.getMessage(), (Throwable)((Object)e));
        }
        this.initLoadedPlugins();
        this.listener.stateChanged(null);
    }

    public void removePlugin(PluginDescription pluginDescription) {
        Plugin plugin = this.loadedPluginMap.get(pluginDescription);
        if (plugin != null) {
            this.tool.removePlugins(new Plugin[]{plugin});
        }
        this.initLoadedPlugins();
        this.listener.stateChanged(null);
    }

    public boolean hasDependencies(PluginDescription pluginDependency) {
        return this.pluginsWithDependenciesSet.contains(pluginDependency);
    }

    public Set<DockingActionIf> getActionsForPlugin(PluginDescription pluginDescription) {
        if (!this.isLoaded(pluginDescription)) {
            return Collections.emptySet();
        }
        return KeyBindingUtils.getKeyBindingActionsForOwner((DockingTool)this.tool, (String)pluginDescription.getName());
    }

    public List<PluginDescription> getDependencies(PluginDescription pd) {
        Plugin plugin = this.loadedPluginMap.get(pd);
        return plugin != null ? this.getDependencies(plugin, this.tool.getManagedPlugins()) : Collections.emptyList();
    }

    private List<PluginDescription> getDependencies(Plugin plugin, List<Plugin> plugins) {
        HashSet<PluginDescription> set = new HashSet<PluginDescription>();
        for (int i = 0; i < plugins.size(); ++i) {
            Plugin p = plugins.get(i);
            if (!p.dependsUpon(plugin)) continue;
            set.add(p.getPluginDescription());
        }
        return new ArrayList<PluginDescription>(set);
    }

    public List<PluginDescription> getAllPluginDescriptions() {
        return this.pluginClassManager.getAllPluginDescriptions();
    }
}

