/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CompositeGhidraTableCellRenderer
extends GhidraTableCellRenderer {
    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        JTable table = data.getTable();
        int row = data.getRowViewIndex();
        int column = data.getColumnViewIndex();
        boolean isSelected = data.isSelected();
        boolean hasFocus = data.hasFocus();
        Component rendererComponent = null;
        TableCellRenderer cellRenderer = this.getCellRenderer(table, row, column);
        rendererComponent = cellRenderer != null ? cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(data);
        return rendererComponent;
    }

    private TableCellRenderer getCellRenderer(JTable table, int row, int column) {
        if (table instanceof GTable) {
            GTable gTable = (GTable)table;
            return gTable.getCellRendererOverride(row, column);
        }
        TableColumn tableColumn = table.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            renderer = table.getDefaultRenderer(table.getColumnClass(column));
        }
        return renderer;
    }
}

