/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.util.GroupPath;
import java.io.Serializable;

public class GroupView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GroupPath[] paths;

    public GroupView(GroupPath[] paths) {
        this.paths = paths;
    }

    public GroupView(GroupPath path) {
        this.paths = new GroupPath[1];
        this.paths[0] = path;
    }

    public void addPath(GroupPath path) {
        GroupPath[] newPaths = new GroupPath[this.paths.length + 1];
        System.arraycopy(this.paths, 0, newPaths, 0, this.paths.length);
        newPaths[this.paths.length] = path;
        this.paths = newPaths;
    }

    public int getCount() {
        return this.paths.length;
    }

    public GroupPath getPath(int index) {
        return this.paths[index];
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupView gs = (GroupView)obj;
        if (this.paths.length != gs.paths.length) {
            return false;
        }
        for (int i = 0; i < this.paths.length; ++i) {
            if (this.paths[i].equals((Object)gs.paths[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.paths.length; ++i) {
            sb.append(this.paths[i]);
            if (i >= this.paths.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

