/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.string.translate.ClearTranslationAction;
import ghidra.app.plugin.core.string.translate.ManualStringTranslationService;
import ghidra.app.plugin.core.string.translate.ToggleShowTranslationAction;
import ghidra.app.plugin.core.string.translate.TranslateAction;
import ghidra.app.services.StringTranslationService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="String translation", description="Allows the user to use string translation services.", servicesProvided={StringTranslationService.class})
public class TranslateStringsPlugin
extends Plugin {
    private List<DockingAction> translationActions = new ArrayList<DockingAction>();
    private List<StringTranslationService> translationServices = new ArrayList<StringTranslationService>();

    public TranslateStringsPlugin(PluginTool tool) {
        super(tool);
        this.setupServices();
    }

    protected void init() {
        this.createTranslateActions();
        this.createTranslateMetaActions();
    }

    private void setupServices() {
        this.registerServiceProvided(StringTranslationService.class, new ManualStringTranslationService());
    }

    private void createTranslateMetaActions() {
        this.tool.addAction((DockingActionIf)new ClearTranslationAction(this.getName()));
        this.tool.addAction((DockingActionIf)new ToggleShowTranslationAction(this.getName()));
    }

    private void createTranslateActionsIfNeeded() {
        boolean isSame;
        ArrayList<StringTranslationService> newServices = new ArrayList<StringTranslationService>(Arrays.asList((StringTranslationService[])this.tool.getServices(StringTranslationService.class)));
        boolean bl = isSame = newServices.containsAll(this.translationServices) && this.translationServices.containsAll(newServices);
        if (!isSame) {
            this.createTranslateActions();
        }
    }

    private void createTranslateActions() {
        for (DockingAction prevAction : this.translationActions) {
            this.tool.removeAction((DockingActionIf)prevAction);
        }
        this.translationActions.clear();
        this.translationServices.clear();
        this.translationServices.addAll(Arrays.asList((StringTranslationService[])this.tool.getServices(StringTranslationService.class)));
        Collections.sort(this.translationServices, (s1, s2) -> s1.getTranslationServiceName().compareTo(s2.getTranslationServiceName()));
        for (StringTranslationService service : this.translationServices) {
            TranslateAction action = new TranslateAction(this.getName(), service);
            this.translationActions.add(action);
            this.tool.addAction((DockingActionIf)action);
        }
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        this.createTranslateActionsIfNeeded();
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        this.createTranslateActionsIfNeeded();
    }
}

