/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.cmd.refs.SetExternalNameCmd;
import ghidra.app.plugin.core.references.ExternalReferencesProvider;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.HelpLocation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class SetExternalNameAssociationAction
extends DockingAction {
    private static ImageIcon EDIT_ICON = ResourceManager.loadImage((String)"images/editbytes.gif");
    private final ExternalReferencesProvider provider;

    public SetExternalNameAssociationAction(ExternalReferencesProvider provider) {
        super("Set External Name Association", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Set External Name Association"}, (Icon)EDIT_ICON, null));
        this.setToolBarData(new ToolBarData((Icon)EDIT_ICON, null));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public void actionPerformed(ActionContext context) {
        List<String> selectedExternalNames = this.provider.getSelectedExternalNames();
        final String externalName = selectedExternalNames.get(0);
        final DataTreeDialog dialog = new DataTreeDialog(this.provider.getComponent(), "Choose External Program (" + externalName + ")", 0);
        dialog.setSearchText(externalName);
        dialog.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                DomainFile domainFile = dialog.getDomainFile();
                if (domainFile == null) {
                    return;
                }
                String pathName = domainFile.toString();
                dialog.close();
                ExternalManager externalManager = SetExternalNameAssociationAction.this.provider.getProgram().getExternalManager();
                String externalLibraryPath = externalManager.getExternalLibraryPath(externalName);
                if (!pathName.equals(externalLibraryPath)) {
                    SetExternalNameCmd cmd = new SetExternalNameCmd(externalName, domainFile.getPathname());
                    SetExternalNameAssociationAction.this.provider.getTool().execute((Command)cmd, (DomainObject)SetExternalNameAssociationAction.this.provider.getProgram());
                }
            }
        });
        dialog.setHelpLocation(new HelpLocation("ReferencesPlugin", "ChooseExternalProgram"));
        this.provider.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

