/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.util.HTMLUtilities;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class FilterArraysAction
extends ToggleDockingAction {
    private static final Icon FILTER_ARRAYS_ICON = ResourceManager.loadImage((String)"images/FilterArrays.png");
    private static final Icon ARRAY_ICON = ResourceManager.loadImage((String)"images/Array.png");

    public FilterArraysAction(DataTypeManagerPlugin plugin) {
        super("Filter Arrays", plugin.getName());
        this.setToolBarData(new ToolBarData(FILTER_ARRAYS_ICON, "filters"));
        this.setDescription(HTMLUtilities.toHTML((String)"Toggle whether or not Arrays are\ndisplayed in the Data Type Manager tree."));
        this.setSelected(true);
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof DataTypesActionContext;
    }

    public void actionPerformed(ActionContext context) {
        DataTypeArchiveGTree gtree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        List expandedPaths = gtree.getExpandedPaths((GTreeNode)gtree.getRootNode());
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        gtree.enableArrayFilter(this.isSelected());
        gtree.expandPaths(expandedPaths);
        gtree.setSelectionPaths(selectionPaths);
    }

    public void setSelected(boolean selected) {
        this.getToolBarData().setIcon(selected ? FILTER_ARRAYS_ICON : ARRAY_ICON);
        super.setSelected(selected);
    }
}

