/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import ghidra.graph.DefaultGEdge;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.jung.JungDirectedGraph;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import utilities.util.FileUtilities;

public class IncludeFileFinder {
    private File rootDir;
    private int rootPathPrefixLength;

    public IncludeFileFinder(File rootDir) {
        this.rootDir = rootDir;
        this.rootPathPrefixLength = rootDir.getAbsolutePath().length() + 1;
    }

    public List<String> getIncludeFiles(boolean recursive) {
        List<IncludeFile> includeFileList = this.findIncludeFiles(recursive);
        return this.getPaths(includeFileList);
    }

    public List<String> getIncludeFileRoots(boolean recursive) throws IOException {
        List<IncludeFile> includeFileList = this.findIncludeFiles(recursive);
        JungDirectedGraph g = new JungDirectedGraph();
        IncludeFileFinder.processIncludeFiles(includeFileList, (GDirectedGraph<IncludeFile, GEdge<IncludeFile>>)g);
        Set roots = GraphAlgorithms.getEntryPoints((GDirectedGraph)g);
        List<String> paths = this.getPaths(roots);
        Collections.sort(paths);
        return paths;
    }

    private static void processIncludeFiles(List<IncludeFile> fileSet, GDirectedGraph<IncludeFile, GEdge<IncludeFile>> g) throws IOException {
        for (IncludeFile includeFile : fileSet) {
            List lines = FileUtilities.getLines((File)includeFile.file);
            for (String line : lines) {
                if (!line.toLowerCase().contains("include")) continue;
                IncludeFileFinder.processLine(includeFile, fileSet, line, g);
            }
        }
    }

    private static void processLine(IncludeFile fromFile, List<IncludeFile> fileSet, String line, GDirectedGraph<IncludeFile, GEdge<IncludeFile>> g) {
        for (IncludeFile referencedFile : fileSet) {
            String relativePath = referencedFile.getRelativePath();
            if (!line.contains(relativePath)) continue;
            g.addEdge((GEdge)new DefaultGEdge((Object)fromFile, (Object)referencedFile));
        }
    }

    private List<String> getPaths(Collection<IncludeFile> includeFileList) {
        ArrayList<String> list = new ArrayList<String>(includeFileList.size());
        for (IncludeFile includeFile : includeFileList) {
            list.add(includeFile.relativePath);
        }
        return list;
    }

    private List<IncludeFile> findIncludeFiles(boolean recursive) {
        ArrayList<IncludeFile> fileList = new ArrayList<IncludeFile>();
        this.doFindIncludeFiles(this.rootDir, fileList, recursive);
        return fileList;
    }

    private void doFindIncludeFiles(File dir, List<IncludeFile> fileList, boolean recursive) {
        File[] listFiles;
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : listFiles = dir.listFiles()) {
            if (this.isInclude(file)) {
                fileList.add(new IncludeFile(file));
                continue;
            }
            if (!recursive) continue;
            this.doFindIncludeFiles(file, fileList, recursive);
        }
    }

    private boolean isInclude(File file) {
        return file.getName().endsWith(".h");
    }

    public static void main(String[] args) throws IOException {
        File root = new File("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.9.sdk/usr/include");
        IncludeFileFinder finder = new IncludeFileFinder(root);
        List<String> roots = finder.getIncludeFileRoots(true);
        for (String string : roots) {
            System.out.println(string);
        }
        System.out.println("root list size = " + roots.size());
    }

    class IncludeFile {
        private File file;
        private String relativePath;

        IncludeFile(File file) {
            this.file = file;
            this.relativePath = file.getAbsolutePath().substring(IncludeFileFinder.this.rootPathPrefixLength);
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public File getFile() {
            return this.file;
        }
    }
}

