/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.jung.transformer;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.program.util.ProgramSelection;
import java.awt.Color;
import java.awt.Paint;

public class FGVertexPickableBackgroundPaintTransformer
implements Function<FGVertex, Paint> {
    private final PickedInfo<FGVertex> info;
    private final Color pickedColor;
    private final Color entryColor;
    private final Color exitColor;
    private final Color pickedStartColor;
    private final Color pickedEndColor;

    private static Color mix(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    public FGVertexPickableBackgroundPaintTransformer(PickedInfo<FGVertex> info, Color pickedColor, Color startColor, Color endColor) {
        if (info == null) {
            throw new IllegalArgumentException("PickedInfo instance must be non-null");
        }
        this.info = info;
        this.pickedColor = pickedColor;
        this.entryColor = startColor;
        this.exitColor = endColor;
        this.pickedStartColor = FGVertexPickableBackgroundPaintTransformer.mix(pickedColor, startColor);
        this.pickedEndColor = FGVertexPickableBackgroundPaintTransformer.mix(pickedColor, endColor);
    }

    public Paint apply(FGVertex v) {
        Color backgroundColor = v.getBackgroundColor();
        ProgramSelection selection = v.getProgramSelection();
        if (!selection.isEmpty()) {
            Color mixed;
            Color selectionColor = v.getSelectionColor();
            backgroundColor = mixed = FGVertexPickableBackgroundPaintTransformer.mix(selectionColor, backgroundColor);
        }
        FGVertexType vertexType = v.getVertexType();
        if (this.info.isPicked((Object)v)) {
            if (v.isDefaultBackgroundColor()) {
                if (vertexType.isEntry()) {
                    return this.pickedStartColor;
                }
                if (vertexType.isExit()) {
                    return this.pickedEndColor;
                }
                return this.pickedColor;
            }
            if (vertexType.isEntry()) {
                return this.pickedStartColor.darker();
            }
            if (vertexType.isExit()) {
                return this.pickedEndColor.darker();
            }
            return this.pickedColor.darker();
        }
        if (vertexType.isEntry()) {
            return this.entryColor;
        }
        if (vertexType.isExit()) {
            return this.exitColor;
        }
        return backgroundColor;
    }
}

