/*
 * Decompiled with CFR 0.152.
 */
package docking.util.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class CalloutComponentInfo {
    Point locationOnScreen;
    Point relativeLocation;
    Dimension size;
    Component component;
    Component destinationComponent;
    double magnification = 2.0;

    public CalloutComponentInfo(Component destinationComponent, Component component) {
        this(destinationComponent, component, component.getLocationOnScreen(), component.getLocation(), component.getSize());
    }

    public CalloutComponentInfo(Component destinationComponent, Component component, Point locationOnScreen, Point relativeLocation, Dimension size) {
        this.destinationComponent = destinationComponent;
        this.component = component;
        this.locationOnScreen = locationOnScreen;
        this.relativeLocation = relativeLocation;
        this.size = size;
    }

    public Point convertPointToParent(Point location) {
        return SwingUtilities.convertPoint(this.component.getParent(), location, this.destinationComponent);
    }

    public void setMagnification(double magnification) {
        this.magnification = magnification;
    }

    Component getComponent() {
        return this.component;
    }

    Point getLocationOnScreen() {
        return this.locationOnScreen;
    }

    Dimension getSize() {
        return this.size;
    }

    Rectangle getBounds() {
        return new Rectangle(this.relativeLocation, this.size);
    }

    double getMagnification() {
        return this.magnification;
    }
}

