/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ConfigLayerXml {
    private static final ConfigLayerXml INSTANCE = new ConfigLayerXml();
    public static final String NAMESPACE_1_0 = "urn:jboss:galleon:layer-spec:1.0";

    public static ConfigLayerXml getInstance() {
        return INSTANCE;
    }

    public static void readConfigLayer(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        String name = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    builder.setName(name);
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element e = (Element)Element.elementsByLocal.get(reader.getName().getLocalPart());
                    if (e != null) {
                        switch (e) {
                            case DEPENDENCIES: {
                                ConfigLayerXml.readDeps(reader, builder);
                                continue block11;
                            }
                        }
                        throw ParsingUtils.unexpectedContent(reader);
                    }
                    if (FeatureGroupXml.handleFeatureGroupBodyElement(reader, builder)) continue block11;
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readDeps(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case LAYER: {
                            ConfigLayerXml.readLayer(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readLayer(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        String name = null;
        boolean optional = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        builder.addLayerDep(name, optional);
        ParsingUtils.parseNoContent(reader);
    }

    protected static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        OPTIONAL("optional"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(3);
            attributes.put(new QName(NAME.getLocalName()), NAME);
            attributes.put(new QName(OPTIONAL.getLocalName()), OPTIONAL);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        DEPENDENCIES("dependencies"),
        LAYER("layer"),
        LAYER_SPEC("layer-spec"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:layer-spec:1.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ConfigLayerXml.NAMESPACE_1_0;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(4);
            elementsByLocal.put(Element.DEPENDENCIES.name, DEPENDENCIES);
            elementsByLocal.put(Element.LAYER.name, LAYER);
            elementsByLocal.put(Element.LAYER_SPEC.name, LAYER_SPEC);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

