/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.reports;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.traccar.helper.DateUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.BaseModel;
import org.traccar.model.Message;
import org.traccar.model.Position;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;

public class CsvExportProvider {
    private final Storage storage;

    @Inject
    public CsvExportProvider(Storage storage) {
        this.storage = storage;
    }

    public void generate(OutputStream outputStream, long deviceId, Date from, Date to) throws StorageException {
        List<Position> positions = PositionUtil.getPositions(this.storage, deviceId, from, to);
        Set<String> attributes = positions.stream().flatMap(position -> position.getAttributes().keySet().stream()).collect(Collectors.toUnmodifiableSet());
        LinkedHashMap<String, Function<Position, Object>> properties = new LinkedHashMap<String, Function<Position, Object>>();
        properties.put("id", BaseModel::getId);
        properties.put("deviceId", Message::getDeviceId);
        properties.put("protocol", Position::getProtocol);
        properties.put("serverTime", position -> DateUtil.formatDate(position.getServerTime()));
        properties.put("deviceTime", position -> DateUtil.formatDate(position.getDeviceTime()));
        properties.put("fixTime", position -> DateUtil.formatDate(position.getFixTime()));
        properties.put("valid", Position::getValid);
        properties.put("latitude", Position::getLatitude);
        properties.put("longitude", Position::getLongitude);
        properties.put("altitude", Position::getAltitude);
        properties.put("speed", Position::getSpeed);
        properties.put("course", Position::getCourse);
        properties.put("address", Position::getAddress);
        properties.put("accuracy", Position::getAccuracy);
        attributes.forEach(key -> properties.put((String)key, position -> position.getAttributes().get(key)));
        try (PrintWriter writer = new PrintWriter(outputStream);){
            writer.println(String.join((CharSequence)",", properties.keySet()));
            positions.forEach(position -> writer.println(properties.values().stream().map(f -> Objects.toString(f.apply(position), "")).collect(Collectors.joining(","))));
        }
    }
}

