/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.traccar.BasePipelineFactory;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.protocol.OrbcommProtocolPoller;
import org.traccar.session.DeviceSession;

public class OrbcommProtocolDecoder
extends BaseProtocolDecoder {
    public OrbcommProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        OrbcommProtocolPoller poller;
        FullHttpResponse response = (FullHttpResponse)msg;
        String content = response.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        if (channel != null && !json.getString("NextStartUTC").isEmpty() && (poller = BasePipelineFactory.getHandler(channel.pipeline(), OrbcommProtocolPoller.class)) != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            poller.setStartTime(dateFormat.parse(json.getString("NextStartUTC")));
        }
        if (((JsonValue)json.get((Object)"Messages")).getValueType() == JsonValue.ValueType.NULL) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        JsonArray messages = json.getJsonArray("Messages");
        for (int i = 0; i < messages.size(); ++i) {
            JsonObject message = messages.getJsonObject(i);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, message.getString("MobileID"));
            if (deviceSession == null) continue;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            position.setDeviceTime(dateFormat.parse(message.getString("MessageUTC")));
            JsonArray fields = message.getJsonObject("Payload").getJsonArray("Fields");
            block15: for (int j = 0; j < fields.size(); ++j) {
                JsonObject field = fields.getJsonObject(j);
                String value = field.getString("Value");
                switch (field.getString("Name").toLowerCase()) {
                    case "eventtime": {
                        position.setDeviceTime(new Date(Long.parseLong(value) * 1000L));
                        continue block15;
                    }
                    case "latitude": {
                        position.setLatitude((double)Integer.parseInt(value) / 60000.0);
                        continue block15;
                    }
                    case "longitude": {
                        position.setLongitude((double)Integer.parseInt(value) / 60000.0);
                        continue block15;
                    }
                    case "speed": {
                        position.setSpeed(UnitsConverter.knotsFromKph(Integer.parseInt(value)));
                        continue block15;
                    }
                    case "heading": {
                        int heading = Integer.parseInt(value);
                        position.setCourse(heading <= 360 ? (double)heading : 0.0);
                        continue block15;
                    }
                }
            }
            if (position.getLatitude() != 0.0 && position.getLongitude() != 0.0) {
                position.setValid(true);
                position.setFixTime(position.getDeviceTime());
            } else {
                this.getLastLocation(position, position.getDeviceTime());
            }
            positions.add(position);
        }
        return positions.isEmpty() ? null : positions;
    }
}

