/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.signature;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.traccar.api.signature.CryptoManager;
import org.traccar.storage.StorageException;

public class TokenManager {
    private static final int DEFAULT_EXPIRATION_DAYS = 7;
    private final ObjectMapper objectMapper;
    private final CryptoManager cryptoManager;

    @Inject
    public TokenManager(ObjectMapper objectMapper, CryptoManager cryptoManager) {
        this.objectMapper = objectMapper;
        this.cryptoManager = cryptoManager;
    }

    public String generateToken(long userId) throws IOException, GeneralSecurityException, StorageException {
        return this.generateToken(userId, null);
    }

    public String generateToken(long userId, Date expiration) throws IOException, GeneralSecurityException, StorageException {
        Data data = new Data();
        data.userId = userId;
        data.expiration = expiration != null ? expiration : new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(7L));
        byte[] encoded = this.objectMapper.writeValueAsBytes((Object)data);
        return Base64.encodeBase64URLSafeString((byte[])this.cryptoManager.sign(encoded));
    }

    public long verifyToken(String token) throws IOException, GeneralSecurityException, StorageException {
        byte[] encoded = this.cryptoManager.verify(Base64.decodeBase64((String)token));
        Data data = (Data)this.objectMapper.readValue(encoded, Data.class);
        if (data.expiration.before(new Date())) {
            throw new SecurityException("Token has expired");
        }
        return data.userId;
    }

    public static class Data {
        @JsonProperty(value="u")
        private long userId;
        @JsonProperty(value="e")
        private Date expiration;
    }
}

