/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.text.Annotatable;

public abstract class Annotation {
    public static final String PROP_SHORT_DESCRIPTION = "shortDescription";
    public static final String PROP_ANNOTATION_TYPE = "annotationType";
    public static final String PROP_MOVE_TO_FRONT = "moveToFront";
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Annotatable attached;
    private boolean inDocument = false;

    public abstract String getAnnotationType();

    public abstract String getShortDescription();

    public final void attach(Annotatable annotatable) {
        if (this.attached != null) {
            this.detach();
        }
        this.attached = annotatable;
        this.attached.addAnnotation(this);
        this.notifyAttached(this.attached);
    }

    protected void notifyAttached(Annotatable annotatable) {
    }

    public final void detach() {
        if (this.attached != null) {
            this.attached.removeAnnotation(this);
            Annotatable annotatable = this.attached;
            this.attached = null;
            this.notifyDetached(annotatable);
        }
    }

    protected void notifyDetached(Annotatable annotatable) {
    }

    public final Annotatable getAttachedAnnotatable() {
        return this.attached;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.support.firePropertyChange(string, object, object2);
    }

    public final void moveToFront() {
        this.support.firePropertyChange(PROP_MOVE_TO_FRONT, null, null);
    }

    final boolean isInDocument() {
        return this.inDocument;
    }

    final void setInDocument(boolean bl) {
        this.inDocument = bl;
    }
}

