"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationsDashboardsPlugin = void 0;

var _routes = require("./routes");

var _notificationsPlugin = require("./clusters/notificationsPlugin");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class notificationsDashboardsPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug("notificationsDashboards: Setup");
    const router = core.http.createRouter();
    const notificationsClient = core.opensearch.legacy.createClient('opensearch_notifications', {
      plugins: [_notificationsPlugin.NotificationsPlugin]
    });
    core.http.registerRouteHandlerContext('notificationsContext', (context, request) => {
      return {
        logger: this.logger,
        notificationsClient
      };
    }); // Register server side APIs

    (0, _routes.defineRoutes)(router);
    return {};
  }

  start(core) {
    this.logger.debug("notificationsDashboards: Started");
    return {};
  }

  stop() {}

}

exports.notificationsDashboardsPlugin = notificationsDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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