"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GET_FINDINGS_SORT_FIELDS = exports.DEFAULT_GET_FINDINGS_PARAMS = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// TODO DRAFT: Are these sortField options appropriate?
const GET_FINDINGS_SORT_FIELDS = {
  INDEX: 'index',
  MONITOR_NAME: 'monitor_name',
  TIMESTAMP: 'timestamp'
}; // TODO DRAFT: RestGetFindingsAction.kt in the backend references a `missing` field in params.
//  Investigate if/how we should make use of that.

exports.GET_FINDINGS_SORT_FIELDS = GET_FINDINGS_SORT_FIELDS;
const DEFAULT_GET_FINDINGS_PARAMS = {
  // TODO DRAFT: Does providing a finding ID serve a particular function? Results with/without the ID seemed the same.
  id: undefined,
  from: 0,
  search: '',
  size: 20,
  sortDirection: 'desc',
  sortField: GET_FINDINGS_SORT_FIELDS.TIMESTAMP
};
exports.DEFAULT_GET_FINDINGS_PARAMS = DEFAULT_GET_FINDINGS_PARAMS;

class FindingService {
  constructor(esDriver) {
    _defineProperty(this, "getFindings", async (context, req, res) => {
      const {
        id = DEFAULT_GET_FINDINGS_PARAMS.id,
        from = DEFAULT_GET_FINDINGS_PARAMS.from,
        size = DEFAULT_GET_FINDINGS_PARAMS.size,
        search = DEFAULT_GET_FINDINGS_PARAMS.search,
        sortDirection = DEFAULT_GET_FINDINGS_PARAMS.sortDirection,
        sortField = DEFAULT_GET_FINDINGS_PARAMS.sortField
      } = req.query;
      var params;

      switch (sortField) {
        case GET_FINDINGS_SORT_FIELDS.INDEX:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;

        case GET_FINDINGS_SORT_FIELDS.MONITOR_NAME:
          params = {
            sortString: `${sortField}.keyword`,
            sortOrder: sortDirection
          };
          break;

        default:
          // If the sortField parsed from the URL isn't a valid option for this API, use a default option.
          params = {
            sortString: GET_FINDINGS_SORT_FIELDS.TIMESTAMP,
            sortOrder: sortDirection
          };
      }

      if (!_lodash.default.isEmpty(id)) params.findingId = id;
      params.startIndex = from;
      params.size = size;
      params.searchString = search;
      if (search.trim()) params.searchString = `*${search.trim().split(' ').join('* *')}*`;
      const {
        callAsCurrentUser
      } = this.esDriver.asScoped(req);

      try {
        const resp = await callAsCurrentUser('alerting.getFindings', params);
        const findings = resp.findings.map(result => ({
          [result.finding.id]: { ...result
          }
        }));
        const totalFindings = resp.totalFindings;
        return res.ok({
          body: {
            ok: true,
            findings,
            totalFindings
          }
        });
      } catch (err) {
        console.log(err.message);
        return res.ok({
          body: {
            ok: false,
            err: err.message
          }
        });
      }
    });

    this.esDriver = esDriver;
  }

}

exports.default = FindingService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIkZpbmRpbmdTZXJ2aWNlLmpzIl0sIm5hbWVzIjpbIkdFVF9GSU5ESU5HU19TT1JUX0ZJRUxEUyIsIklOREVYIiwiTU9OSVRPUl9OQU1FIiwiVElNRVNUQU1QIiwiREVGQVVMVF9HRVRfRklORElOR1NfUEFSQU1TIiwiaWQiLCJ1bmRlZmluZWQiLCJmcm9tIiwic2VhcmNoIiwic2l6ZSIsInNvcnREaXJlY3Rpb24iLCJzb3J0RmllbGQiLCJGaW5kaW5nU2VydmljZSIsImNvbnN0cnVjdG9yIiwiZXNEcml2ZXIiLCJjb250ZXh0IiwicmVxIiwicmVzIiwicXVlcnkiLCJwYXJhbXMiLCJzb3J0U3RyaW5nIiwic29ydE9yZGVyIiwiXyIsImlzRW1wdHkiLCJmaW5kaW5nSWQiLCJzdGFydEluZGV4Iiwic2VhcmNoU3RyaW5nIiwidHJpbSIsInNwbGl0Iiwiam9pbiIsImNhbGxBc0N1cnJlbnRVc2VyIiwiYXNTY29wZWQiLCJyZXNwIiwiZmluZGluZ3MiLCJtYXAiLCJyZXN1bHQiLCJmaW5kaW5nIiwidG90YWxGaW5kaW5ncyIsIm9rIiwiYm9keSIsImVyciIsImNvbnNvbGUiLCJsb2ciLCJtZXNzYWdlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0E7Ozs7OztBQUVBO0FBQ08sTUFBTUEsd0JBQXdCLEdBQUc7QUFDdENDLEVBQUFBLEtBQUssRUFBRSxPQUQrQjtBQUV0Q0MsRUFBQUEsWUFBWSxFQUFFLGNBRndCO0FBR3RDQyxFQUFBQSxTQUFTLEVBQUU7QUFIMkIsQ0FBakMsQyxDQU1QO0FBQ0E7OztBQUNPLE1BQU1DLDJCQUEyQixHQUFHO0FBQ3pDO0FBQ0FDLEVBQUFBLEVBQUUsRUFBRUMsU0FGcUM7QUFHekNDLEVBQUFBLElBQUksRUFBRSxDQUhtQztBQUl6Q0MsRUFBQUEsTUFBTSxFQUFFLEVBSmlDO0FBS3pDQyxFQUFBQSxJQUFJLEVBQUUsRUFMbUM7QUFNekNDLEVBQUFBLGFBQWEsRUFBRSxNQU4wQjtBQU96Q0MsRUFBQUEsU0FBUyxFQUFFWCx3QkFBd0IsQ0FBQ0c7QUFQSyxDQUFwQzs7O0FBVVEsTUFBTVMsY0FBTixDQUFxQjtBQUNsQ0MsRUFBQUEsV0FBVyxDQUFDQyxRQUFELEVBQVc7QUFBQSx5Q0FJUixPQUFPQyxPQUFQLEVBQWdCQyxHQUFoQixFQUFxQkMsR0FBckIsS0FBNkI7QUFDekMsWUFBTTtBQUNKWixRQUFBQSxFQUFFLEdBQUdELDJCQUEyQixDQUFDQyxFQUQ3QjtBQUVKRSxRQUFBQSxJQUFJLEdBQUdILDJCQUEyQixDQUFDRyxJQUYvQjtBQUdKRSxRQUFBQSxJQUFJLEdBQUdMLDJCQUEyQixDQUFDSyxJQUgvQjtBQUlKRCxRQUFBQSxNQUFNLEdBQUdKLDJCQUEyQixDQUFDSSxNQUpqQztBQUtKRSxRQUFBQSxhQUFhLEdBQUdOLDJCQUEyQixDQUFDTSxhQUx4QztBQU1KQyxRQUFBQSxTQUFTLEdBQUdQLDJCQUEyQixDQUFDTztBQU5wQyxVQU9GSyxHQUFHLENBQUNFLEtBUFI7QUFTQSxVQUFJQyxNQUFKOztBQUNBLGNBQVFSLFNBQVI7QUFDRSxhQUFLWCx3QkFBd0IsQ0FBQ0MsS0FBOUI7QUFDRWtCLFVBQUFBLE1BQU0sR0FBRztBQUNQQyxZQUFBQSxVQUFVLEVBQUcsR0FBRVQsU0FBVSxVQURsQjtBQUVQVSxZQUFBQSxTQUFTLEVBQUVYO0FBRkosV0FBVDtBQUlBOztBQUNGLGFBQUtWLHdCQUF3QixDQUFDRSxZQUE5QjtBQUNFaUIsVUFBQUEsTUFBTSxHQUFHO0FBQ1BDLFlBQUFBLFVBQVUsRUFBRyxHQUFFVCxTQUFVLFVBRGxCO0FBRVBVLFlBQUFBLFNBQVMsRUFBRVg7QUFGSixXQUFUO0FBSUE7O0FBQ0Y7QUFDRTtBQUNBUyxVQUFBQSxNQUFNLEdBQUc7QUFDUEMsWUFBQUEsVUFBVSxFQUFFcEIsd0JBQXdCLENBQUNHLFNBRDlCO0FBRVBrQixZQUFBQSxTQUFTLEVBQUVYO0FBRkosV0FBVDtBQWZKOztBQXFCQSxVQUFJLENBQUNZLGdCQUFFQyxPQUFGLENBQVVsQixFQUFWLENBQUwsRUFBb0JjLE1BQU0sQ0FBQ0ssU0FBUCxHQUFtQm5CLEVBQW5CO0FBQ3BCYyxNQUFBQSxNQUFNLENBQUNNLFVBQVAsR0FBb0JsQixJQUFwQjtBQUNBWSxNQUFBQSxNQUFNLENBQUNWLElBQVAsR0FBY0EsSUFBZDtBQUNBVSxNQUFBQSxNQUFNLENBQUNPLFlBQVAsR0FBc0JsQixNQUF0QjtBQUNBLFVBQUlBLE1BQU0sQ0FBQ21CLElBQVAsRUFBSixFQUFtQlIsTUFBTSxDQUFDTyxZQUFQLEdBQXVCLElBQUdsQixNQUFNLENBQUNtQixJQUFQLEdBQWNDLEtBQWQsQ0FBb0IsR0FBcEIsRUFBeUJDLElBQXpCLENBQThCLEtBQTlCLENBQXFDLEdBQS9EO0FBRW5CLFlBQU07QUFBRUMsUUFBQUE7QUFBRixVQUF3QixLQUFLaEIsUUFBTCxDQUFjaUIsUUFBZCxDQUF1QmYsR0FBdkIsQ0FBOUI7O0FBQ0EsVUFBSTtBQUNGLGNBQU1nQixJQUFJLEdBQUcsTUFBTUYsaUJBQWlCLENBQUMsc0JBQUQsRUFBeUJYLE1BQXpCLENBQXBDO0FBQ0EsY0FBTWMsUUFBUSxHQUFHRCxJQUFJLENBQUNDLFFBQUwsQ0FBY0MsR0FBZCxDQUFtQkMsTUFBRCxLQUFhO0FBQUUsV0FBQ0EsTUFBTSxDQUFDQyxPQUFQLENBQWUvQixFQUFoQixHQUFxQixFQUFFLEdBQUc4QjtBQUFMO0FBQXZCLFNBQWIsQ0FBbEIsQ0FBakI7QUFDQSxjQUFNRSxhQUFhLEdBQUdMLElBQUksQ0FBQ0ssYUFBM0I7QUFDQSxlQUFPcEIsR0FBRyxDQUFDcUIsRUFBSixDQUFPO0FBQ1pDLFVBQUFBLElBQUksRUFBRTtBQUNKRCxZQUFBQSxFQUFFLEVBQUUsSUFEQTtBQUVKTCxZQUFBQSxRQUZJO0FBR0pJLFlBQUFBO0FBSEk7QUFETSxTQUFQLENBQVA7QUFPRCxPQVhELENBV0UsT0FBT0csR0FBUCxFQUFZO0FBQ1pDLFFBQUFBLE9BQU8sQ0FBQ0MsR0FBUixDQUFZRixHQUFHLENBQUNHLE9BQWhCO0FBQ0EsZUFBTzFCLEdBQUcsQ0FBQ3FCLEVBQUosQ0FBTztBQUNaQyxVQUFBQSxJQUFJLEVBQUU7QUFDSkQsWUFBQUEsRUFBRSxFQUFFLEtBREE7QUFFSkUsWUFBQUEsR0FBRyxFQUFFQSxHQUFHLENBQUNHO0FBRkw7QUFETSxTQUFQLENBQVA7QUFNRDtBQUNGLEtBL0RxQjs7QUFDcEIsU0FBSzdCLFFBQUwsR0FBZ0JBLFFBQWhCO0FBQ0Q7O0FBSGlDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgXyBmcm9tICdsb2Rhc2gnO1xuXG4vLyBUT0RPIERSQUZUOiBBcmUgdGhlc2Ugc29ydEZpZWxkIG9wdGlvbnMgYXBwcm9wcmlhdGU/XG5leHBvcnQgY29uc3QgR0VUX0ZJTkRJTkdTX1NPUlRfRklFTERTID0ge1xuICBJTkRFWDogJ2luZGV4JyxcbiAgTU9OSVRPUl9OQU1FOiAnbW9uaXRvcl9uYW1lJyxcbiAgVElNRVNUQU1QOiAndGltZXN0YW1wJyxcbn07XG5cbi8vIFRPRE8gRFJBRlQ6IFJlc3RHZXRGaW5kaW5nc0FjdGlvbi5rdCBpbiB0aGUgYmFja2VuZCByZWZlcmVuY2VzIGEgYG1pc3NpbmdgIGZpZWxkIGluIHBhcmFtcy5cbi8vICBJbnZlc3RpZ2F0ZSBpZi9ob3cgd2Ugc2hvdWxkIG1ha2UgdXNlIG9mIHRoYXQuXG5leHBvcnQgY29uc3QgREVGQVVMVF9HRVRfRklORElOR1NfUEFSQU1TID0ge1xuICAvLyBUT0RPIERSQUZUOiBEb2VzIHByb3ZpZGluZyBhIGZpbmRpbmcgSUQgc2VydmUgYSBwYXJ0aWN1bGFyIGZ1bmN0aW9uPyBSZXN1bHRzIHdpdGgvd2l0aG91dCB0aGUgSUQgc2VlbWVkIHRoZSBzYW1lLlxuICBpZDogdW5kZWZpbmVkLFxuICBmcm9tOiAwLFxuICBzZWFyY2g6ICcnLFxuICBzaXplOiAyMCxcbiAgc29ydERpcmVjdGlvbjogJ2Rlc2MnLFxuICBzb3J0RmllbGQ6IEdFVF9GSU5ESU5HU19TT1JUX0ZJRUxEUy5USU1FU1RBTVAsXG59O1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBGaW5kaW5nU2VydmljZSB7XG4gIGNvbnN0cnVjdG9yKGVzRHJpdmVyKSB7XG4gICAgdGhpcy5lc0RyaXZlciA9IGVzRHJpdmVyO1xuICB9XG5cbiAgZ2V0RmluZGluZ3MgPSBhc3luYyAoY29udGV4dCwgcmVxLCByZXMpID0+IHtcbiAgICBjb25zdCB7XG4gICAgICBpZCA9IERFRkFVTFRfR0VUX0ZJTkRJTkdTX1BBUkFNUy5pZCxcbiAgICAgIGZyb20gPSBERUZBVUxUX0dFVF9GSU5ESU5HU19QQVJBTVMuZnJvbSxcbiAgICAgIHNpemUgPSBERUZBVUxUX0dFVF9GSU5ESU5HU19QQVJBTVMuc2l6ZSxcbiAgICAgIHNlYXJjaCA9IERFRkFVTFRfR0VUX0ZJTkRJTkdTX1BBUkFNUy5zZWFyY2gsXG4gICAgICBzb3J0RGlyZWN0aW9uID0gREVGQVVMVF9HRVRfRklORElOR1NfUEFSQU1TLnNvcnREaXJlY3Rpb24sXG4gICAgICBzb3J0RmllbGQgPSBERUZBVUxUX0dFVF9GSU5ESU5HU19QQVJBTVMuc29ydEZpZWxkLFxuICAgIH0gPSByZXEucXVlcnk7XG5cbiAgICB2YXIgcGFyYW1zO1xuICAgIHN3aXRjaCAoc29ydEZpZWxkKSB7XG4gICAgICBjYXNlIEdFVF9GSU5ESU5HU19TT1JUX0ZJRUxEUy5JTkRFWDpcbiAgICAgICAgcGFyYW1zID0ge1xuICAgICAgICAgIHNvcnRTdHJpbmc6IGAke3NvcnRGaWVsZH0ua2V5d29yZGAsXG4gICAgICAgICAgc29ydE9yZGVyOiBzb3J0RGlyZWN0aW9uLFxuICAgICAgICB9O1xuICAgICAgICBicmVhaztcbiAgICAgIGNhc2UgR0VUX0ZJTkRJTkdTX1NPUlRfRklFTERTLk1PTklUT1JfTkFNRTpcbiAgICAgICAgcGFyYW1zID0ge1xuICAgICAgICAgIHNvcnRTdHJpbmc6IGAke3NvcnRGaWVsZH0ua2V5d29yZGAsXG4gICAgICAgICAgc29ydE9yZGVyOiBzb3J0RGlyZWN0aW9uLFxuICAgICAgICB9O1xuICAgICAgICBicmVhaztcbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIC8vIElmIHRoZSBzb3J0RmllbGQgcGFyc2VkIGZyb20gdGhlIFVSTCBpc24ndCBhIHZhbGlkIG9wdGlvbiBmb3IgdGhpcyBBUEksIHVzZSBhIGRlZmF1bHQgb3B0aW9uLlxuICAgICAgICBwYXJhbXMgPSB7XG4gICAgICAgICAgc29ydFN0cmluZzogR0VUX0ZJTkRJTkdTX1NPUlRfRklFTERTLlRJTUVTVEFNUCxcbiAgICAgICAgICBzb3J0T3JkZXI6IHNvcnREaXJlY3Rpb24sXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgaWYgKCFfLmlzRW1wdHkoaWQpKSBwYXJhbXMuZmluZGluZ0lkID0gaWQ7XG4gICAgcGFyYW1zLnN0YXJ0SW5kZXggPSBmcm9tO1xuICAgIHBhcmFtcy5zaXplID0gc2l6ZTtcbiAgICBwYXJhbXMuc2VhcmNoU3RyaW5nID0gc2VhcmNoO1xuICAgIGlmIChzZWFyY2gudHJpbSgpKSBwYXJhbXMuc2VhcmNoU3RyaW5nID0gYCoke3NlYXJjaC50cmltKCkuc3BsaXQoJyAnKS5qb2luKCcqIConKX0qYDtcblxuICAgIGNvbnN0IHsgY2FsbEFzQ3VycmVudFVzZXIgfSA9IHRoaXMuZXNEcml2ZXIuYXNTY29wZWQocmVxKTtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcmVzcCA9IGF3YWl0IGNhbGxBc0N1cnJlbnRVc2VyKCdhbGVydGluZy5nZXRGaW5kaW5ncycsIHBhcmFtcyk7XG4gICAgICBjb25zdCBmaW5kaW5ncyA9IHJlc3AuZmluZGluZ3MubWFwKChyZXN1bHQpID0+ICh7IFtyZXN1bHQuZmluZGluZy5pZF06IHsgLi4ucmVzdWx0IH0gfSkpO1xuICAgICAgY29uc3QgdG90YWxGaW5kaW5ncyA9IHJlc3AudG90YWxGaW5kaW5ncztcbiAgICAgIHJldHVybiByZXMub2soe1xuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgZmluZGluZ3MsXG4gICAgICAgICAgdG90YWxGaW5kaW5ncyxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgY29uc29sZS5sb2coZXJyLm1lc3NhZ2UpO1xuICAgICAgcmV0dXJuIHJlcy5vayh7XG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyOiBlcnIubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcbn1cbiJdfQ==