/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPhysicalDeviceVariablePointersFeatures;

public class VkPhysicalDeviceVariablePointerFeatures
extends VkPhysicalDeviceVariablePointersFeatures {
    public VkPhysicalDeviceVariablePointerFeatures(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceVariablePointerFeatures.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceVariablePointerFeatures.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures variablePointersStorageBuffer(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVariablePointerFeatures.nvariablePointersStorageBuffer(this.address(), value ? 1 : 0);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures variablePointers(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVariablePointerFeatures.nvariablePointers(this.address(), value ? 1 : 0);
        return this;
    }

    @Override
    public VkPhysicalDeviceVariablePointerFeatures set(int sType, long pNext, boolean variablePointersStorageBuffer, boolean variablePointers) {
        this.sType(sType);
        this.pNext(pNext);
        this.variablePointersStorageBuffer(variablePointersStorageBuffer);
        this.variablePointers(variablePointers);
        return this;
    }

    public VkPhysicalDeviceVariablePointerFeatures set(VkPhysicalDeviceVariablePointerFeatures src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceVariablePointerFeatures malloc() {
        return (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceVariablePointerFeatures calloc() {
        return (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceVariablePointerFeatures create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceVariablePointerFeatures create(long address) {
        return (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceVariablePointerFeatures createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceVariablePointerFeatures.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceVariablePointerFeatures.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceVariablePointerFeatures mallocStack() {
        return VkPhysicalDeviceVariablePointerFeatures.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceVariablePointerFeatures callocStack() {
        return VkPhysicalDeviceVariablePointerFeatures.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceVariablePointerFeatures mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceVariablePointerFeatures callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceVariablePointerFeatures)VkPhysicalDeviceVariablePointerFeatures.wrap(VkPhysicalDeviceVariablePointerFeatures.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceVariablePointerFeatures.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceVariablePointerFeatures.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkPhysicalDeviceVariablePointersFeatures.Buffer {
        private static final VkPhysicalDeviceVariablePointerFeatures ELEMENT_FACTORY = VkPhysicalDeviceVariablePointerFeatures.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceVariablePointerFeatures getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceVariablePointerFeatures.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceVariablePointerFeatures.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer variablePointersStorageBuffer(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVariablePointerFeatures.nvariablePointersStorageBuffer(this.address(), value ? 1 : 0);
            return this;
        }

        @Override
        public Buffer variablePointers(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVariablePointerFeatures.nvariablePointers(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

