/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMappedMemoryRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int OFFSET;
    public static final int SIZE;

    public VkMappedMemoryRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMappedMemoryRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMappedMemoryRange.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMappedMemoryRange.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMappedMemoryRange.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkMappedMemoryRange.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkMappedMemoryRange.nsize(this.address());
    }

    public VkMappedMemoryRange sType(@NativeType(value="VkStructureType") int value) {
        VkMappedMemoryRange.nsType(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange pNext(@NativeType(value="void const *") long value) {
        VkMappedMemoryRange.npNext(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMappedMemoryRange.nmemory(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange offset(@NativeType(value="VkDeviceSize") long value) {
        VkMappedMemoryRange.noffset(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange size(@NativeType(value="VkDeviceSize") long value) {
        VkMappedMemoryRange.nsize(this.address(), value);
        return this;
    }

    public VkMappedMemoryRange set(int sType, long pNext, long memory, long offset, long size) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkMappedMemoryRange set(VkMappedMemoryRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMappedMemoryRange malloc() {
        return (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMappedMemoryRange calloc() {
        return (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMappedMemoryRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMappedMemoryRange create(long address) {
        return (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)address);
    }

    @Nullable
    public static VkMappedMemoryRange createSafe(long address) {
        return address == 0L ? null : (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMappedMemoryRange.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMappedMemoryRange.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkMappedMemoryRange mallocStack() {
        return VkMappedMemoryRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkMappedMemoryRange callocStack() {
        return VkMappedMemoryRange.callocStack(MemoryStack.stackGet());
    }

    public static VkMappedMemoryRange mallocStack(MemoryStack stack) {
        return (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMappedMemoryRange callocStack(MemoryStack stack) {
        return (VkMappedMemoryRange)VkMappedMemoryRange.wrap(VkMappedMemoryRange.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkMappedMemoryRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkMappedMemoryRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkMappedMemoryRange.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void noffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkMappedMemoryRange.__struct((Struct.Member[])new Struct.Member[]{VkMappedMemoryRange.__member((int)4), VkMappedMemoryRange.__member((int)POINTER_SIZE), VkMappedMemoryRange.__member((int)8), VkMappedMemoryRange.__member((int)8), VkMappedMemoryRange.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
        SIZE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkMappedMemoryRange, Buffer>
    implements NativeResource {
        private static final VkMappedMemoryRange ELEMENT_FACTORY = VkMappedMemoryRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMappedMemoryRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMappedMemoryRange.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMappedMemoryRange.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMappedMemoryRange.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkMappedMemoryRange.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkMappedMemoryRange.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMappedMemoryRange.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMappedMemoryRange.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMappedMemoryRange.nmemory(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkMappedMemoryRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkMappedMemoryRange.nsize(this.address(), value);
            return this;
        }
    }
}

