/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.JitsiMeetConfig;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.BaseJibri;
import org.jitsi.jicofo.jibri.JibriStats;
import org.jitsi.jicofo.stats.Statistics;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.QueueStatistics;
import org.jitsi.utils.stats.ConferenceSizeBuckets;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;

public class FocusManager
implements JitsiMeetConferenceImpl.ConferenceListener,
ConferenceStore {
    private static final Logger logger = new LoggerImpl(FocusManager.class.getName());
    private final FocusExpireThread expireThread = new FocusExpireThread();
    private final Map<EntityBareJid, JitsiMeetConferenceImpl> conferences = new ConcurrentHashMap<EntityBareJid, JitsiMeetConferenceImpl>();
    private final List<JitsiMeetConference> conferencesCache = new CopyOnWriteArrayList<JitsiMeetConference>();
    private final Object conferencesSyncRoot = new Object();
    private final List<ConferenceStore.Listener> listeners = new ArrayList<ConferenceStore.Listener>();
    private final Map<EntityBareJid, PinnedConference> pinnedConferences = new HashMap<EntityBareJid, PinnedConference>();
    private final Statistics statistics = new Statistics();
    private final Clock clock;

    public FocusManager(Clock clock) {
        this.clock = clock;
    }

    public FocusManager() {
        this(Clock.systemUTC());
    }

    public void start() {
        this.expireThread.start();
    }

    public void stop() {
        this.expireThread.stop();
    }

    public boolean conferenceRequest(EntityBareJid room, Map<String, String> properties2) throws Exception {
        return this.conferenceRequest(room, properties2, Level.ALL);
    }

    public boolean conferenceRequest(EntityBareJid room, Map<String, String> properties2, Level loggingLevel) throws Exception {
        return this.conferenceRequest(room, properties2, loggingLevel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conferenceRequest(EntityBareJid room, Map<String, String> properties2, Level loggingLevel, boolean includeInStatistics) throws Exception {
        boolean isConferenceCreator;
        JitsiMeetConferenceImpl conference;
        if (room == null) {
            return false;
        }
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            conference = this.conferences.get(room);
            boolean bl = isConferenceCreator = conference == null;
            if (isConferenceCreator) {
                conference = this.createConference(room, properties2, loggingLevel, includeInStatistics);
            }
        }
        try {
            if (isConferenceCreator) {
                conference.start();
            }
        }
        catch (Exception e) {
            logger.warn("Exception while trying to start the conference", e);
            throw e;
        }
        return conference.isStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JitsiMeetConferenceImpl createConference(@NotNull EntityBareJid room, Map<String, String> properties2, Level logLevel, boolean includeInStatistics) {
        JitsiMeetConferenceImpl conference;
        JitsiMeetConfig config = new JitsiMeetConfig(properties2);
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            String jvbVersion = this.getBridgeVersionForConference(room);
            conference = new JitsiMeetConferenceImpl(room, this, config, logLevel, jvbVersion, includeInStatistics);
            this.conferences.put(room, conference);
            this.conferencesCache.add(conference);
        }
        if (includeInStatistics) {
            this.statistics.totalConferencesCreated.incrementAndGet();
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conferenceEnded(JitsiMeetConferenceImpl conference) {
        EntityBareJid roomName = conference.getRoomName();
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            ArrayList<ConferenceStore.Listener> listeners;
            this.conferences.remove(roomName);
            this.conferencesCache.remove(conference);
            List<ConferenceStore.Listener> list = this.listeners;
            synchronized (list) {
                listeners = new ArrayList<ConferenceStore.Listener>(this.listeners);
            }
            for (ConferenceStore.Listener listener : listeners) {
                listener.conferenceEnded(roomName);
            }
        }
    }

    @Override
    public void participantsMoved(int count) {
        this.statistics.totalParticipantsMoved.addAndGet(count);
    }

    @Override
    public void participantIceFailed() {
        this.statistics.totalParticipantsIceFailed.incrementAndGet();
    }

    @Override
    public void participantRequestedRestart() {
        this.statistics.totalParticipantsRequestedRestart.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JitsiMeetConferenceImpl getConference(@NotNull EntityBareJid roomName) {
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            return this.conferences.get(roomName);
        }
    }

    @Override
    @NotNull
    public List<JitsiMeetConference> getAllConferences() {
        return this.getConferences();
    }

    public List<JitsiMeetConference> getConferences() {
        return this.conferencesCache;
    }

    private int getNonHealthCheckConferenceCount() {
        return (int)this.conferences.values().stream().filter(JitsiMeetConferenceImpl::includeInStatistics).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(@NotNull ConferenceStore.Listener listener) {
        List<ConferenceStore.Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(@NotNull ConferenceStore.Listener listener) {
        List<ConferenceStore.Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public JSONObject getStats() {
        JSONObject stats = new JSONObject();
        stats.put("total_participants", this.statistics.totalParticipants.get());
        stats.put("total_participants_no_multi_stream", this.statistics.totalParticipantsNoMultiStream.get());
        stats.put("total_participants_no_source_name", this.statistics.totalParticipantsNoSourceName.get());
        stats.put("total_conferences_created", this.statistics.totalConferencesCreated.get());
        stats.put("conferences", this.getNonHealthCheckConferenceCount());
        JSONObject bridgeFailures = new JSONObject();
        bridgeFailures.put("participants_moved", this.statistics.totalParticipantsMoved.get());
        stats.put("bridge_failures", bridgeFailures);
        JSONObject participantNotifications = new JSONObject();
        participantNotifications.put("ice_failed", this.statistics.totalParticipantsIceFailed.get());
        participantNotifications.put("request_restart", this.statistics.totalParticipantsRequestedRestart.get());
        stats.put("participant_notifications", participantNotifications);
        int numParticipants = 0;
        int largestConferenceSize = 0;
        ConferenceSizeBuckets conferenceSizes = new ConferenceSizeBuckets();
        int endpointPairs = 0;
        HashSet<BaseJibri> jibriRecordersAndGateways = new HashSet<BaseJibri>();
        for (JitsiMeetConference conference : this.getConferences()) {
            if (!conference.includeInStatistics()) continue;
            int confSize = conference.getParticipantCount();
            if (confSize == 0) {
                confSize = 1;
            }
            numParticipants += confSize;
            endpointPairs += confSize * confSize;
            largestConferenceSize = Math.max(largestConferenceSize, confSize);
            conferenceSizes.addValue(confSize);
            jibriRecordersAndGateways.add(conference.getJibriRecorder());
            jibriRecordersAndGateways.add(conference.getJibriSipGateway());
        }
        stats.put("largest_conference", largestConferenceSize);
        stats.put("participants", numParticipants);
        stats.put("conference_sizes", conferenceSizes.toJson());
        stats.put("endpoint_pairs", endpointPairs);
        stats.put("jibri", JibriStats.getStats(jibriRecordersAndGateways));
        stats.put("queues", QueueStatistics.Companion.getStatistics());
        return stats;
    }

    @NotNull
    public Statistics getStatistics() {
        return this.statistics;
    }

    @NotNull
    OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject o = new OrderedJsonObject();
        for (JitsiMeetConference conference : this.getConferences()) {
            if (full) {
                o.put(conference.getRoomName().toString(), conference.getDebugState());
                continue;
            }
            o.put(conference.getRoomName().toString(), (Object)conference.getParticipantCount());
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pinConference(@NotNull EntityBareJid roomName, @NotNull String jvbVersion, @NotNull Duration duration) {
        PinnedConference pc = new PinnedConference(jvbVersion, duration);
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            PinnedConference prev = this.pinnedConferences.remove(roomName);
            if (prev != null) {
                logger.info(() -> "Modifying pin for " + roomName + ":");
            }
            this.pinnedConferences.put(roomName, pc);
        }
        logger.info(() -> {
            long minutes;
            return "Pinning " + roomName + " to version \"" + jvbVersion + "\" for " + minutes + ((minutes = duration.toMinutes()) == 1L ? " minute." : " minutes.");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpinConference(@NotNull EntityBareJid roomName) {
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            PinnedConference prev = this.pinnedConferences.remove(roomName);
            if (prev != null) {
                logger.info(() -> "Removing pin for " + roomName);
            } else {
                logger.info(() -> "Unpin failed: " + roomName);
            }
        }
    }

    private void expirePins(Instant curTime) {
        if (this.pinnedConferences.values().removeIf(v -> v.expiresAt.isBefore(curTime))) {
            logger.info("Some pins have expired.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBridgeVersionForConference(@NotNull EntityBareJid roomName) {
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            this.expirePins(this.clock.instant());
            PinnedConference pc = this.pinnedConferences.get(roomName);
            return pc != null ? pc.jvbVersion : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getPinnedConferences() {
        Instant curTime = this.clock.instant();
        ZoneId tz = ZoneId.systemDefault();
        JSONArray pins = new JSONArray();
        Object object = this.conferencesSyncRoot;
        synchronized (object) {
            this.expirePins(curTime);
            this.pinnedConferences.forEach((k, v) -> {
                JSONObject pin = new JSONObject();
                pin.put("conference-id", k.toString());
                pin.put("jvb-version", v.jvbVersion);
                pin.put("expires-at", v.expiresAt.atZone(tz).toString());
                pins.add(pin);
            });
        }
        JSONObject stats = new JSONObject();
        stats.put("pins", pins);
        return stats;
    }

    private class PinnedConference {
        @NotNull
        final String jvbVersion;
        @NotNull
        final Instant expiresAt;

        public PinnedConference(@NotNull String jvbVersion, Duration duration) {
            this.jvbVersion = jvbVersion;
            this.expiresAt = FocusManager.this.clock.instant().plus(duration).truncatedTo(ChronoUnit.SECONDS);
        }
    }

    private class FocusExpireThread {
        private static final long POLL_INTERVAL = 5000L;
        private final Duration timeout = ConferenceConfig.config.getConferenceStartTimeout();
        private Thread timeoutThread;
        private final Object sleepLock = new Object();
        private boolean enabled;

        private FocusExpireThread() {
        }

        void start() {
            if (this.timeoutThread != null) {
                throw new IllegalStateException();
            }
            this.timeoutThread = new Thread(this::expireLoop, "FocusExpireThread");
            this.enabled = true;
            this.timeoutThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            if (this.timeoutThread == null) {
                return;
            }
            this.enabled = false;
            Object object = this.sleepLock;
            synchronized (object) {
                this.sleepLock.notifyAll();
            }
            try {
                if (Thread.currentThread() != this.timeoutThread) {
                    this.timeoutThread.join();
                }
                this.timeoutThread = null;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expireLoop() {
            while (this.enabled) {
                try {
                    Object object = this.sleepLock;
                    synchronized (object) {
                        this.sleepLock.wait(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.enabled) break;
                try {
                    ArrayList<JitsiMeetConferenceImpl> conferenceCopy;
                    Iterator<JitsiMeetConferenceImpl> iterator2 = FocusManager.this.conferencesSyncRoot;
                    synchronized (iterator2) {
                        conferenceCopy = new ArrayList<JitsiMeetConferenceImpl>(FocusManager.this.conferences.values());
                    }
                    for (JitsiMeetConferenceImpl conference : conferenceCopy) {
                        if (conference.hasHadAtLeastOneParticipant() || Duration.between(conference.getCreationTime(), Instant.now()).compareTo(this.timeout) <= 0) continue;
                        conference.stop();
                    }
                }
                catch (Exception ex) {
                    logger.warn("Error while checking for timed out conference", ex);
                }
            }
        }
    }
}

