/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.AbstractXmppProvider;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.impl.protocol.xmpp.ChatRoomImpl;
import org.jitsi.impl.protocol.xmpp.OperationSetJingleImpl;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.impl.protocol.xmpp.log.PacketDebugger;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.discovery.DiscoveryUtil;
import org.jitsi.jicofo.xmpp.XmppConnectionConfig;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.retry.RetryStrategy;
import org.jitsi.retry.SimpleRetryTask;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.TrustAllHostnameVerifier;
import org.jitsi.xmpp.TrustAllX509TrustManager;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class XmppProviderImpl
extends AbstractXmppProvider {
    private final Logger logger;
    @NotNull
    private final OperationSetJingleImpl jingleOpSet;
    private final Muc muc = new Muc();
    @NotNull
    private final AbstractXMPPConnection connection;
    private final AtomicBoolean started = new AtomicBoolean(false);
    @NotNull
    private final RetryStrategy connectRetry;
    @NotNull
    private final XmppConnectionListener connListener = new XmppConnectionListener();
    @NotNull
    private final XmppReConnectionListener reConnListener = new XmppReConnectionListener();
    @NotNull
    private final XmppConnectionConfig config;

    public XmppProviderImpl(@NotNull XmppConnectionConfig config, @NotNull Logger parentLogger) {
        this.config = config;
        this.logger = parentLogger.createChildLogger(XmppProviderImpl.class.getName());
        this.logger.addContext("xmpp_connection", config.getName());
        EntityCapsManager.setDefaultEntityNode("http://jitsi.org/jicofo");
        this.jingleOpSet = new OperationSetJingleImpl(this);
        this.connection = this.createXmppConnection();
        this.connectRetry = new RetryStrategy(TaskPools.getScheduledPool());
    }

    public String toString() {
        return "XmppProviderImpl " + this.config;
    }

    @Override
    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            this.logger.info("Already started.");
            return;
        }
        this.connectRetry.runRetryingTask(new SimpleRetryTask(0L, 5000L, true, this::doConnect));
    }

    private AbstractXMPPConnection createXmppConnection() {
        XMPPTCPConnectionConfiguration.Builder connConfig = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost(this.config.getHostname())).setPort(this.config.getPort())).setXmppDomain(this.config.getDomain());
        if (PacketDebugger.isEnabled()) {
            connConfig.setDebuggerFactory(connection -> new PacketDebugger(connection, this.config.getName()));
        }
        if (!this.config.getUseTls()) {
            connConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
        } else {
            connConfig.setSecurityMode(ConnectionConfiguration.SecurityMode.ifpossible);
        }
        ReconnectionManager.setEnabledPerDefault(true);
        SASLAuthentication.unregisterSASLMechanism("org.jivesoftware.smack.sasl.javax.SASLGSSAPIMechanism");
        if (this.config.getPassword() == null) {
            connConfig.performSaslAnonymousAuthentication();
        }
        if (this.config.getDisableCertificateVerification()) {
            this.logger.warn("Disabling TLS certificate verification!");
            connConfig.setCustomX509TrustManager(new TrustAllX509TrustManager());
            connConfig.setHostnameVerifier(new TrustAllHostnameVerifier());
        }
        XMPPTCPConnection connection2 = new XMPPTCPConnection(connConfig.build());
        ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection2);
        serviceDiscoveryManager.addFeature("https://jitsi.org/meet/jicofo/terminate-restart");
        EntityCapsManager capsManager = EntityCapsManager.getInstanceFor(connection2);
        capsManager.enableEntityCaps();
        return connection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect() {
        if (!this.started.get()) {
            return false;
        }
        XmppProviderImpl xmppProviderImpl = this;
        synchronized (xmppProviderImpl) {
            try {
                this.connection.connect();
                this.logger.info("Connected, JID=" + this.connection.getUser());
                this.connection.addConnectionListener(this.connListener);
                ReconnectionManager.getInstanceFor(this.connection).addReconnectionListener(this.reConnListener);
                if (this.config.getPassword() != null) {
                    String login = this.config.getUsername().toString();
                    String pass = this.config.getPassword();
                    Resourcepart resource = this.config.getUsername();
                    this.connection.login(login, pass, resource);
                }
                this.connection.registerIQRequestHandler(this.jingleOpSet);
                return false;
            }
            catch (Exception e) {
                this.logger.error("Failed to connect/login: " + e.getMessage(), e);
                this.connection.removeConnectionListener(this.connListener);
                ReconnectionManager reconnectionManager = ReconnectionManager.getInstanceFor(this.connection);
                if (reconnectionManager != null) {
                    reconnectionManager.removeReconnectionListener(this.reConnListener);
                }
                if (this.connection.isConnected()) {
                    this.connection.disconnect();
                }
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!this.started.compareAndSet(true, false)) {
            this.logger.info("Already stopped or not started.");
            return;
        }
        XmppProviderImpl xmppProviderImpl = this;
        synchronized (xmppProviderImpl) {
            this.connectRetry.cancel();
            this.connection.disconnect();
            this.logger.info("Disconnected.");
            this.connection.unregisterIQRequestHandler(this.jingleOpSet);
            this.connection.removeConnectionListener(this.connListener);
        }
        this.setRegistered(false);
    }

    @Override
    @NotNull
    public XmppConnectionConfig getConfig() {
        return this.config;
    }

    @Override
    public AbstractXMPPConnection getXmppConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public OperationSetJingle getJingleApi() {
        return this.jingleOpSet;
    }

    @Override
    @NotNull
    public ChatRoom createRoom(@NotNull EntityBareJid name) throws XmppProvider.RoomExistsException {
        return this.muc.createChatRoom(name);
    }

    @Override
    @NotNull
    public ChatRoom findOrCreateRoom(@NotNull EntityBareJid name) {
        return this.muc.findOrCreateRoom(name);
    }

    @Override
    protected void fireRegistrationStateChanged(boolean registered) {
        super.fireRegistrationStateChanged(registered);
        if (registered) {
            AbstractXMPPConnection xmppConnection = this.getXmppConnection();
            xmppConnection.setReplyTimeout(this.config.getReplyTimeout().toMillis());
            this.logger.info("Set replyTimeout=" + this.config.getReplyTimeout());
        }
    }

    @Override
    @NotNull
    public List<String> discoverFeatures(@NotNull EntityFullJid jid) {
        return DiscoveryUtil.discoverParticipantFeatures(this, jid);
    }

    @Override
    @Nullable
    public DiscoverInfo discoverInfo(@NotNull Jid jid) {
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor(this.getXmppConnection());
        if (discoveryManager == null) {
            this.logger.info("Can not discover info, no ServiceDiscoveryManager");
            return null;
        }
        try {
            return discoveryManager.discoverInfo(jid);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            this.logger.warn("Failed to discover info", e);
            return null;
        }
    }

    static {
        XMPPTCPConnection.setUseStreamManagementResumptionDefault(false);
        XMPPTCPConnection.setUseStreamManagementDefault(false);
    }

    private class Muc {
        private final Map<String, ChatRoomImpl> rooms = new HashMap<String, ChatRoomImpl>();

        private Muc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChatRoom createChatRoom(EntityBareJid roomJid) throws XmppProvider.RoomExistsException {
            String roomName = roomJid.toString();
            Map<String, ChatRoomImpl> map = this.rooms;
            synchronized (map) {
                if (this.rooms.containsKey(roomName)) {
                    throw new XmppProvider.RoomExistsException("Room '" + roomName + "' exists");
                }
                ChatRoomImpl newRoom = new ChatRoomImpl(XmppProviderImpl.this, roomJid, this::removeRoom);
                this.rooms.put(newRoom.getRoomJid().toString(), newRoom);
                return newRoom;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChatRoom findOrCreateRoom(EntityBareJid roomJid) {
            String roomName = roomJid.toString().toLowerCase();
            Map<String, ChatRoomImpl> map = this.rooms;
            synchronized (map) {
                ChatRoom room = this.rooms.get(roomName);
                if (room == null) {
                    try {
                        room = this.createChatRoom(roomJid);
                    }
                    catch (XmppProvider.RoomExistsException e) {
                        throw new RuntimeException("Unexpected RoomExistsException.");
                    }
                }
                return room;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeRoom(ChatRoomImpl chatRoom) {
            Map<String, ChatRoomImpl> map = this.rooms;
            synchronized (map) {
                this.rooms.remove(chatRoom.getRoomJid().toString());
            }
        }
    }

    private class XmppReConnectionListener
    implements ReconnectionListener {
        private XmppReConnectionListener() {
        }

        @Override
        public void reconnectingIn(int i) {
            XmppProviderImpl.this.logger.info("XMPP reconnecting in: " + i);
        }

        @Override
        public void reconnectionFailed(Exception e) {
            XmppProviderImpl.this.logger.error("XMPP reconnection failed: " + e.getMessage());
        }
    }

    class XmppConnectionListener
    implements ConnectionListener {
        XmppConnectionListener() {
        }

        @Override
        public void connected(XMPPConnection connection) {
        }

        @Override
        public void authenticated(XMPPConnection connection, boolean resumed) {
            XmppProviderImpl.this.setRegistered(true);
        }

        @Override
        public void connectionClosed() {
            XmppProviderImpl.this.logger.info("XMPP connection closed");
            XmppProviderImpl.this.setRegistered(false);
        }

        @Override
        public void connectionClosedOnError(Exception e) {
            XmppProviderImpl.this.logger.error("XMPP connection closed on error: " + e.getMessage());
            XmppProviderImpl.this.setRegistered(false);
        }
    }
}

